/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.io.File;
import java.net.URL;
import java.text.ParseException;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.generic.util.VCSCompareCommand;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoricalContentCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntryProducer;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class AbstractSVNCompareOperation
extends VCSCompareCommand {
    public AbstractSVNCompareOperation(String commandId) {
        super(commandId);
    }

    protected boolean isDirectoryCompareSupported() {
        return true;
    }

    protected DirectoryList listDirectory(URL directoryUrl) throws Exception {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        DirectoryList directoryList = new DirectoryList();
        URLFileSystem.FileInfo[] fileInfoArray = URLFileSystem.ls((URL)directoryUrl);
        int n = 0;
        while (n < fileInfoArray.length) {
            URLFileSystem.FileInfo info = fileInfoArray[n];
            if (!URLFileSystem.getFileName((URL)info.getURL()).equals(".svn")) {
                VCSStatus status = this.getStatusCache().get(info.getURL());
                String id = status.isVersioned() && !SVNUtil.isModified(status, profile) ? Long.toString(SVNURLInfoCache.getInstance().getLastChangedRevision(info.getURL())) : Long.toString(Long.MAX_VALUE);
                directoryList.appendFile((DirectoryFile)new 1(this, info.isDirectory(), URLFileSystem.getFileName((URL)info.getURL()), id, info));
            }
            ++n;
        }
        return directoryList;
    }

    protected CompareContributor getHistoricalContributor(VCSProfile profile, Locatable source, Object revisionObject) throws Exception {
        return this.getHistoricalContributor(profile, source.getURL(), revisionObject);
    }

    protected CompareContributor getHistoricalContributor(VCSProfile profile, URL sourceUrl, Object revisionObject) throws Exception {
        SVNRevision revision = (SVNRevision)revisionObject;
        if (URLFileSystem.isDirectoryPath((URL)sourceUrl)) {
            String label = SVNUtil.getCompareIdentifier(sourceUrl, revision);
            return this.createDirectoryContributor(sourceUrl, this.listDirectory(sourceUrl, revision), label);
        }
        SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(sourceUrl);
        if (reposUrl == null) {
            throw new IllegalStateException();
        }
        SVNHistoricalContentCache contentCache = SVNHistoricalContentCache.getInstance();
        if (!contentCache.containsRevisionContent(reposUrl, revision)) {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(AbstractSVNOperation.CLIENT_CONTEXT);
            contentCache.putRevisionContentStream(reposUrl, revision, client.getContent(reposUrl, revision));
        }
        String resourceName = SVNUtil.getCompareIdentifier(sourceUrl, revision);
        return new InputStreamTextContributor(contentCache.getRevisionContentStream(reposUrl, revision), resourceName, resourceName, URLFileSystem.getSuffix((URL)sourceUrl));
    }

    private DirectoryList listDirectory(URL directoryUrl, SVNRevision revision) throws SVNClientException, ParseException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNHistoryEntryProducer.CLIENT_CONTEXT);
        ISVNDirEntry[] dirEntries = client.getList(new File(URLFileSystem.getPlatformPathName((URL)directoryUrl)), revision, false);
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        DirectoryList directoryList = new DirectoryList();
        ISVNDirEntry[] iSVNDirEntryArray = dirEntries;
        int n = 0;
        while (n < iSVNDirEntryArray.length) {
            ISVNDirEntry dirEntry = iSVNDirEntryArray[n];
            boolean directory = dirEntry.getNodeKind() == SVNNodeKind.DIR;
            String name = dirEntry.getPath().replace('\\', '/');
            name = name.substring(name.lastIndexOf(47) + 1);
            String id = Long.toString(dirEntry.getLastChangedRevision().getNumber());
            directoryList.appendFile((DirectoryFile)new 2(this, directory, name, id, directoryUrl, profile));
            ++n;
        }
        directoryList.clearModified();
        return directoryList;
    }

    static CompareContributor mav$getCurrentContributor(AbstractSVNCompareOperation abstractSVNCompareOperation, URL uRL) {
        return abstractSVNCompareOperation.getCurrentContributor(uRL);
    }

    final class 1
    extends DirectoryFile {
        private final /* synthetic */ URLFileSystem.FileInfo v$info;
        static final /* synthetic */ boolean $assertionsDisabled;
        final /* synthetic */ AbstractSVNCompareOperation this$0;

        static {
            $assertionsDisabled = 1.class.desiredAssertionStatus() ^ true;
        }

        public CompareContributor createCompareContributor() throws Exception {
            if (!$assertionsDisabled && URLFileSystem.isDirectoryPath((URL)this.v$info.getURL()) != this.isDirectory()) {
                throw new AssertionError();
            }
            return AbstractSVNCompareOperation.mav$getCurrentContributor(this.this$0, this.v$info.getURL());
        }

        public 1(AbstractSVNCompareOperation abstractSVNCompareOperation, boolean bl, String string, String string2, URLFileSystem.FileInfo fileInfo) {
            this.v$info = fileInfo;
            this.this$0 = abstractSVNCompareOperation;
            super(bl, string, string2);
        }
    }

    final class 2
    extends DirectoryFile {
        private final /* synthetic */ URL v$directoryUrl;
        private final /* synthetic */ VCSProfile v$profile;
        final /* synthetic */ AbstractSVNCompareOperation this$0;

        public CompareContributor createCompareContributor() throws Exception {
            URL url = this.isDirectory() ? URLFactory.newDirURL((URL)this.v$directoryUrl, (String)this.getName()) : URLFactory.newURL((URL)this.v$directoryUrl, (String)this.getName());
            return this.this$0.getHistoricalContributor(this.v$profile, url, (Object)SVNRevision.getRevision((String)this.getID()));
        }

        public 2(AbstractSVNCompareOperation abstractSVNCompareOperation, boolean bl, String string, String string2, URL uRL, VCSProfile vCSProfile) {
            this.v$profile = vCSProfile;
            this.v$directoryUrl = uRL;
            this.this$0 = abstractSVNCompareOperation;
            super(bl, string, string2);
        }
    }
}

