/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.op.ui.SVNVersionOperationPanel;
import oracle.jdevimpl.vcs.svn.util.SVNComponents;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public abstract class AbstractSVNOperation
extends ActionCommand {
    public static final String OPTION_RECURSIVE = "oracle.jdeveloper.subversion.RECURSIVE";
    public static final String OPTION_REVISION = "oracle.jdeveloper.subversion.REVISION";
    public static final String OPTION_IGNORE_EXTERNALS = "oracle.jdeveloper.subversion.IGNORE_EXTERNALS";
    public static final String OPTION_KEEP_LOCKS = "oracle.jdeveloper.subversion.KEEP_LOCKS";
    public static final String OPTION_STEAL_LOCKS = "oracle.jdeveloper.subversion.STEAL_LOCKS";
    public static final String OPTION_FORCE_UNLOCK = "oracle.jdeveloper.subversion.FORCE_LOCKS";
    public static Object CLIENT_CONTEXT = new Object();
    protected static final String PROPERTY_RESOURCES_CREATED = AbstractSVNOperation.class.getName() + ".resourcesCreated";
    protected static final String PROPERTY_RESOURCES_DELETED = AbstractSVNOperation.class.getName() + ".resourcesDeleted";
    protected static final String PROPERTY_RESOURCES_STRUCTURE_CHANGED = AbstractSVNOperation.class.getName() + ".resourcesStructChanged";
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(AbstractSVNOperation.class.getName());
    protected ResourcePicker _res;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    protected AbstractSVNOperation(String commandId) {
        super(commandId);
        this.$init$();
    }

    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer();
        JEWTDialog dialog = this.createOperationDialog(Arrays.asList(commandState.getLocatables()), customizer);
        dialog.addVetoableChangeListener((VetoableChangeListener)((Object)new 1(this, customizer, dialog, commandState, profile)));
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    private SVNVersionOperationPanel getVersionOperationPanel(JEWTDialog dialog) {
        JPanel content = (JPanel)dialog.getContent();
        Component[] components = content.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof VersionOperationPanel) {
                return (SVNVersionOperationPanel)((Object)components[i]);
            }
            ++i;
        }
        return null;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)SVNComponents.createFileListerComponent(nodes), (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        URL[] eventUrls;
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        URL[] urls = processed.toArray(new URL[processed.size()]);
        if (processed.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)commandState.getTimestampMap());
        }
        boolean recursive = false;
        Boolean b = (Boolean)commandState.getProperty(OPTION_RECURSIVE);
        recursive = b != null ? b : false;
        profile.getStatusCache().clear(urls);
        SVNURLInfoCache.getInstance().clear(urls);
        if (recursive) {
            ArrayList<URL> directories = new ArrayList<URL>(urls.length);
            int i = 0;
            while (i < urls.length) {
                if (URLFileSystem.isDirectoryPath((URL)urls[i])) {
                    directories.add(urls[i]);
                }
                ++i;
            }
            URLFilter f = VCSURLFilters.createBaseURLContentsFilter((URL[])directories.toArray(new URL[directories.size()]));
            profile.getStatusCache().clear(f);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_CREATED)) != null && eventUrls.length > 0) {
            this.fireSomeFilesCreated(eventUrls);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_DELETED)) != null && eventUrls.length > 0) {
            this.fireDeletionEvents(eventUrls);
        }
        if ((eventUrls = (URL[])commandState.getProperty(PROPERTY_RESOURCES_STRUCTURE_CHANGED)) != null && eventUrls.length > 0) {
            this.fireFileStructureChanged(eventUrls);
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    protected void collapseSelectionToWorkingCopy(CommandState state) {
        Locatable workingCopyRoot = null;
        Locatable[] selection = state.getLocatables();
        int i = 0;
        while (i < selection.length && workingCopyRoot == null) {
            URL url = SVNUtil.resolveWorkingCopy(selection[i].getURL());
            workingCopyRoot = url != null ? VCSModelUtils.findOrCreateNodes((URL[])new URL[]{url})[0] : null;
            ++i;
        }
        state.setLocatables(new Locatable[]{workingCopyRoot});
    }

    private void fireDeletionEvents(URL[] deleted) {
        ArrayList<URL> files = new ArrayList<URL>(deleted.length * 2);
        ArrayList<URL> dirs = new ArrayList<URL>(deleted.length * 2);
        int i = 0;
        while (i < deleted.length) {
            if (URLFileSystem.isDirectoryPath((URL)deleted[i])) {
                dirs.add(deleted[i]);
            } else {
                files.add(deleted[i]);
            }
            ++i;
        }
        this.fireSomeFilesDeleted(files.toArray(new URL[files.size()]));
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            Node[] nodes = VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{(URL)it.next()}));
            this.fireSomeFilesDeleted(VCSModelUtils.convertNodesToURLs((Locatable[])nodes));
        }
    }

    protected Collection getProcessedUrlsNotifier(CommandState commandState) {
        ArrayList c = (ArrayList)commandState.getProperty("svn.processed.urls");
        if (c == null) {
            c = new ArrayList(30);
            commandState.setProperty("svn.processed.urls", c);
        }
        return c;
    }

    static SVNVersionOperationPanel mav$getVersionOperationPanel(AbstractSVNOperation abstractSVNOperation, JEWTDialog jEWTDialog) {
        return abstractSVNOperation.getVersionOperationPanel(jEWTDialog);
    }

    static boolean mav$invokeCommandImpl(AbstractSVNOperation abstractSVNOperation, VCSProfile vCSProfile, CommandState commandState, Component component, Map map) {
        return abstractSVNOperation.invokeCommandImpl(vCSProfile, commandState, component, map);
    }

    final class 1
    extends VCSDialogCommitter {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ CommandState v$commandState;
        private final /* synthetic */ VCSProfile v$profile;
        final /* synthetic */ AbstractSVNOperation this$0;

        protected boolean doCommitOperation(Map options) throws Exception {
            SVNVersionOperationPanel panel = AbstractSVNOperation.mav$getVersionOperationPanel(this.this$0, this.v$dialog);
            Locatable[] locatables = panel.getSelectedLocatables();
            this.v$commandState.setLocatables(locatables);
            return AbstractSVNOperation.mav$invokeCommandImpl(this.this$0, this.v$profile, this.v$commandState, (Component)this.v$dialog, options);
        }

        public 1(AbstractSVNOperation abstractSVNOperation, VCSOptionsCustomizer vCSOptionsCustomizer, JEWTDialog jEWTDialog, CommandState commandState, VCSProfile vCSProfile) {
            this.v$profile = vCSProfile;
            this.v$commandState = commandState;
            this.v$dialog = jEWTDialog;
            this.this$0 = abstractSVNOperation;
            super(vCSOptionsCustomizer);
        }
    }
}

