/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.view.View;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.op.ui.PropertyEditorPanel;
import oracle.jdevimpl.vcs.svn.properties.SVNPropertiesWindow;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNOperationAddProperty
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.addproperty";
    private JEWTDialog _dialog;
    private PropertyEditorPanel _panel;
    private File _resourceFile;
    private NiceTable _table;
    private SVNPropertiesWindow _propertiesWindow;
    private URL[] _selectedUrls;

    public SVNOperationAddProperty() {
        super(COMMAND_ID);
    }

    public SVNOperationAddProperty(String commandID) {
        super(commandID);
    }

    protected boolean isAvailableImpl() throws Exception {
        View view = this.getContext().getView();
        if (this.isSVNPropertiesWindowView(view)) {
            this._propertiesWindow = (SVNPropertiesWindow)view;
            this._table = this._propertiesWindow.getTable();
            if (this._propertiesWindow.getResource() != null) {
                return true;
            }
        }
        return super.isAvailableImpl();
    }

    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        if (commandState.getLocatables().length == 1) {
            return this.invokeCommandImpl(profile, commandState, VCSWindowUtils.getCurrentWindow(), null);
        }
        return super.invokeCommand(profile, commandState);
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState state, Component parentUi, Map options) throws Exception {
        this._selectedUrls = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])state.getLocatables()));
        this._resourceFile = this.getResourceFile(this._selectedUrls);
        if (this._resourceFile == null) {
            return false;
        }
        this._panel = this.createPanel();
        this._dialog = this.createDialog();
        this.initListeners();
        if (this._dialog.runDialog()) {
            this.refreshSVNPropertiesWindowView();
            return true;
        }
        return false;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeCommandImpl(profile, commandState, null, options);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        View view = this.getContext().getView();
        if (this.isSVNPropertiesWindowView(view)) {
            Context context = ((SVNPropertiesWindow)view).getViewContext();
            Collection c = this.getActionInfo().getFilteredSelection(context);
            return c.toArray(new Locatable[c.size()]);
        }
        return super.getOperands(profile);
    }

    protected PropertyEditorPanel createPanel() {
        PropertyEditorPanel panel = new PropertyEditorPanel(this.isFolderSelected());
        panel.setResourceField(this._resourceFile);
        return panel;
    }

    protected JEWTDialog createDialog() {
        String title = this._res.getString("ACTION_ADDPROPERTY_DIALOG_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)this.getPanel());
        dialog.setResizable(true);
        dialog.setOKButtonEnabled(false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getPanel(), "f1_svnaddproperty_html");
        return dialog;
    }

    protected void initListeners() {
        this._dialog.addVetoableChangeListener((VetoableChangeListener)new 1());
        this._panel.addListener(new 2());
    }

    protected NiceTable getTable() {
        View view;
        if (this._table == null && this.isSVNPropertiesWindowView(view = this.getContext().getView())) {
            this._table = ((SVNPropertiesWindow)view).getTable();
        }
        return this._table;
    }

    private void setOKButton(boolean containsValidContent) {
        EventQueue.invokeLater(new 3(this, containsValidContent));
    }

    protected PropertyEditorPanel getPanel() {
        return this._panel;
    }

    protected JEWTDialog getDialog() {
        return this._dialog;
    }

    protected URL[] getSelectedUrls() {
        return this._selectedUrls;
    }

    protected File getResourceFile() {
        return this._resourceFile;
    }

    private File getResourceFile(VCSProfile profile) throws Exception {
        View view = this.getContext().getView();
        if (this.isProjectNavigatorView(view)) {
            Locatable[] locatables = this.getOperands(profile);
            URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
            return this.getResourceFile(urls);
        }
        if (this.isSVNPropertiesWindowView(view)) {
            return ((SVNPropertiesWindow)view).getResource();
        }
        return null;
    }

    private File getResourceFile(URL[] urls) {
        if (urls == null || urls.length == 0) {
            return null;
        }
        return new File(urls[0].getFile());
    }

    private boolean isStringValue() {
        return this._panel.getStringRadioStatus();
    }

    private boolean isProjectNavigatorView(View view) {
        return view.getId().equals("_SUB_ApplicationNavigatorWindow._SUB_ApplicationNavigatorName");
    }

    protected boolean isSVNPropertiesWindowView(View view) {
        return view.getId().equals(SVNPropertiesWindow.VIEW_ID.getId());
    }

    private boolean isFolderSelected() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        Element[] selectedElements = context.getSelection();
        if (selectedElements == null || selectedElements.length == 0) {
            return false;
        }
        return selectedElements[0] instanceof RelativeDirectoryContextFolder;
    }

    private void refreshSVNPropertiesWindowView() {
        SVNPropertiesWindow view = this.tryGetPropertyWindow();
        if (view != null) {
            view.refresh();
        }
    }

    private SVNPropertiesWindow tryGetPropertyWindow() {
        if (this._propertiesWindow != null) {
            return this._propertiesWindow;
        }
        List viewList = Ide.getMainWindow().getVisibleViews();
        for (View view : viewList) {
            if (!this.isSVNPropertiesWindowView(view)) continue;
            return (SVNPropertiesWindow)view;
        }
        return null;
    }

    private void executePropertySetting() {
        block8: {
            File resourceFile = new File(this._panel.getResourceField());
            if (resourceFile == null) {
                return;
            }
            String propertyName = this._panel.getPropertyName();
            boolean isRecursive = this._panel.getRecursive();
            try {
                try {
                    ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                    SVNOperationLogger.getInstance().beginOperation(svnClient, null);
                    if (this.isStringValue()) {
                        String propertyValueString = this._panel.getStringPropertyValue();
                        svnClient.propertySet(resourceFile, propertyName, propertyValueString, isRecursive);
                        break block8;
                    }
                    File propertyValueFile = new File(this._panel.getFilePropertyValue());
                    svnClient.propertySet(resourceFile, propertyName, propertyValueFile, isRecursive);
                }
                catch (SVNClientException e) {
                    this.getExceptionHandler().handleException((Exception)((Object)e));
                }
                catch (IOException ioe) {
                    this.getExceptionHandler().handleException((Exception)ioe);
                }
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
    }

    static JEWTDialog ra$_dialog(SVNOperationAddProperty sVNOperationAddProperty) {
        return sVNOperationAddProperty._dialog;
    }

    static void mav$executePropertySetting(SVNOperationAddProperty sVNOperationAddProperty) {
        sVNOperationAddProperty.executePropertySetting();
    }

    static void mav$setOKButton(SVNOperationAddProperty sVNOperationAddProperty, boolean bl) {
        sVNOperationAddProperty.setOKButton(bl);
    }

    final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            SVNOperationAddProperty.mav$executePropertySetting(SVNOperationAddProperty.this);
        }
    }

    final class 2
    implements MonitoredPanel.PanelListener {
        public void setContainsURL(boolean containsValidContent) {
            SVNOperationAddProperty.mav$setOKButton(SVNOperationAddProperty.this, containsValidContent);
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ boolean v$containsValidContent;
        final /* synthetic */ SVNOperationAddProperty this$0;

        public void run() {
            SVNOperationAddProperty.ra$_dialog(this.this$0).setOKButtonEnabled(this.v$containsValidContent);
        }

        public 3(SVNOperationAddProperty sVNOperationAddProperty, boolean bl) {
            this.v$containsValidContent = bl;
            this.this$0 = sVNOperationAddProperty;
        }
    }
}

