/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.SVNOperationSwitch;
import oracle.jdevimpl.vcs.svn.op.ui.BranchPanel;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationBranch
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.branch";
    private BranchPanel _branchPanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;
    private boolean _fromNav;

    public SVNOperationBranch() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        if (this.isFromNav()) {
            this._fromNav = true;
            return true;
        }
        this._fromNav = false;
        return super.isAvailableImpl(profile);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        if (this.isFromNav()) {
            this._fromNav = true;
        }
        this.createPanel();
        this.createDialog();
        this.initListeners();
        if (this._dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    private boolean isFromNav() {
        SVNRemoteNode remoteNode;
        return SVNUtil.isRepositoryNavigatorView(this.getContext()) && (remoteNode = SVNUtil.getSVNRemoteNode(this.getContext())) != null;
    }

    private void setOKButton(boolean containsValidContent) {
        EventQueue.invokeLater(new 1(this, containsValidContent));
    }

    private void createPanel() {
        this._branchPanel = new BranchPanel(this._fromNav);
        this._branchPanel.setFromField(this.getFromURLString());
        this._branchPanel.setToField(this.getFromURLString());
        this._branchPanel.setContext(this.getContext());
    }

    private ISVNInfo getWCInfo() {
        Node node = this.getContext().getNode();
        URL url = null;
        File file = null;
        if (node != null) {
            url = node.getURL();
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jws") || suffix.equals(".jpr")) {
                url = URLFileSystem.getParent((URL)url);
            }
        } else {
            Element elem = this.getContext().getElement();
            if (elem instanceof RelativeDirectoryContextFolder) {
                url = ((RelativeDirectoryContextFolder)elem).getRootDirectories().getFirstEntry();
            }
        }
        file = SVNUtil.toFile(url);
        ISVNClientAdapter client = null;
        try {
            ISVNInfo info;
            client = SVNUtil.getIDEClientAdapter();
            ISVNInfo iSVNInfo = info = client.getInfoFromWorkingCopy(file);
            return iSVNInfo;
        }
        catch (SVNClientException e) {
            ISVNInfo iSVNInfo = null;
            return iSVNInfo;
        }
    }

    private File getWCFile() {
        return this._wcInfo.getFile();
    }

    private String getFromURLString() {
        if (this._fromNav) {
            SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
            return remoteNode.getSVNUrl().toString();
        }
        this._wcInfo = this.getWCInfo();
        if (this._wcInfo == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_BRANCH_ERROR_MESSAGE_NO_INFO"), (String)this._res.getString("ACTION_BRANCH_ERROR_TITLE_NO_INFO"), null);
        }
        return this._wcInfo.getUrlString();
    }

    private void createDialog() {
        String title = this._res.getString("ACTION_BRANCH_DIALOG_TITLE");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this._branchPanel, (Component)this._branchPanel.getInitialFocus(), (String)title, (int)7);
        this._dialog.setDefaultButton(1);
        this._dialog.setContent((Component)this._branchPanel);
        this._dialog.setResizable(true);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_BRANCH_DIALOG_HEADER_DESC"));
        this._dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._branchPanel, "f1_svnbranchtag_html");
    }

    private void initListeners() {
        this._dialog.addVetoableChangeListener((VetoableChangeListener)new 2());
        this._branchPanel.addListener(new 3());
    }

    static File mav$getWCFile(SVNOperationBranch sVNOperationBranch) {
        return sVNOperationBranch.getWCFile();
    }

    static BranchPanel ra$_branchPanel(SVNOperationBranch sVNOperationBranch) {
        return sVNOperationBranch._branchPanel;
    }

    static JEWTDialog ra$_dialog(SVNOperationBranch sVNOperationBranch) {
        return sVNOperationBranch._dialog;
    }

    static void mav$setOKButton(SVNOperationBranch sVNOperationBranch, boolean bl) {
        sVNOperationBranch.setOKButton(bl);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$containsValidContent;
        final /* synthetic */ SVNOperationBranch this$0;

        public void run() {
            SVNOperationBranch.ra$_dialog(this.this$0).setOKButtonEnabled(this.v$containsValidContent);
        }

        public 1(SVNOperationBranch sVNOperationBranch, boolean bl) {
            this.v$containsValidContent = bl;
            this.this$0 = sVNOperationBranch;
        }
    }

    final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            BranchThread branchThread = new BranchThread(null);
            branchThread.start();
        }
    }

    final class 3
    implements MonitoredPanel.PanelListener {
        public void setContainsURL(boolean containsValidContent) {
            SVNOperationBranch.mav$setOKButton(SVNOperationBranch.this, containsValidContent);
        }
    }

    private final class BranchThread
    extends Thread {
        IndeterminateProgressMonitor progressMon;
        SVNUrl trueToURL;

        private BranchThread() {
            super("svn-branch-thread");
        }

        public void run() {
            WaitCursor wc = new WaitCursor(SVNOperationBranch.ra$_dialog(SVNOperationBranch.this).getContent());
            EventQueue.invokeLater(new 1(this, wc));
            this.executeBranchingWithProgress();
            SwingUtilities.invokeLater(new 2());
            if (SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getSwitchStatus()) {
                this.swithToWC();
            }
            EventQueue.invokeLater(new 3(this, wc));
        }

        private void executeBranchingWithProgress() {
            this.progressMon = new IndeterminateProgressMonitor((Component)SVNOperationBranch.ra$_dialog(SVNOperationBranch.this), SVNOperationBranch.this._res.getString("ACTION_BRANCH_PROGRESS_TITLE"), (Object)SVNOperationBranch.this._res.getString("ACTION_BRANCH_PROGRESS_MESSAGE"), null);
            this.progressMon.setMillisToPopup(500);
            this.progressMon.setCloseOnFinish(true);
            this.progressMon.setCancellable(false);
            this.progressMon.start();
            try {
                this.executeBranching();
            }
            finally {
                this.progressMon.finish();
            }
        }

        private void executeBranching() {
            block7: {
                SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getFromURL());
                try {
                    try {
                        ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                        SVNOperationLogger.getInstance().beginOperation(svnClient, repoInfo, this.progressMon);
                        if (SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getFromOption() == SVNOperationBranch.ra$_branchPanel((SVNOperationBranch)SVNOperationBranch.this).FROM_WC) {
                            File fromWC = SVNOperationBranch.mav$getWCFile(SVNOperationBranch.this);
                            this.trueToURL = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getToURL();
                            this.appendPathTailIfRemotelyExisting();
                            String comment = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getComment();
                            svnClient.copy(fromWC, this.trueToURL, comment);
                            break block7;
                        }
                        SVNUrl fromURL = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getFromURL();
                        this.trueToURL = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getToURL();
                        this.appendPathTailIfRemotelyExisting();
                        String comment = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getComment();
                        SVNRevision revision = SVNRevision.HEAD;
                        if (SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getFromOption() == SVNOperationBranch.ra$_branchPanel((SVNOperationBranch)SVNOperationBranch.this).FROM_REVISION) {
                            revision = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getRevision();
                        }
                        svnClient.copy(fromURL, this.trueToURL, comment, revision);
                    }
                    catch (SVNClientException e) {}
                }
                finally {
                    SVNOperationLogger.getInstance().endOperation();
                }
            }
        }

        private void appendPathTailIfRemotelyExisting() {
            SVNUrl fromUrl = SVNOperationBranch.ra$_branchPanel(SVNOperationBranch.this).getFromURL();
            if (SVNUtil.getSVNNodeKind(fromUrl) == SVNNodeKind.DIR && SVNUtil.isRemotelyExisiting(this.trueToURL)) {
                String lastSeg = fromUrl.getLastPathSegment();
                this.trueToURL = this.trueToURL.appendPath(lastSeg);
            }
        }

        private void swithToWC() {
            Context ctx = SVNOperationBranch.this.getContext();
            ctx.setProperty("destFile", (Object)SVNOperationBranch.mav$getWCFile(SVNOperationBranch.this));
            SVNUrl toUrl2 = this.trueToURL;
            if (SVNOperationBranch.mav$getWCFile(SVNOperationBranch.this).isFile()) {
                String fn = SVNOperationBranch.mav$getWCFile(SVNOperationBranch.this).getName();
                toUrl2 = toUrl2.appendPath(fn);
            }
            ctx.setProperty("toUrl", (Object)toUrl2);
            SVNOperationSwitch command = new SVNOperationSwitch();
            command.setContext(ctx);
            try {
                CommandProcessor.getInstance().invoke((Command)command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        BranchThread(oracle.jdevimpl.vcs.svn.op.SVNOperationBranch$2 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ BranchThread this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(BranchThread branchThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = branchThread;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                SVNOperationBranch.ra$_dialog(SVNOperationBranch.this).setVisible(false);
                SVNOperationBranch.ra$_dialog(SVNOperationBranch.this).dispose();
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ BranchThread this$0;

            public void run() {
                this.v$wc.hide();
            }

            public 3(BranchThread branchThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = branchThread;
            }
        }
    }
}

