/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.op.ui.BasicCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.op.ui.FullCheckoutPanel;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class SVNOperationCheckout
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.checkout";
    private static final String LAST_CO_ROOT_KEY = SVNOperationCheckout.class.getName() + ".lastCoRoot";
    private static final String TIMING_CTX_CO = "checkout";
    private static final String TIMING_CTX_SCAN = "dirScan";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public SVNOperationCheckout() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        if (!super.isAvailableImpl(profile)) {
            return false;
        }
        if (SVNUtil.isRepositoryNavigatorView(this.getContext())) {
            SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
            if (remoteNode != null) {
                return remoteNode.getNodeKind() == SVNNodeKind.DIR;
            }
            return false;
        }
        return true;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        URL checkOutRoot;
        JPanel panel = null;
        String checkOutPath = null;
        SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
        String checkOutRootStr = Ide.getDTCache().getString(LAST_CO_ROOT_KEY);
        URL uRL = checkOutRoot = checkOutRootStr != null ? URLFactory.newDirURL((String)checkOutRootStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
        if (remoteNode != null) {
            if (remoteNode instanceof SVNRepositoryNode && !this.warnReposRoot()) {
                return 1;
            }
            boolean isReposRoot = false;
            String reposAlias = null;
            if (remoteNode instanceof SVNRepositoryNode) {
                isReposRoot = true;
                SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)((SVNRepositoryNode)remoteNode).getData();
                reposAlias = reposInfo.getAlias();
            }
            URL suggestedDestination = SVNUtil.suggestCheckoutDestination(checkOutRoot, remoteNode.getSVNUrl(), isReposRoot, reposAlias);
            panel = new BasicCheckoutPanel((SVNRepositoryInfo)remoteNode.getParentRepository().getData(), remoteNode.getSVNUrl(), suggestedDestination);
            checkOutPath = SVNUrlUtils.getRelativePath((SVNUrl)remoteNode.getParentRepository().getSVNUrl(), (SVNUrl)remoteNode.getSVNUrl());
        } else {
            if (!SVNUtil.ensureRepositoryConnection(this.getContext())) {
                return 1;
            }
            panel = new FullCheckoutPanel(SVNRepositoryManager.getInstance().list(), checkOutRoot, SVNUtil.getIDEClientAdapter());
        }
        JEWTDialog dialog = this.createDialog(panel, checkOutPath);
        CheckoutInfo coInfo = panel;
        dialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, coInfo, dialog, profile));
        if (dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    private boolean warnNonEmptyDestination(Component parent, URL dest) {
        return MessageDialog.optionalConfirm((String)(SVNOperationCheckout.class.getName() + ".warnNonEmptyDestination"), (Component)parent, (String)this._res.getString("ACTION_CHECKOUT_NONEMPTY_DEST_WARNING_MESSAGE", (Object)URLFileSystem.getPlatformPathName((URL)dest)), (String)this._res.getString("ACTION_CHECKOUT_WARNING_TITLE"), (String)"f1_svnconfirmcheckoutintodir_html");
    }

    private boolean warnReposRoot() {
        return MessageDialog.optionalConfirm((String)(SVNOperationCheckout.class.getName() + ".warnRootCheckout"), (Component)Ide.getMainWindow(), (String)this._res.getString("ACTION_CHECKOUT_ROOT_WARNING_MESSAGE"), (String)this._res.getString("ACTION_CHECKOUT_WARNING_TITLE"), (String)"f1_svnconfirmcheckoutfromroot_html");
    }

    private JEWTDialog createDialog(JComponent content, String relativePath) {
        String title = relativePath != null ? this._res.getString("ACTION_CHECKOUT_DIALOG_TITLE_URL", new Object[]{relativePath}) : this._res.getString("ACTION_CHECKOUT_DIALOG_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)content);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic(content, "f1_svncheckoutfromsubversion_html");
        return dialog;
    }

    static ResourcePicker ra$_res(SVNOperationCheckout sVNOperationCheckout) {
        return sVNOperationCheckout._res;
    }

    static String ra$LAST_CO_ROOT_KEY() {
        return LAST_CO_ROOT_KEY;
    }

    static boolean mav$warnNonEmptyDestination(SVNOperationCheckout sVNOperationCheckout, Component component, URL uRL) {
        return sVNOperationCheckout.warnNonEmptyDestination(component, uRL);
    }

    static VCSExceptionHandler mav$getExceptionHandler(SVNOperationCheckout sVNOperationCheckout) {
        return sVNOperationCheckout.getExceptionHandler();
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ CheckoutInfo v$coInfo;
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ VCSProfile v$profile;
        final /* synthetic */ SVNOperationCheckout this$0;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            URL[] contents;
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            if (this.v$coInfo.getRevision() == SVNRevision.INVALID_REVISION) {
                MessageDialog.error((Component)this.v$dialog, (Object)SVNOperationCheckout.ra$_res(this.this$0).getString("INVALID_REVISION_ERROR_MESSAGE"), (String)SVNOperationCheckout.ra$_res(this.this$0).getString("INVALID_REVISION_ERROR_TITLE"), null);
                throw new PropertyVetoException(null, pce);
            }
            URL dest = this.v$coInfo.getDestinationURL();
            URL root = URLFileSystem.getParent((URL)dest);
            if (root == null) {
                root = URLFactory.newDirURL((String)Ide.getWorkDirectory());
            }
            Ide.getDTCache().putString(SVNOperationCheckout.ra$LAST_CO_ROOT_KEY(), URLFileSystem.getPlatformPathName((URL)root));
            if (URLFileSystem.exists((URL)dest) && (contents = URLFileSystem.list((URL)dest)).length > 0 && !SVNOperationCheckout.mav$warnNonEmptyDestination(this.this$0, (Component)this.v$dialog, dest)) {
                throw new PropertyVetoException(null, pce);
            }
            this.v$dialog.setOKButtonEnabled(false);
            CheckoutThread coThread = this.this$0.new CheckoutThread(this.v$profile, this.v$dialog, this.v$dialog.getContent(), this.v$coInfo, null);
            coThread.start();
            throw new PropertyVetoException(null, pce);
        }

        public 1(SVNOperationCheckout sVNOperationCheckout, CheckoutInfo checkoutInfo, JEWTDialog jEWTDialog, VCSProfile vCSProfile) {
            this.v$profile = vCSProfile;
            this.v$dialog = jEWTDialog;
            this.v$coInfo = checkoutInfo;
            this.this$0 = sVNOperationCheckout;
        }
    }

    private final class CheckoutThread
    extends Thread {
        private final JEWTDialog _parentDialog;
        private final Component _parentPanel;
        private final CheckoutInfo _coInfo;
        private final VCSProfile _profile;

        private CheckoutThread(VCSProfile profile, JEWTDialog parentDialog, Component parentPanel, CheckoutInfo coInfo) {
            super("svn-checkout-thread");
            this._profile = profile;
            this._parentDialog = parentDialog;
            this._parentPanel = parentPanel;
            this._coInfo = coInfo;
        }

        public void run() {
            WaitCursor wc = new WaitCursor(this._parentPanel);
            EventQueue.invokeLater(new 1(this, wc));
            try {
                try {
                    VCSDirectoryWatcher watcher = new VCSDirectoryWatcher(this._coInfo.getDestinationURL());
                    this.executeCheckoutWithProgress(this._parentDialog, this._coInfo, watcher);
                    SwingUtilities.invokeLater(new 2());
                    URLFilter workingCopyFilter = this._profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
                    NewFilesHandler nfh = new NewFilesHandler(watcher, workingCopyFilter);
                    SwingUtilities.invokeLater(new 3(this, nfh));
                }
                catch (IOException ioe) {
                    MessageDialog.error((Component)this._parentDialog, (Object)SVNOperationCheckout.ra$_res(SVNOperationCheckout.this).getString("ACTION_CHECKOUT_ERROR_MESSAGE_DEST", new Object[]{ioe.getMessage()}), (String)SVNOperationCheckout.ra$_res(SVNOperationCheckout.this).getString("ACTION_CHECKOUT_ERROR_TITLE"), null);
                    SwingUtilities.invokeLater(new 4());
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog((Component)this._parentDialog, (Throwable)e, (String)SVNOperationCheckout.ra$_res(SVNOperationCheckout.this).getString("ACTION_CHECKOUT_ERROR_TITLE"), (String)SVNOperationCheckout.ra$_res(SVNOperationCheckout.this).getString("ACTION_CHECKOUT_ERROR_MESSAGE_URL", new Object[]{this._coInfo.getSourceURL().toString()}), null);
                    SwingUtilities.invokeLater(new 5());
                }
            }
            finally {
                EventQueue.invokeLater(new 6(this, wc));
            }
        }

        private String getName(Context context) {
            Element elm = context.getElement();
            String name = "";
            if (elm instanceof Locatable) {
                URL url = ((Locatable)elm).getURL();
                if (elm instanceof SVNRemoteFolder) {
                    String[] svnLPath = ((SVNRemoteFolder)elm).getSVNUrl().getPathSegments();
                    String path = url.getPath();
                    if (svnLPath.length > 0 && path.length() > svnLPath[0].length() + 2) {
                        name = path.substring(svnLPath[0].length() + 2);
                    }
                }
                if (name == null) {
                    name = URLFileSystem.getName((URL)url);
                }
            }
            return name;
        }

        private void executeCheckoutWithProgress(JEWTDialog dialog, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            IndeterminateProgressMonitor progressMon = new IndeterminateProgressMonitor((Component)dialog, SVNOperationCheckout.ra$_res(SVNOperationCheckout.this).getString("ACTION_CHECKOUT_PROGRESS_TITLE"), (Object)SVNOperationCheckout.ra$_res(SVNOperationCheckout.this).getString("ACTION_CHECKOUT_PROGRESS_MESSAGE"), null);
            progressMon.setMillisToPopup(500);
            progressMon.setCloseOnFinish(true);
            progressMon.setCancellable(false);
            progressMon.start();
            try {
                this.executeCheckout(progressMon, coInfo, watcher);
            }
            finally {
                progressMon.finish();
            }
        }

        private void executeCheckout(IndeterminateProgressMonitor progress, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            SVNUrl sourceUrl = coInfo.getSourceURL();
            URL destUrl = coInfo.getDestinationURL();
            String coContext = "checkout.{" + sourceUrl.toString() + "}";
            String scanContext = "dirScan.{" + URLFileSystem.getPlatformPathName((URL)destUrl) + "}";
            TimingUtil.beginTiming(this.getClass(), coContext);
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            URL destination = coInfo.getDestinationURL();
            if (!URLFileSystem.mkdirs((URL)destination)) {
                throw new IOException(URLFileSystem.getPlatformPathName((URL)destination));
            }
            TimingUtil.beginTiming(this.getClass(), scanContext);
            watcher.beginWatch();
            TimingUtil.endTiming(this.getClass(), scanContext);
            try {
                SVNOperationLogger.getInstance().beginOperation(svnClient, coInfo.getRepositoryInfo(), progress);
                svnClient.checkout(sourceUrl, SVNUtil.toFile(coInfo.getDestinationURL()), coInfo.getRevision(), coInfo.getRecursive());
                TimingUtil.beginTiming(this.getClass(), scanContext);
                watcher.endWatch();
                TimingUtil.endTiming(this.getClass(), scanContext);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                TimingUtil.endTiming(this.getClass(), coContext);
            }
        }

        CheckoutThread(VCSProfile vCSProfile, JEWTDialog jEWTDialog, Component component, CheckoutInfo checkoutInfo, oracle.jdevimpl.vcs.svn.op.SVNOperationCheckout$1 var6_6) {
            this(vCSProfile, jEWTDialog, component, checkoutInfo);
        }

        static JEWTDialog ra$_parentDialog(CheckoutThread checkoutThread) {
            return checkoutThread._parentDialog;
        }

        static String mav$getName(CheckoutThread checkoutThread, Context context) {
            return checkoutThread.getName(context);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ CheckoutThread this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(CheckoutThread checkoutThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = checkoutThread;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                CheckoutThread.ra$_parentDialog(CheckoutThread.this).setVisible(false);
                CheckoutThread.ra$_parentDialog(CheckoutThread.this).dispose();
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ NewFilesHandler v$nfh;
            final /* synthetic */ CheckoutThread this$0;

            public void run() {
                try {
                    Context context = this.this$0.SVNOperationCheckout.this.getContext();
                    String name = CheckoutThread.mav$getName(this.this$0, context);
                    this.v$nfh.setDialogHintText(SVNOperationCheckout.ra$_res(this.this$0.SVNOperationCheckout.this).getString("PROJECT_TITLE_DIALOG"));
                    if (!Product.isRaptor()) {
                        this.v$nfh.handleNewFiles(context, name);
                    }
                }
                catch (Exception e) {
                    SVNOperationCheckout.mav$getExceptionHandler(this.this$0.SVNOperationCheckout.this).handleException(e);
                }
            }

            public 3(CheckoutThread checkoutThread, NewFilesHandler newFilesHandler) {
                this.v$nfh = newFilesHandler;
                this.this$0 = checkoutThread;
            }
        }

        final class 4
        implements Runnable {
            public void run() {
                CheckoutThread.ra$_parentDialog(CheckoutThread.this).setOKButtonEnabled(true);
            }
        }

        final class 5
        implements Runnable {
            public void run() {
                CheckoutThread.ra$_parentDialog(CheckoutThread.this).setOKButtonEnabled(true);
            }
        }

        final class 6
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ CheckoutThread this$0;

            public void run() {
                this.v$wc.hide();
            }

            public 6(CheckoutThread checkoutThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = checkoutThread;
            }
        }
    }
}

