/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.CommitOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNOperationCommit
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.commit";
    IndeterminateProgressMonitor progress;

    public SVNOperationCommit() {
        super(COMMAND_ID);
    }

    SVNOperationCommit(String commandId) {
        super(commandId);
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState state, Component parentUi, Map options) throws Exception {
        this.progress = new IndeterminateProgressMonitor(parentUi, this._res.getString("ACTION_COMMIT_PROGRESS_TITLE"));
        this.progress.setMillisToPopup(0);
        this.progress.setCloseOnFinish(true);
        this.progress.setCancellable(false);
        this.progress.start();
        try {
            this.invokeCommit(profile, state, options, this.progress);
        }
        finally {
            if (!this.progress.isCancelled()) {
                this.progress.finish();
            }
        }
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        this.invokeCommit(profile, commandState, options, null);
        return true;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer((VCSOptionsCustomizer)new CommitOptionsCustomizer());
        customizer.setShowReuseCommentsOption(false);
        return customizer;
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] loc = super.getOperands(profile);
        return this.createChangeListItems(this.getUrlArray(loc));
    }

    private URL[] getUrlArray(Locatable[] loc) {
        URL[] urls = new URL[loc.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = loc[i].getURL();
            ++i;
        }
        return urls;
    }

    private ChangeListItem[] createChangeListItems(URL[] urls) {
        ChangeListItem[] items = new ChangeListItem[urls.length];
        VCSOverlayItemProducer overlayItemProducer = new VCSOverlayItemProducer(this.getStatusCache());
        int i = 0;
        while (i < urls.length) {
            items[i] = this.createChangeListItem(urls[i], overlayItemProducer);
            ++i;
        }
        return items;
    }

    private ChangeListItem createChangeListItem(URL url, VCSOverlayItemProducer overlayItemProducer) {
        VCSOverlayItem overlayItem = null;
        try {
            overlayItem = overlayItemProducer != null ? overlayItemProducer.getOverlayItems(new URL[]{url})[0] : null;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return new ChangeListItem(url, overlayItem != null ? overlayItem.getOverlay() : null);
    }

    private void invokeCommit(VCSProfile profile, CommandState state, Map options, IndeterminateProgressMonitor progress) throws Exception {
        String comment = this.getComments(options);
        boolean keepLocks = this.getKeepLocks(options);
        URL[] operands = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])state.getLocatables()));
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            if (progress != null) {
                SVNOperationLogger.getInstance().beginOperation(client, repos, progress);
            } else {
                SVNOperationLogger.getInstance().beginOperation(client, repos);
            }
            this.commitParents(profile, client, operands, comment, keepLocks);
            client.commit(SVNUtil.toFiles(operands), comment, true, keepLocks);
            Collection processed = this.getProcessedUrlsNotifier(state);
            processed.addAll(Arrays.asList(operands));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            state.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)Boolean.TRUE);
        }
    }

    private boolean getKeepLocks(Map options) {
        Boolean keepLocks = (Boolean)options.get("oracle.jdeveloper.subversion.KEEP_LOCKS");
        if (keepLocks != null) {
            return keepLocks;
        }
        return false;
    }

    private String getComments(Map options) {
        String commentOption = (String)options.get("setting_comments");
        return commentOption != null ? commentOption : "";
    }

    private void commitParents(VCSProfile profile, ISVNClientAdapter client, URL[] operands, String comment, boolean keepLocks) throws Exception {
        int u = 0;
        while (u < operands.length) {
            URL parent = URLFileSystem.getParent((URL)operands[u]);
            if (parent != null) {
                this.commitParent(profile, client, parent, comment, keepLocks);
            }
            ++u;
        }
    }

    private void commitParent(VCSProfile profile, ISVNClientAdapter client, URL child, String comment, boolean keepLocks) throws Exception {
        VCSStatus status;
        VCSStatusFilter filter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.ADDED");
        if (filter.accept(status = profile.getStatusCache().get(child))) {
            URL parent = URLFileSystem.getParent((URL)child);
            if (parent != null) {
                this.commitParent(profile, client, parent, comment, keepLocks);
            }
            client.commit(new File[]{SVNUtil.toFile(child)}, comment, false, keepLocks);
            profile.getStatusCache().clear(child);
        }
    }
}

