/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNCompareOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNOperationComparePrevious
extends AbstractSVNCompareOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.compare-previous";

    public SVNOperationComparePrevious() {
        super(COMMAND_ID);
    }

    public SVNOperationComparePrevious(String commandId) {
        super(commandId);
    }

    protected Object getContextRevision(VCSProfile profile, Locatable locatable) throws Exception {
        long previousRevision = -1;
        previousRevision = URLFileSystem.isDirectoryPath((URL)locatable.getURL()) || this.isDirty(locatable) || this.isLocallyModified(locatable, profile) ? SVNURLInfoCache.getInstance().getRevision(locatable.getURL()) : SVNURLInfoCache.getInstance().getLastChangedRevision(locatable.getURL());
        if (previousRevision > (long)-1) {
            return new SVNRevision.Number(previousRevision);
        }
        throw new IllegalStateException("Unexpected revision: " + String.valueOf(previousRevision));
    }

    protected HistoryEntrySelector getHistoryEntrySelector(VCSProfile profile, Locatable source, Object revision) throws Exception {
        return new HistoryEntrySelector(((SVNRevision.Number)revision).toString());
    }

    private boolean isDirty(Locatable resource) {
        return resource instanceof Dirtyable && ((Dirtyable)resource).isDirty();
    }

    private boolean isLocallyModified(Locatable resource, VCSProfile profile) throws Exception {
        return profile.getStatusInstance("MODIFIED") == profile.getStatusCache().get(resource.getURL());
    }
}

