/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.CreateReposPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNOperationCreateRepos
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.create-repos";
    private static final String LAST_REPOS_ROOT_KEY = SVNOperationCreateRepos.class.getName() + "." + "lastReposRoot";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public SVNOperationCreateRepos() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        CreateReposPanel panel = new CreateReposPanel(this.suggestRepositoryLocation());
        JEWTDialog dialog = this.createDialog(panel, panel.getInitialFocus());
        dialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, panel, dialog));
        if (WizardLauncher.runDialog((JDialog)dialog)) {
            return 0;
        }
        return 1;
    }

    private void createConnection(URL reposPath, String connectionName) throws MalformedURLException, AlreadyExistsException {
        SVNAuthInfo authInfo = new SVNAuthInfo("", "");
        SVNRepositoryInfo repos = new SVNRepositoryInfo(SVNUtil.toSVNUrl(reposPath), connectionName, authInfo);
        SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(repos);
    }

    private void createRepository(URL reposPath, String fsType) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(AbstractSVNOperation.CLIENT_CONTEXT);
        try {
            SVNOperationLogger.getInstance().beginOperation(client, null);
            client.createRepository(SVNUtil.toFile(reposPath), fsType);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private JEWTDialog createDialog(JComponent content, Component initialFocus) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)content, (Component)initialFocus, (String)this._res.getString("ACTION_CREATE_REPOS_DIALOG_TITLE"), (int)7);
        dialog.setResizable(false);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_CREATE_REPOS_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic(content, "f1_svncreatesubversionrepository_html");
        return dialog;
    }

    private URL suggestRepositoryLocation() {
        String rootLocation = Ide.getDTCache().getString(LAST_REPOS_ROOT_KEY);
        if (rootLocation == null || rootLocation.equals("")) {
            rootLocation = Ide.getTrueUserHomeDirectory();
        }
        URL base = URLFactory.newDirURL((String)rootLocation);
        String token = "repos";
        URL suggestion = URLFactory.newDirURL((URL)base, (String)token);
        int i = 0;
        while (URLFileSystem.exists((URL)suggestion)) {
            suggestion = URLFactory.newDirURL((URL)base, (String)(token + i++));
        }
        return suggestion;
    }

    static ResourcePicker ra$_res(SVNOperationCreateRepos sVNOperationCreateRepos) {
        return sVNOperationCreateRepos._res;
    }

    static String ra$LAST_REPOS_ROOT_KEY() {
        return LAST_REPOS_ROOT_KEY;
    }

    static void mav$createRepository(SVNOperationCreateRepos sVNOperationCreateRepos, URL uRL, String string) {
        sVNOperationCreateRepos.createRepository(uRL, string);
    }

    static void mav$createConnection(SVNOperationCreateRepos sVNOperationCreateRepos, URL uRL, String string) {
        sVNOperationCreateRepos.createConnection(uRL, string);
    }

    final class oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1
    implements VetoableChangeListener {
        private final /* synthetic */ CreateReposPanel v$panel;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationCreateRepos this$0;

        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)event)) {
                URL reposPath = this.v$panel.getRepositoryPath();
                if (reposPath == null) {
                    MessageDialog.error((Component)this.v$dialog, (Object)SVNOperationCreateRepos.ra$_res(this.this$0).getString("ACTION_CREATE_REPOS_ERROR_MESSAGE_DIR"), (String)SVNOperationCreateRepos.ra$_res(this.this$0).getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                    throw new PropertyVetoException(null, event);
                }
                if (URLFileSystem.exists((URL)reposPath)) {
                    if (URLFileSystem.list((URL)reposPath).length > 0) {
                        MessageDialog.error((Component)this.v$dialog, (Object)SVNOperationCreateRepos.ra$_res(this.this$0).getString("ACTION_CREATE_REPOS_ERROR_MESSAGE_EMPTY"), (String)SVNOperationCreateRepos.ra$_res(this.this$0).getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                        throw new PropertyVetoException(null, event);
                    }
                } else if (!URLFileSystem.mkdirs((URL)reposPath)) {
                    MessageDialog.error((Component)this.v$dialog, (Object)SVNOperationCreateRepos.ra$_res(this.this$0).getString("ACTION_CREATE_REPOS_ERROR_MESSAGE_CREATE"), (String)SVNOperationCreateRepos.ra$_res(this.this$0).getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                    throw new PropertyVetoException(null, event);
                }
                this.v$dialog.setOKButtonEnabled(false);
                Ide.getDTCache().putString(SVNOperationCreateRepos.ra$LAST_REPOS_ROOT_KEY(), URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)this.v$panel.getRepositoryPath())));
                new Thread((Runnable)new 1(this, reposPath), "svn-repos-create-thread").start();
                throw new PropertyVetoException(null, event);
            }
        }

        public oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1(SVNOperationCreateRepos sVNOperationCreateRepos, CreateReposPanel createReposPanel, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$panel = createReposPanel;
            this.this$0 = sVNOperationCreateRepos;
        }

        static CreateReposPanel ra$v$panel(oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1 var0) {
            return var0.v$panel;
        }

        static JEWTDialog ra$v$dialog(oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1 var0) {
            return var0.v$dialog;
        }

        final class oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1$1
        implements Runnable {
            private final /* synthetic */ URL v$reposPath;
            final /* synthetic */ oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1 this$0;

            public void run() {
                WaitCursor wc = new WaitCursor((Component)oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$panel(this.this$0));
                EventQueue.invokeLater(new 1(this, wc));
                try {
                    try {
                        SVNOperationCreateRepos.mav$createRepository(this.this$0.this$0, this.v$reposPath, oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$panel(this.this$0).getFileSystemType());
                        SVNOperationCreateRepos.mav$createConnection(this.this$0.this$0, this.v$reposPath, oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$panel(this.this$0).getConnectionName());
                        SwingUtilities.invokeLater(new 2());
                        SVNRepositoryNavigatorAPI.getInstance().showRepositoryNavigator();
                    }
                    catch (Exception e) {
                        MessageDialog.error((Component)oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$dialog(this.this$0), (Object)e.getMessage(), (String)SVNOperationCreateRepos.ra$_res(this.this$0.this$0).getString("ACTION_CREATE_REPOS_ERROR_TITLE"), null);
                        e.printStackTrace();
                        SwingUtilities.invokeLater(new 3());
                    }
                }
                finally {
                    EventQueue.invokeLater(new 4(this, wc));
                }
            }

            public oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1$1(oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1 var1_1, URL uRL) {
                this.v$reposPath = uRL;
                this.this$0 = var1_1;
            }

            final class 1
            implements Runnable {
                private final /* synthetic */ WaitCursor v$wc;
                final /* synthetic */ oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1$1 this$0;

                public void run() {
                    this.v$wc.show();
                }

                public 1(oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1$1 var1_1, WaitCursor waitCursor) {
                    this.v$wc = waitCursor;
                    this.this$0 = var1_1;
                }
            }

            final class 2
            implements Runnable {
                public void run() {
                    oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$dialog(1.this.this$0).setVisible(false);
                    oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$dialog(1.this.this$0).dispose();
                }
            }

            final class 3
            implements Runnable {
                public void run() {
                    oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1.ra$v$dialog(1.this.this$0).setOKButtonEnabled(true);
                }
            }

            final class 4
            implements Runnable {
                private final /* synthetic */ WaitCursor v$wc;
                final /* synthetic */ oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1$1 this$0;

                public void run() {
                    this.v$wc.hide();
                }

                public 4(oracle.jdevimpl.vcs.svn.op.SVNOperationCreateRepos$1$1 var1_1, WaitCursor waitCursor) {
                    this.v$wc = waitCursor;
                    this.this$0 = var1_1;
                }
            }
        }
    }
}

