/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.ExportFromReposPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ExportFromWCPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNOperationExport
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.export";
    private final ResourcePicker _res;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    public SVNOperationExport() {
        super(COMMAND_ID);
        this.$init$();
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        Locatable[] node = VCSContextUtils.getContextLocatables((Context)this.getContext());
        if (node != null && node.length > 0 && profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.SVN_NAV").accept(node[0].getURL())) {
            return true;
        }
        return super.isAvailableImpl(profile);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Element selected = this.getContext().getElement();
        if (selected instanceof SVNRemoteNode) {
            SVNRemoteNode remoteNode = (SVNRemoteNode)selected;
            this.exportFromRepository((SVNRepositoryInfo)remoteNode.getParentRepository().getData(), remoteNode.getSVNUrl());
            return 1;
        }
        Locatable[] node = VCSContextUtils.getContextLocatables((Context)this.getContext());
        if (node != null && node.length > 0) {
            URL url = node[0].getURL();
            if (!URLFileSystem.isDirectory((URL)url)) {
                url = URLFileSystem.getParent((URL)url);
            }
            this.exportFromWorkingCopy(url);
            return 1;
        }
        return 1;
    }

    private void exportFromRepository(SVNRepositoryInfo repos, SVNUrl url) {
        ExportFromReposPanel panel = new ExportFromReposPanel(url);
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), this._res.getString("ACTION_EXPORT_DIALOG_TITLE"), 7);
        dialog.setDefaultButton(1);
        dialog.setOKButtonEnabled(false);
        dialog.setContent((Component)panel);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_EXPORT_DIALOG_HEADER_DESC_SVNURL"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svnexportfilessvnurl_html");
        panel.addExportPathListener(new 1(this, dialog));
        dialog.addVetoableChangeListener((VetoableChangeListener)new 2(this, panel, dialog));
        dialog.addVetoableChangeListener((VetoableChangeListener)new 3(this, this, panel, dialog));
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            SVNExecutorService.getInstance().submit(new 4(this, this, repos, panel, url));
        }
    }

    private void exportFromWorkingCopy(URL dirUrl) {
        ExportFromWCPanel panel = new ExportFromWCPanel(dirUrl);
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), this._res.getString("ACTION_EXPORT_DIALOG_TITLE"), 7);
        dialog.setDefaultButton(1);
        dialog.setOKButtonEnabled(false);
        dialog.setContent((Component)panel);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_EXPORT_DIALOG_HEADER_DESC_URL"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svnexportfilesurl_html");
        panel.addExportPathListener(new 5(this, dialog));
        dialog.addVetoableChangeListener((VetoableChangeListener)new 6(this, this, panel, dialog));
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            SVNExecutorService.getInstance().submit(new 7(this, this, panel, dirUrl));
        }
    }

    static ResourcePicker ra$_res(SVNOperationExport sVNOperationExport) {
        return sVNOperationExport._res;
    }

    final class 1
    implements ExportPathListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationExport this$0;

        public void exportPathSelected(String newPath) {
            this.v$dialog.setOKButtonEnabled(newPath != null && newPath.length() > 0);
        }

        public 1(SVNOperationExport sVNOperationExport, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.this$0 = sVNOperationExport;
        }
    }

    final class 2
    implements VetoableChangeListener {
        private final /* synthetic */ ExportFromReposPanel v$panel;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationExport this$0;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            if (this.v$panel.getRevision() == SVNRevision.INVALID_REVISION) {
                MessageDialog.error((Component)this.v$dialog, (Object)SVNOperationExport.ra$_res(this.this$0).getString("INVALID_REVISION_ERROR_MESSAGE"), (String)SVNOperationExport.ra$_res(this.this$0).getString("INVALID_REVISION_ERROR_TITLE"), null);
                throw new PropertyVetoException(null, pce);
            }
        }

        public 2(SVNOperationExport sVNOperationExport, ExportFromReposPanel exportFromReposPanel, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$panel = exportFromReposPanel;
            this.this$0 = sVNOperationExport;
        }
    }

    final class 3
    extends ExportPathValidator {
        private final /* synthetic */ ExportFromReposPanel v$panel;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationExport this$0;

        protected URL getExportPath() {
            return this.v$panel.getExportPath();
        }

        protected JEWTDialog getParentDialog() {
            return this.v$dialog;
        }

        public 3(SVNOperationExport sVNOperationExport, SVNOperationExport sVNOperationExport2, ExportFromReposPanel exportFromReposPanel, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$panel = exportFromReposPanel;
            this.this$0 = sVNOperationExport;
            super((3)null);
        }
    }

    final class 4
    extends ExportTask {
        private final /* synthetic */ SVNRepositoryInfo v$repos;
        private final /* synthetic */ ExportFromReposPanel v$panel;
        private final /* synthetic */ SVNUrl v$url;
        final /* synthetic */ SVNOperationExport this$0;

        protected SVNRepositoryInfo getReposInfo() {
            return this.v$repos;
        }

        protected String getProgressMessage() {
            return SVNOperationExport.ra$_res(this.this$0).getString("UI_EXP_PROGRESS_MSG_SVNURL");
        }

        protected URL getExportPath() {
            return this.v$panel.getExportPath();
        }

        protected void executeExport(ISVNClientAdapter client, URL exportPath) throws SVNClientException {
            client.doExport(this.v$url, SVNUtil.toFile(exportPath), this.v$panel.getRevision(), true);
        }

        public 4(SVNOperationExport sVNOperationExport, SVNOperationExport sVNOperationExport2, SVNRepositoryInfo sVNRepositoryInfo, ExportFromReposPanel exportFromReposPanel, SVNUrl sVNUrl) {
            this.v$url = sVNUrl;
            this.v$panel = exportFromReposPanel;
            this.v$repos = sVNRepositoryInfo;
            this.this$0 = sVNOperationExport;
            super((4)null);
        }
    }

    final class 5
    implements ExportPathListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationExport this$0;

        public void exportPathSelected(String newPath) {
            this.v$dialog.setOKButtonEnabled(newPath != null && newPath.length() > 0);
        }

        public 5(SVNOperationExport sVNOperationExport, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.this$0 = sVNOperationExport;
        }
    }

    final class 6
    extends ExportPathValidator {
        private final /* synthetic */ ExportFromWCPanel v$panel;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationExport this$0;

        protected URL getExportPath() {
            return this.v$panel.getExportPath();
        }

        protected JEWTDialog getParentDialog() {
            return this.v$dialog;
        }

        public 6(SVNOperationExport sVNOperationExport, SVNOperationExport sVNOperationExport2, ExportFromWCPanel exportFromWCPanel, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$panel = exportFromWCPanel;
            this.this$0 = sVNOperationExport;
            super((6)null);
        }
    }

    final class 7
    extends ExportTask {
        private final /* synthetic */ ExportFromWCPanel v$panel;
        private final /* synthetic */ URL v$dirUrl;
        final /* synthetic */ SVNOperationExport this$0;

        protected String getProgressMessage() {
            return SVNOperationExport.ra$_res(this.this$0).getString("UI_EXP_PROGRESS_MSG_URL");
        }

        protected URL getExportPath() {
            return this.v$panel.getExportPath();
        }

        protected void executeExport(ISVNClientAdapter client, URL exportPath) throws SVNClientException {
            client.doExport(SVNUtil.toFile(this.v$dirUrl), SVNUtil.toFile(exportPath), true);
        }

        public 7(SVNOperationExport sVNOperationExport, SVNOperationExport sVNOperationExport2, ExportFromWCPanel exportFromWCPanel, URL uRL) {
            this.v$dirUrl = uRL;
            this.v$panel = exportFromWCPanel;
            this.this$0 = sVNOperationExport;
            super((7)null);
        }
    }

    private abstract class ExportPathValidator
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                return;
            }
            URL path = this.getExportPath();
            if (URLFileSystem.exists((URL)path) && URLFileSystem.list((URL)path).length > 0 && !this.confirmNonEmptyDir(path)) {
                throw new PropertyVetoException(null, e);
            }
            if (!URLFileSystem.mkdirs((URL)path)) {
                MessageDialog.error((Component)this.getParentDialog(), (Object)SVNOperationExport.ra$_res(SVNOperationExport.this).getString("ACTION_EXPORT_ERROR_MSG"), (String)SVNOperationExport.ra$_res(SVNOperationExport.this).getString("ACTION_EXPORT_ERROR_TITLE"), null);
                throw new PropertyVetoException(null, e);
            }
        }

        protected abstract URL getExportPath();

        protected abstract JEWTDialog getParentDialog();

        private boolean confirmNonEmptyDir(URL dir) {
            return MessageDialog.confirm((Component)this.getParentDialog(), (Object)SVNOperationExport.ra$_res(SVNOperationExport.this).getString("ACTION_EXPORT_CONFIRM_MSG", (Object)URLFileSystem.getPlatformPathName((URL)dir)), (String)SVNOperationExport.ra$_res(SVNOperationExport.this).getString("ACTION_EXPORT_CONFIRM_TITLE"), null);
        }

        private ExportPathValidator() {
        }

        ExportPathValidator(6 var2_2) {
            this();
        }

        ExportPathValidator(3 var2_2) {
            this();
        }
    }

    private abstract class ExportTask
    implements Runnable {
        public void run() {
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), SVNOperationExport.ra$_res(SVNOperationExport.this).getString("UI_EXP_PROGRESS_TITLE"), (Object)this.getProgressMessage(), null);
            progress.setCancellable(false);
            progress.setCloseOnFinish(true);
            progress.setMillisToPopup(500);
            progress.start();
            ISVNClientAdapter client = null;
            URL exportPath = this.getExportPath();
            try {
                try {
                    client = SVNUtil.getIDEClientAdapter();
                    SVNOperationLogger.getInstance().beginOperation(client, this.getReposInfo());
                    this.executeExport(client, exportPath);
                }
                catch (SVNClientException ce) {
                    ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ce), (String)SVNOperationExport.ra$_res(SVNOperationExport.this).getString("ACTION_EXPORT_ERROR_TITLE"), (String)SVNOperationExport.ra$_res(SVNOperationExport.this).getString("ACTION_EXPORT_ERROR_MSG", (Object)URLFileSystem.getPlatformPathName((URL)exportPath)));
                }
            }
            finally {
                if (client != null) {
                    SVNOperationLogger.getInstance().endOperation();
                }
                progress.finish();
            }
        }

        protected SVNRepositoryInfo getReposInfo() {
            return null;
        }

        protected abstract String getProgressMessage();

        protected abstract URL getExportPath();

        protected abstract void executeExport(ISVNClientAdapter var1, URL var2) throws SVNClientException;

        private ExportTask() {
        }

        ExportTask(7 var2_2) {
            this();
        }

        ExportTask(4 var2_2) {
            this();
        }
    }
}

