/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.net.URL;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.op.SVNOperationAddProperty;
import oracle.jdevimpl.vcs.svn.op.ui.PropertyEditorPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public class SVNOperationIgnore
extends SVNOperationAddProperty {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.ignore";
    private URL[] _selectedURLs;

    public SVNOperationIgnore() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        URL[] selectedURLs = this.getSelectedURLs(profile);
        if (selectedURLs == null || selectedURLs.length == 0) {
            return false;
        }
        return this.inSameFolder(selectedURLs);
    }

    protected JEWTDialog createDialog() {
        String title = this._res.getString("ACTION_IGNORE_DIALOG_TITLE");
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this.getPanel(), null, (String)title, (int)7);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_IGNORE_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        dialog.setDefaultButton(1);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getPanel(), "f1_svnignore_html");
        return dialog;
    }

    protected PropertyEditorPanel createPanel() {
        this._selectedURLs = this.getSelectedUrls();
        PropertyEditorPanel panel = super.createPanel();
        panel.setResourceField(SVNUtil.toFile(URLFileSystem.getParent((URL)this._selectedURLs[0])));
        panel.removeAllPropertyNames();
        panel.setNameComboBoxEditable(false);
        panel.setPropertyName("svn:ignore");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._selectedURLs.length) {
            sb.append(URLFileSystem.getFileName((URL)this._selectedURLs[i]));
            sb.append(" ");
            ++i;
        }
        panel.setStringPropertyValue(sb.toString().trim());
        panel.hideFileField();
        return panel;
    }

    private URL[] getSelectedURLs(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        return VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
    }

    private boolean inSameFolder(URL[] selectedURLs) {
        URL commonParent = URLFileSystem.getParent((URL)selectedURLs[0]);
        int i = 1;
        while (i < selectedURLs.length) {
            if (!commonParent.equals(URLFileSystem.getParent((URL)selectedURLs[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

