/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public final class SVNOperationMarkResolved
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.resolved";

    public SVNOperationMarkResolved() {
        super(COMMAND_ID);
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        progress.setMaximum(resources.length);
        progress.setProgress(0);
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, null, progress);
            int i = 0;
            while (i < resources.length) {
                client.resolved(SVNUtil.toFile(resources[i]));
                processed.add(resources[i]);
                progress.setProgress(processed.size());
                ++i;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
        }
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, null);
            int i = 0;
            while (i < resources.length) {
                client.resolved(SVNUtil.toFile(resources[i]));
                processed.add(resources[i]);
                ++i;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private String getProgressTitle() {
        return this._res.getString("ACTION_MARK_RESOLVED_PROGRESS_TITLE");
    }

    private String getProgressMessage() {
        return this._res.getString("ACTION_MARK_RESOLVED_PROGRESS_MESSAGE");
    }
}

