/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.MergePanel;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationMerge
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.merge";
    private MergePanel _mergePanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;

    public SVNOperationMerge() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        this._wcInfo = this.getWCInfo();
        if (this._wcInfo == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_BRANCH_ERROR_MESSAGE_NO_INFO"), (String)this._res.getString("ACTION_BRANCH_ERROR_TITLE_NO_INFO"), null);
            return 1;
        }
        this.createPanel();
        this.createDialog();
        this.initListeners();
        this.initPanel();
        if (this._dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    private void initPanel() {
        this._mergePanel.setToField(this.getFromURLString());
        this._mergePanel.setFromField(this.getFromURLString());
        this._mergePanel.setContext(this.getContext());
        this._mergePanel.setApplyWCField(this.getCurrentWC());
        this._mergePanel.fireValidContent(this._mergePanel.validateContent());
    }

    private String getCurrentWC() {
        if (this._wcInfo != null) {
            return this._wcInfo.getFile().toString();
        }
        return null;
    }

    private void setOKButton(boolean containsValidContent) {
        EventQueue.invokeLater(new 1(this, containsValidContent));
    }

    private ISVNInfo getWCInfo() {
        Node node = this.getContext().getNode();
        URL url = null;
        File file = null;
        if (node != null) {
            url = node.getURL();
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jws") || suffix.equals(".jpr")) {
                url = URLFileSystem.getParent((URL)url);
            }
        } else {
            Element elem = this.getContext().getElement();
            if (elem instanceof RelativeDirectoryContextFolder) {
                url = ((RelativeDirectoryContextFolder)elem).getRootDirectories().getFirstEntry();
            }
        }
        file = SVNUtil.toFile(url);
        ISVNClientAdapter client = null;
        try {
            ISVNInfo info;
            client = SVNUtil.getIDEClientAdapter();
            ISVNInfo iSVNInfo = info = client.getInfoFromWorkingCopy(file);
            return iSVNInfo;
        }
        catch (SVNClientException e) {
            ISVNInfo iSVNInfo = null;
            return iSVNInfo;
        }
    }

    private void createPanel() {
        this._mergePanel = new MergePanel();
    }

    private void createDialog() {
        String title = this._res.getString("ACTION_MERGE_DIALOG_TITLE");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this._mergePanel, (Component)this._mergePanel.getInitialFocus(), (String)title, (int)7);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_MERGE_DIALOG_HEADER_DESC"));
        this._dialog.setDialogHeader((Component)header);
        this._dialog.setDefaultButton(1);
        this._dialog.setContent((Component)this._mergePanel);
        this._dialog.setResizable(true);
        this._dialog.setMinimumSize(350, 570);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._mergePanel, "f1_svnmerge_html");
    }

    private String getFromURLString() {
        return this._wcInfo.getUrlString();
    }

    private void initListeners() {
        this._dialog.addVetoableChangeListener((VetoableChangeListener)new 2());
        this._mergePanel.addListener(new 3());
    }

    static MergePanel ra$_mergePanel(SVNOperationMerge sVNOperationMerge) {
        return sVNOperationMerge._mergePanel;
    }

    static ISVNInfo ra$_wcInfo(SVNOperationMerge sVNOperationMerge) {
        return sVNOperationMerge._wcInfo;
    }

    static JEWTDialog ra$_dialog(SVNOperationMerge sVNOperationMerge) {
        return sVNOperationMerge._dialog;
    }

    static void mav$setOKButton(SVNOperationMerge sVNOperationMerge, boolean bl) {
        sVNOperationMerge.setOKButton(bl);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$containsValidContent;
        final /* synthetic */ SVNOperationMerge this$0;

        public void run() {
            SVNOperationMerge.ra$_dialog(this.this$0).setOKButtonEnabled(this.v$containsValidContent);
        }

        public 1(SVNOperationMerge sVNOperationMerge, boolean bl) {
            this.v$containsValidContent = bl;
            this.this$0 = sVNOperationMerge;
        }
    }

    final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            MergeThread mergeThread = new MergeThread(null);
            mergeThread.start();
        }
    }

    final class 3
    implements MonitoredPanel.PanelListener {
        public void setContainsURL(boolean containsValidContent) {
            SVNOperationMerge.mav$setOKButton(SVNOperationMerge.this, containsValidContent);
            SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).setTestButtonEnabled(containsValidContent);
        }
    }

    private class MergeThread
    extends Thread {
        IndeterminateProgressMonitor progressMon;
        SVNUrl fromUrl;
        SVNUrl toUrl;
        SVNRevision fromRevision;
        SVNRevision toRevision;
        File destFile;
        boolean isNoAncestry;
        boolean isForce;
        boolean isDryRun;
        boolean isRecurse;

        private void $init$() {
            this.isRecurse = true;
        }

        private MergeThread() {
            super("svn-merge-thread");
            this.$init$();
        }

        public void run() {
            WaitCursor wc = new WaitCursor(SVNOperationMerge.ra$_dialog(SVNOperationMerge.this).getContent());
            EventQueue.invokeLater(new 1(this, wc));
            this.executeMergingWithProgress();
            SwingUtilities.invokeLater(new 2());
            EventQueue.invokeLater(new 3(this, wc));
        }

        private void executeMergingWithProgress() {
            this.progressMon = new IndeterminateProgressMonitor((Component)SVNOperationMerge.ra$_dialog(SVNOperationMerge.this), SVNOperationMerge.this._res.getString("ACTION_MERGE_PROGRESS_TITLE"), (Object)SVNOperationMerge.this._res.getString("ACTION_MERGE_PROGRESS_MESSAGE"), null);
            this.progressMon.setMillisToPopup(500);
            this.progressMon.setCloseOnFinish(true);
            this.progressMon.setCancellable(false);
            this.progressMon.start();
            try {
                this.executeMerging();
            }
            finally {
                this.progressMon.finish();
            }
        }

        private void executeMerging() {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNOperationMerge.ra$_wcInfo(SVNOperationMerge.this).getRepository());
            try {
                try {
                    this.getParameters();
                    ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                    SVNOperationLogger.getInstance().beginOperation(svnClient, repoInfo, this.progressMon);
                    svnClient.merge(this.fromUrl, this.fromRevision, this.toUrl, this.toRevision, this.destFile, this.isForce, this.isRecurse, this.isDryRun);
                    this.refreshNodes();
                }
                catch (SVNClientException e) {
                    e.printStackTrace();
                }
                catch (IOException ioe) {
                    MessageDialog.error((Component)SVNOperationMerge.ra$_dialog(SVNOperationMerge.this), (Object)SVNOperationMerge.this._res.getString("ACTION_MERGE_DEST_NOT_EXIST"), (String)SVNOperationMerge.this._res.getString("ACTION_MERGE_DEST_NOT_EXIST_TITLE"), null);
                }
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }

        private void getParameters() throws IOException {
            this.fromUrl = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getFromUrl();
            this.fromRevision = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getFromRevision();
            this.toUrl = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getToUrl();
            this.toRevision = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getToRevision();
            this.destFile = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getApplyWCFile();
            if (!this.destFile.exists()) {
                throw new IOException();
            }
            this.isNoAncestry = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getNoAncestryStatus();
            this.isForce = SVNOperationMerge.ra$_mergePanel(SVNOperationMerge.this).getForceStatus();
            this.isDryRun = false;
        }

        private void refreshNodes() {
            Context ctx = SVNOperationMerge.this.getContext();
            this.refreshNodes(ctx.getElement());
        }

        private void refreshNodes(Element elem) {
            if (elem != null) {
                if (!elem.mayHaveChildren()) {
                    if (elem instanceof Node && ((Node)elem).isOpen()) {
                        VCSBufferUtils.reloadBuffer((URL)((Node)elem).getURL());
                        return;
                    }
                } else {
                    Iterator it = elem.getChildren();
                    while (it != null && it.hasNext()) {
                        this.refreshNodes((Element)it.next());
                    }
                }
            }
        }

        MergeThread(oracle.jdevimpl.vcs.svn.op.SVNOperationMerge$2 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ MergeThread this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(MergeThread mergeThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = mergeThread;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                SVNOperationMerge.ra$_dialog(SVNOperationMerge.this).setVisible(false);
                SVNOperationMerge.ra$_dialog(SVNOperationMerge.this).dispose();
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ MergeThread this$0;

            public void run() {
                this.v$wc.hide();
            }

            public 3(MergeThread mergeThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = mergeThread;
            }
        }
    }
}

