/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.NewRemoteDirPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNOperationNewRemoteDir
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.new-remote-directory";
    public static final String DIR_NAME_PROP_KEY = SVNOperationNewRemoteDir.class.getName() + ".dirName";
    private SVNRepositoryInfo _repos;
    private SVNUrl _parent;
    private boolean _useProgress;
    private String newDirName;
    private Component _parentComponent;

    private void $init$() {
        this._useProgress = true;
        this.newDirName = null;
    }

    public SVNOperationNewRemoteDir() {
        super(COMMAND_ID);
        this.$init$();
    }

    public SVNOperationNewRemoteDir(SVNRepositoryInfo repos, SVNUrl parent, boolean useProgressBar) {
        this();
        this._repos = repos;
        this._parent = parent;
        this._useProgress = useProgressBar;
    }

    public SVNOperationNewRemoteDir(SVNRepositoryInfo repos, SVNUrl parentURL, Component parentComponent, boolean useProgressBar) {
        this();
        this._repos = repos;
        this._parent = parentURL;
        this._useProgress = useProgressBar;
        this._parentComponent = parentComponent;
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        if (this._repos != null && this._parent != null) {
            return true;
        }
        SVNRemoteNode node = SVNUtil.getSVNRemoteNode(this.getContext());
        return node != null && node instanceof SVNRemoteContainer;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        SVNRemoteContainer aNode = null;
        if (this._repos == null || this._parent == null) {
            SVNRemoteNode node = SVNUtil.getSVNRemoteNode(this.getContext());
            if (node == null || !(node instanceof SVNRemoteContainer)) {
                return 1;
            }
            this._repos = (SVNRepositoryInfo)node.getParentRepository().getData();
            this._parent = node.getSVNUrl();
            aNode = (SVNRemoteContainer)node;
        }
        NewRemoteDirPanel panel = new NewRemoteDirPanel(this._parent);
        JEWTDialog dialog = this.createDialog(panel);
        SVNRemoteContainer toReload = aNode;
        panel.addDirectoryNameListener(new 1(this, dialog));
        dialog.addVetoableChangeListener((VetoableChangeListener)new 2(this, dialog, panel, (Node)toReload));
        boolean success = WizardLauncher.runDialog((JDialog)dialog);
        this.getContext().setProperty(DIR_NAME_PROP_KEY, (Object)(success ? panel.getDirectoryName() : null));
        return success ? 0 : 1;
    }

    private JEWTDialog createDialog(NewRemoteDirPanel panel) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)(this._parentComponent == null ? VCSWindowUtils.getCurrentWindow() : this._parentComponent), (Component)panel, (Component)panel.getInitialFocus(), (String)this._res.getString("UI_CREATE_REMOTE_DIR_DIALOG_TITLE"), (int)7);
        dialog.setResizable(true);
        dialog.setOKButtonEnabled(false);
        dialog.setDefaultButton(1);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svncreateremotedirectory_html");
        return dialog;
    }

    static void wa$newDirName(SVNOperationNewRemoteDir sVNOperationNewRemoteDir, String string) {
        sVNOperationNewRemoteDir.newDirName = string;
    }

    static void wa$context(SVNOperationNewRemoteDir sVNOperationNewRemoteDir, Context context) {
        sVNOperationNewRemoteDir.context = context;
    }

    static String ra$newDirName(SVNOperationNewRemoteDir sVNOperationNewRemoteDir) {
        return sVNOperationNewRemoteDir.newDirName;
    }

    static Context ra$context(SVNOperationNewRemoteDir sVNOperationNewRemoteDir) {
        return sVNOperationNewRemoteDir.context;
    }

    static SVNRepositoryInfo ra$_repos(SVNOperationNewRemoteDir sVNOperationNewRemoteDir) {
        return sVNOperationNewRemoteDir._repos;
    }

    static SVNUrl ra$_parent(SVNOperationNewRemoteDir sVNOperationNewRemoteDir) {
        return sVNOperationNewRemoteDir._parent;
    }

    static boolean ra$_useProgress(SVNOperationNewRemoteDir sVNOperationNewRemoteDir) {
        return sVNOperationNewRemoteDir._useProgress;
    }

    final class 1
    implements NewRemoteDirPanel.Listener {
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ SVNOperationNewRemoteDir this$0;

        public void directoryNameChanged(String newName) {
            this.v$dialog.setOKButtonEnabled(newName != null && newName.length() > 0);
        }

        public 1(SVNOperationNewRemoteDir sVNOperationNewRemoteDir, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.this$0 = sVNOperationNewRemoteDir;
        }
    }

    final class 2
    implements VetoableChangeListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ NewRemoteDirPanel v$panel;
        private final /* synthetic */ Node v$toReload;
        final /* synthetic */ SVNOperationNewRemoteDir this$0;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            this.v$dialog.setOKButtonEnabled(false);
            new Thread((Runnable)this.this$0.new NewRemoteDirTask(this.v$dialog, this.v$panel, SVNOperationNewRemoteDir.ra$_repos(this.this$0), SVNOperationNewRemoteDir.ra$_parent(this.this$0), SVNOperationNewRemoteDir.ra$_useProgress(this.this$0), this.v$toReload, null), "svn-createremotedir-thread").start();
            throw new PropertyVetoException("", pce);
        }

        public 2(SVNOperationNewRemoteDir sVNOperationNewRemoteDir, JEWTDialog jEWTDialog, NewRemoteDirPanel newRemoteDirPanel, Node node) {
            this.v$toReload = node;
            this.v$panel = newRemoteDirPanel;
            this.v$dialog = jEWTDialog;
            this.this$0 = sVNOperationNewRemoteDir;
        }
    }

    private final class NewRemoteDirTask
    implements Runnable {
        private final JEWTDialog _dialog;
        private final NewRemoteDirPanel _panel;
        private final SVNRepositoryInfo _repos;
        private final SVNUrl _parent;
        private final boolean _useProgress;
        private final Node _toReload;

        private NewRemoteDirTask(JEWTDialog dialog, NewRemoteDirPanel panel, SVNRepositoryInfo repos, SVNUrl parent, boolean useProgressBar, Node toReload) {
            this._dialog = dialog;
            this._panel = panel;
            this._repos = repos;
            this._parent = parent;
            this._useProgress = useProgressBar;
            this._toReload = toReload;
        }

        public void run() {
            block9: {
                WaitCursor wc = new WaitCursor((Component)this._panel);
                EventQueue.invokeLater(new 1(this, wc));
                try {
                    try {
                        if (this._useProgress) {
                            SVNOperationNewRemoteDir.wa$newDirName(SVNOperationNewRemoteDir.this, this._panel.getDirectoryName());
                            this.executeMkdirWithProgress(this._parent, this._panel.getDirectoryName(), this._panel.getComments());
                        } else {
                            SVNOperationNewRemoteDir.wa$newDirName(SVNOperationNewRemoteDir.this, this._panel.getDirectoryName());
                            this.executeMkdir(this._parent, this._panel.getDirectoryName(), this._panel.getComments());
                        }
                        SwingUtilities.invokeLater(new 2());
                        if (this._toReload == null) break block9;
                        RevertNodeCommand.reload((Node)this._toReload, (boolean)false);
                        SVNOperationNewRemoteDir.wa$context(SVNOperationNewRemoteDir.this, SVNOperationNewRemoteDir.this.getContext());
                        Iterator it = this._toReload.getChildren();
                        while (it.hasNext()) {
                            Node child = (Node)it.next();
                            if (!child.getShortLabel().equals(SVNOperationNewRemoteDir.ra$newDirName(SVNOperationNewRemoteDir.this))) continue;
                            NavigatorWindow nav = (NavigatorWindow)SVNOperationNewRemoteDir.ra$context(SVNOperationNewRemoteDir.this).getView();
                            TreeExplorer explorer = nav.getTreeExplorer();
                            TNode rootTNode = explorer.getRoot();
                            TNode parentT = explorer.searchTNode((Element)this._toReload, rootTNode);
                            explorer.open(parentT);
                            TNode childT = explorer.searchTNode((Element)child, parentT);
                            if (parentT != null && childT != null) {
                                explorer.setSelected(childT);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        ExceptionDialog.showExceptionDialog((Component)this._dialog, (Throwable)e, (String)SVNOperationNewRemoteDir.this._res.getString("ACTION_CREATE_REMOTE_DIR_ERROR_TITLE"), (String)SVNOperationNewRemoteDir.this._res.getString("ACTION_CREATE_REMOTE_DIR_ERROR_MESSAGE", new Object[]{this._parent.toString(), this._panel.getDirectoryName()}), null);
                        SwingUtilities.invokeLater(new 3());
                    }
                }
                finally {
                    EventQueue.invokeLater(new 4(this, wc));
                }
            }
        }

        private void executeMkdirWithProgress(SVNUrl parentPath, String newDir, String comments) throws SVNClientException {
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)this._dialog, SVNOperationNewRemoteDir.this._res.getString("ACTION_CREATE_REMOTE_DIR_PROGRESS_TITLE"), (Object)SVNOperationNewRemoteDir.this._res.getString("ACTION_CREATE_REMOTE_DIR_PROGRESS_MESSAGE"), null);
            progress.setMillisToPopup(500);
            progress.setCloseOnFinish(true);
            progress.setCancellable(false);
            progress.start();
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, this._repos, progress);
                client.mkdir(parentPath.appendPath(newDir), comments);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                progress.finish();
            }
        }

        private void executeMkdir(SVNUrl parentPath, String newDir, String comments) throws SVNClientException {
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, this._repos);
                client.mkdir(parentPath.appendPath(newDir), comments);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }

        NewRemoteDirTask(JEWTDialog jEWTDialog, NewRemoteDirPanel newRemoteDirPanel, SVNRepositoryInfo sVNRepositoryInfo, SVNUrl sVNUrl, boolean bl, Node node, oracle.jdevimpl.vcs.svn.op.SVNOperationNewRemoteDir$2 var8_8) {
            this(jEWTDialog, newRemoteDirPanel, sVNRepositoryInfo, sVNUrl, bl, node);
        }

        static JEWTDialog ra$_dialog(NewRemoteDirTask newRemoteDirTask) {
            return newRemoteDirTask._dialog;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ NewRemoteDirTask this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(NewRemoteDirTask newRemoteDirTask, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = newRemoteDirTask;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                NewRemoteDirTask.ra$_dialog(NewRemoteDirTask.this).setVisible(false);
                NewRemoteDirTask.ra$_dialog(NewRemoteDirTask.this).dispose();
            }
        }

        final class 3
        implements Runnable {
            public void run() {
                NewRemoteDirTask.ra$_dialog(NewRemoteDirTask.this).setOKButtonEnabled(true);
            }
        }

        final class 4
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ NewRemoteDirTask this$0;

            public void run() {
                this.v$wc.hide();
            }

            public 4(NewRemoteDirTask newRemoteDirTask, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = newRemoteDirTask;
            }
        }
    }
}

