/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.merge.MergeUtil;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.svn.merge.SVNMergeEditor;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNOperationResolveConflicts
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.resolve-conflicts";

    public static final boolean isEditorAvailable(URL url) throws Exception {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            URLFilter wcf = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
            if (URLFileSystem.exists((URL)url) && wcf.accept(url)) {
                return profile.getStatusCache().get(url) == profile.getStatusInstance("CONFLICTS");
            }
        }
        return false;
    }

    public SVNOperationResolveConflicts() {
        super(COMMAND_ID);
    }

    protected int doitImpl() throws Exception {
        Node node = this.getContext().getNode();
        if (SVNUtil.isPropertiesConflicted(node.getURL())) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)this._res.getString("PROP_CONFLICTS_MESSAGE", (Object)URLFileSystem.getFileName((URL)node.getURL())), (String)this._res.getString("PROP_CONFLICTS_TITLE"), (String)"f1_svnversionedpropertyconflicts_html");
        }
        if (SVNUtil.isTextConflicted(node.getURL())) {
            MergeUtil.reopenMergeEditor((Node)node, SVNMergeEditor.class);
            return 0;
        }
        return 1;
    }
}

