/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.RecursiveOperationCustomizer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNOperationRevert
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.revert";

    public SVNOperationRevert() {
        super(COMMAND_ID);
    }

    protected SVNOperationRevert(String commandId) {
        super(commandId);
    }

    protected boolean isAvailableImpl() throws Exception {
        if (!super.isAvailableImpl()) {
            return false;
        }
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length > 1) {
            return true;
        }
        if (locatables.length == 1) {
            URL url = VCSModelUtils.getLocatableURL((Object)locatables[0]);
            if (URLFileSystem.isDirectory((URL)url)) {
                return true;
            }
            Node node = this.context.getNode();
            boolean isModified = SVNUtil.isTextModified(url);
            if (isModified || node.isDirty()) {
                return true;
            }
        }
        return super.isAvailableImpl();
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        CommandState commandState = this.getCommandState(profile, locatables);
        if (commandState == null) {
            return 9;
        }
        boolean success = this.invokeCommand(profile, commandState);
        this.postInvoke(profile, commandState);
        return success ? 0 : 1;
    }

    private int revertDirtyNodes(boolean recursive) throws Exception {
        VCSProfile profile = this.getProfile();
        Locatable[] locatables = this.getOperands(profile);
        Node[] affectedNodes = this.findAffectedNodes(locatables, recursive);
        Node[] dirtyNodes = VCSModelUtils.getDirtyNodes((Node[])affectedNodes);
        if (dirtyNodes.length > 0) {
            boolean confirmed = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_REVERT_UNSAVED_PROMPT_MESSAGE"), (String)this._res.getString("ACTION_REVERT_UNSAVED_PROMPT_TITLE"), null);
            if (!confirmed) {
                return 1;
            }
            int i = 0;
            while (i < dirtyNodes.length) {
                dirtyNodes[i].close();
                dirtyNodes[i].open();
                dirtyNodes[i].revert();
                ++i;
            }
        }
        return 0;
    }

    private Node[] findAffectedNodes(Locatable[] locatables, boolean recursive) {
        if (!recursive) {
            return VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createSpecificURLFilter((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])locatables)));
        }
        return VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])locatables)));
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        RecursiveOperationCustomizer cust = new RecursiveOperationCustomizer();
        HashMap<String, Boolean> opts = new HashMap<String, Boolean>();
        opts.put("oracle.jdeveloper.subversion.RECURSIVE", Boolean.FALSE);
        cust.setOptions(opts);
        return cust;
    }

    protected String getProgressTitle() {
        return this._res.getString("ACTION_REVERT_PROGRESS_TITLE");
    }

    protected String getProgressMessage() {
        return this._res.getString("ACTION_REVERT_PROGRESS_MESSAGE");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        TreeSet directories = new TreeSet(new 1());
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        boolean recursive = false;
        Boolean option = (Boolean)options.get("oracle.jdeveloper.subversion.RECURSIVE");
        boolean bl = recursive = option != null ? option : false;
        if (this.revertDirtyNodes(recursive) == 1) {
            return false;
        }
        HashSet files = new HashSet();
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        this.sortResources(resources, directories, files);
        if (directories.size() + files.size() != resources.length) {
            throw new IllegalStateException();
        }
        progress.setMaximum(resources.length);
        progress.setProgress(0);
        try {
            block9: {
                Iterator it;
                ISVNClientAdapter client;
                block8: {
                    client = SVNUtil.getIDEClientAdapter();
                    SVNOperationLogger.getInstance().beginOperation(client, null, progress);
                    it = files.iterator();
                    while (it.hasNext() && !progress.isCanceled()) {
                        progress.setProgress(processed.size());
                        URL url = (URL)it.next();
                        client.revert(SVNUtil.toFile(url), recursive);
                        processed.add(url);
                    }
                    it = directories.iterator();
                    if (!true) break block8;
                    if (!it.hasNext()) return true;
                    if (progress.isCanceled()) break block9;
                }
                do {
                    progress.setProgress(processed.size());
                    URL url = (URL)it.next();
                    client.revert(SVNUtil.toFile(url), recursive);
                    processed.add(url);
                    if (!it.hasNext()) return true;
                } while (!progress.isCanceled());
            }
            return true;
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
            commandState.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)recursive);
            commandState.setProperty(AbstractSVNOperation.PROPERTY_RESOURCES_STRUCTURE_CHANGED, (Object)processed.toArray(new URL[processed.size()]));
        }
    }

    private void sortResources(URL[] resources, Set directories, Set files) {
        if (resources == null || resources.length == 0) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            if (URLFileSystem.isDirectoryPath((URL)resources[i])) {
                directories.add(resources[i]);
            } else {
                files.add(resources[i]);
            }
            ++i;
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return URLFileSystem.getPlatformPathName((URL)((URL)o2)).compareTo(URLFileSystem.getPlatformPathName((URL)((URL)o1)));
        }
    }
}

