/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SwitchPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationSwitch
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.switch";
    private SwitchPanel _switchPanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;

    public SVNOperationSwitch() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        this._wcInfo = this.getWCInfo();
        if (this._wcInfo == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_BRANCH_ERROR_MESSAGE_NO_INFO"), (String)this._res.getString("ACTION_BRANCH_ERROR_TITLE_NO_INFO"), null);
            return 1;
        }
        this.createPanel();
        this.createDialog();
        this.initListeners();
        if (this.getContext().getProperty("destFile") != null) {
            SwitchThread switchThread = new SwitchThread(null);
            switchThread.start();
            return 0;
        }
        if (this._dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    private ISVNInfo getWCInfo() {
        Node node = this.getContext().getNode();
        URL url = null;
        File file = null;
        if (node != null) {
            url = node.getURL();
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jws") || suffix.equals(".jpr")) {
                url = URLFileSystem.getParent((URL)url);
            }
        } else {
            Element elem = this.getContext().getElement();
            if (elem instanceof RelativeDirectoryContextFolder) {
                url = ((RelativeDirectoryContextFolder)elem).getRootDirectories().getFirstEntry();
            }
        }
        file = SVNUtil.toFile(url);
        ISVNClientAdapter client = null;
        try {
            ISVNInfo info;
            client = SVNUtil.getIDEClientAdapter();
            ISVNInfo iSVNInfo = info = client.getInfoFromWorkingCopy(file);
            return iSVNInfo;
        }
        catch (SVNClientException e) {
            ISVNInfo iSVNInfo = null;
            return iSVNInfo;
        }
    }

    private void createPanel() {
        this._switchPanel = new SwitchPanel();
        this._switchPanel.setFromField(this._wcInfo.getUrl().toString());
        this._switchPanel.setToField(this._wcInfo.getUrl().toString());
        this._switchPanel.setContext(this.getContext());
    }

    private void createDialog() {
        String title = this._res.getString("ACTION_SWITCH_DIALOG_TITLE");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this._switchPanel, (Component)this._switchPanel.getInitialFocus(), (String)title, (int)7);
        this._dialog.setDefaultButton(1);
        this._dialog.setContent((Component)this._switchPanel);
        this._dialog.setResizable(true);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_SWITCH_DIALOG_HEADER_DESC"));
        this._dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._switchPanel, "f1_svnswitch_html");
    }

    private void initListeners() {
        this._dialog.addVetoableChangeListener((VetoableChangeListener)new 1());
        this._switchPanel.addListener(new 2());
    }

    private void setOKButton(boolean containsValidContent) {
        EventQueue.invokeLater(new 3(this, containsValidContent));
    }

    static ISVNInfo ra$_wcInfo(SVNOperationSwitch sVNOperationSwitch) {
        return sVNOperationSwitch._wcInfo;
    }

    static SwitchPanel ra$_switchPanel(SVNOperationSwitch sVNOperationSwitch) {
        return sVNOperationSwitch._switchPanel;
    }

    static JEWTDialog ra$_dialog(SVNOperationSwitch sVNOperationSwitch) {
        return sVNOperationSwitch._dialog;
    }

    static void mav$setOKButton(SVNOperationSwitch sVNOperationSwitch, boolean bl) {
        sVNOperationSwitch.setOKButton(bl);
    }

    final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            SwitchThread switchThread = new SwitchThread(null);
            switchThread.start();
        }
    }

    final class 2
    implements MonitoredPanel.PanelListener {
        public void setContainsURL(boolean containsValidContent) {
            SVNOperationSwitch.mav$setOKButton(SVNOperationSwitch.this, containsValidContent);
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ boolean v$containsValidContent;
        final /* synthetic */ SVNOperationSwitch this$0;

        public void run() {
            SVNOperationSwitch.ra$_dialog(this.this$0).setOKButtonEnabled(this.v$containsValidContent);
        }

        public 3(SVNOperationSwitch sVNOperationSwitch, boolean bl) {
            this.v$containsValidContent = bl;
            this.this$0 = sVNOperationSwitch;
        }
    }

    private class SwitchThread
    extends Thread {
        IndeterminateProgressMonitor progressMon;
        File destFile;
        SVNUrl toUrl;
        SVNRevision toRevision;
        boolean isRecursive;

        private void $init$() {
            this.isRecursive = true;
        }

        private SwitchThread() {
            super("svn-switch-thread");
            this.$init$();
        }

        public void run() {
            WaitCursor wc = new WaitCursor(SVNOperationSwitch.ra$_dialog(SVNOperationSwitch.this).getContent());
            EventQueue.invokeLater(new 1(this, wc));
            this.executeSwitchingWithProgress();
            SwingUtilities.invokeLater(new 2());
            EventQueue.invokeLater(new 3(this, wc));
        }

        private void executeSwitchingWithProgress() {
            this.progressMon = new IndeterminateProgressMonitor((Component)SVNOperationSwitch.ra$_dialog(SVNOperationSwitch.this), SVNOperationSwitch.this._res.getString("ACTION_SWITCH_PROGRESS_TITLE"), (Object)SVNOperationSwitch.this._res.getString("ACTION_SWITCH_PROGRESS_MESSAGE"), null);
            this.progressMon.setMillisToPopup(500);
            this.progressMon.setCloseOnFinish(true);
            this.progressMon.setCancellable(false);
            this.progressMon.start();
            try {
                this.executeSwitching();
            }
            finally {
                this.progressMon.finish();
            }
        }

        private void executeSwitching() {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNOperationSwitch.ra$_wcInfo(SVNOperationSwitch.this).getRepository());
            this.getParameters();
            try {
                try {
                    ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                    SVNOperationLogger.getInstance().beginOperation(svnClient, repoInfo, this.progressMon);
                    svnClient.switchToUrl(this.destFile, this.toUrl, this.toRevision, this.isRecursive);
                    this.refreshNodes();
                }
                catch (SVNClientException sVNClientException) {}
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }

        private void getParameters() {
            Context ctx = SVNOperationSwitch.this.getContext();
            if (ctx.getProperty("destFile") != null) {
                this.destFile = (File)ctx.getProperty("destFile");
                this.toUrl = (SVNUrl)ctx.getProperty("toUrl");
                this.toRevision = SVNRevision.HEAD;
            } else {
                this.destFile = SVNOperationSwitch.ra$_wcInfo(SVNOperationSwitch.this).getFile();
                this.toUrl = SVNOperationSwitch.ra$_switchPanel(SVNOperationSwitch.this).getToUrl();
                this.toRevision = SVNOperationSwitch.ra$_switchPanel(SVNOperationSwitch.this).getRevision();
            }
        }

        private void refreshNodes() {
            Context ctx = SVNOperationSwitch.this.getContext();
            this.refreshNodes(ctx.getElement());
        }

        private void refreshNodes(Element elem) {
            if (elem != null) {
                if (!elem.mayHaveChildren()) {
                    if (elem instanceof Node && ((Node)elem).isOpen()) {
                        VCSBufferUtils.reloadBuffer((URL)((Node)elem).getURL());
                        return;
                    }
                } else {
                    Iterator it = elem.getChildren();
                    while (it != null && it.hasNext()) {
                        this.refreshNodes((Element)it.next());
                    }
                }
            }
        }

        SwitchThread(3 var2_2) {
            this();
        }

        SwitchThread(oracle.jdevimpl.vcs.svn.op.SVNOperationSwitch$1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ SwitchThread this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(SwitchThread switchThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = switchThread;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                SVNOperationSwitch.ra$_dialog(SVNOperationSwitch.this).setVisible(false);
                SVNOperationSwitch.ra$_dialog(SVNOperationSwitch.this).dispose();
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ SwitchThread this$0;

            public void run() {
                this.v$wc.hide();
            }

            public 3(SwitchThread switchThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = switchThread;
            }
        }
    }
}

