/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.UpdateCustomizer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNOperationUpdate
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.update";

    public SVNOperationUpdate() {
        super(COMMAND_ID);
    }

    SVNOperationUpdate(String commandId) {
        super(commandId);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        UpdateCustomizer customizer = new UpdateCustomizer();
        HashMap<String, Object> defaultOpts = new HashMap<String, Object>(7);
        defaultOpts.put("oracle.jdeveloper.subversion.REVISION", SVNRevision.HEAD);
        defaultOpts.put("oracle.jdeveloper.subversion.IGNORE_EXTERNALS", Boolean.FALSE);
        defaultOpts.put("oracle.jdeveloper.subversion.RECURSIVE", Boolean.TRUE);
        customizer.setOptions(defaultOpts);
        return customizer;
    }

    protected String getProgressTitle() {
        return this._res.getString("ACTION_UPDATE_PROGRESS_TITLE");
    }

    protected String getProgressMessage() {
        return this._res.getString("ACTION_UPDATE_PROGRESS_MESSAGE");
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        SVNRevision revision = (SVNRevision)options.get("oracle.jdeveloper.subversion.REVISION");
        boolean ignoreExternals = (Boolean)options.get("oracle.jdeveloper.subversion.IGNORE_EXTERNALS");
        boolean recursive = (Boolean)options.get("oracle.jdeveloper.subversion.RECURSIVE");
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        URL[] operands = recursive ? this.sortForRecursive(resources) : this.sortForNonRecursive(resources);
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            progress.setMaximum(operands.length + 1);
            progress.setProgress(0);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            int i = 0;
            while (i < operands.length && !progress.isCancelled()) {
                client.update(new File[]{SVNUtil.toFile(operands[i])}, revision, recursive, ignoreExternals);
                processed.add(operands[i]);
                progress.setProgress(processed.size());
                ++i;
            }
            this.postUpdate(operands);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
            commandState.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)recursive);
        }
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        SVNRevision revision = SVNRevision.HEAD;
        boolean ignoreExternals = true;
        boolean recursive = true;
        URL[] resources = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
        URL[] operands = recursive ? this.sortForRecursive(resources) : this.sortForNonRecursive(resources);
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            Collection processed = this.getProcessedUrlsNotifier(commandState);
            int i = 0;
            while (i < operands.length) {
                client.update(new File[]{SVNUtil.toFile(operands[i])}, revision, recursive, ignoreExternals);
                processed.add(operands[i]);
                ++i;
            }
            this.postUpdate(operands);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            commandState.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)recursive);
        }
        return true;
    }

    protected void postUpdate(URL[] operands) {
        this.fireFileStructureChanged(operands);
    }

    private URL[] sortForRecursive(URL[] resources) {
        return VCSFileSystemUtils.coalesceURLs((URL[])resources);
    }

    private URL[] sortForNonRecursive(URL[] resources) {
        return new URL[0];
    }
}

