/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class BasicCheckoutPanel
extends JPanel
implements CheckoutInfo,
ActionListener {
    private final Collection _listeners;
    private final ResourcePicker _res;
    private final SVNRepositoryInfo _reposInfo;
    private final SVNUrl _sourceUrl;
    private final URL _defaultDestination;
    private JLabel _destLabel;
    private FileField _destField;
    private JButton _browseButton;
    private JCheckBox _revisionCheckbox;
    private JTextField _revisionField;
    private JCheckBox _recurseCheckbox;

    private void $init$() {
        this._listeners = new ArrayList(10);
    }

    public BasicCheckoutPanel(SVNRepositoryInfo reposInfo, SVNUrl sourceUrl, URL defaultDestination) {
        super(new GridBagLayout());
        this.$init$();
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this._reposInfo = reposInfo;
        this._sourceUrl = sourceUrl;
        this._defaultDestination = defaultDestination;
        this.createComponents(defaultDestination);
        this.layoutComponents();
        this.listen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBCPListener(Listener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBCPListener(Listener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.remove(listener);
        }
    }

    public SVNRepositoryInfo getRepositoryInfo() {
        return this._reposInfo;
    }

    public SVNUrl getSourceURL() {
        return this._sourceUrl;
    }

    public URL getDestinationURL() {
        return URLFactory.newDirURL((String)this._destField.getText());
    }

    public void setDestinationURL(URL dest) {
        this._destField.setText(URLFileSystem.getPlatformPathName((URL)dest));
    }

    public SVNRevision getRevision() {
        String revisionText;
        if (this._revisionCheckbox.isSelected() && (revisionText = this._revisionField.getText()) != null && revisionText.length() > 0) {
            try {
                SVNRevision sVNRevision = SVNRevision.getRevision((String)this._revisionField.getText());
                return sVNRevision;
            }
            catch (ParseException pe) {
                SVNRevision.Number number = SVNRevision.INVALID_REVISION;
                return number;
            }
        }
        return SVNRevision.HEAD;
    }

    public boolean getRecursive() {
        return this._recurseCheckbox.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this._revisionCheckbox) {
            this._revisionField.setEnabled(this._revisionCheckbox.isSelected());
        } else if (source == this._browseButton) {
            this.chooseNewDirectory();
            this.fireNewURLChosen(this.getDestinationURL());
        }
    }

    private void chooseNewDirectory() {
        URL currentUrl = URLFactory.newURL((String)this._destField.getText());
        if (!URLFileSystem.exists((URL)currentUrl)) {
            currentUrl = this._defaultDestination;
        }
        URLChooser chooser = DialogUtil.newURLChooser((URL)currentUrl);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(1);
        if (chooser.showOpenDialog((Component)this) == 0) {
            this._destField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
        }
    }

    private void createComponents(URL defaultUrl) {
        this._destField = new FileField(true);
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._destField, (String)this._res.getString("UI_BASIC_CHECKOUT_PANEL_LABEL_DESTINATION"));
        this._destField.setText(URLFileSystem.getPlatformPathName((URL)defaultUrl));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)this._res.getString("UI_BASIC_CHECKOUT_PANEL_LABEL_BROWSE"));
        this._revisionCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._revisionCheckbox, (String)this._res.getString("UI_BASIC_CHECKOUT_PANEL_LABEL_REVISION"));
        this._revisionField = new JTextField();
        this._revisionCheckbox.setSelected(false);
        this._revisionField.setEnabled(false);
        this._recurseCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._recurseCheckbox, (String)this._res.getString("UI_LABEL_RECURSIVE"));
        this._recurseCheckbox.setSelected(true);
    }

    private void layoutComponents() {
        this.add((Component)this._destLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 5), 0, 0));
        this.add((Component)this._destField, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 150, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionCheckbox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._recurseCheckbox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void listen() {
        this._revisionCheckbox.addActionListener(this);
        this._browseButton.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNewURLChosen(URL newUrl) {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).newURLChosen(newUrl);
            }
        }
    }

    public static interface Listener {
        public void newURLChosen(URL var1);
    }
}

