/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;

public final class CreateReposPanel
extends JPanel
implements ActionListener {
    private JLabel _pathLabel;
    private JTextField _pathField;
    private JButton _pathBrowseButton;
    private JLabel _fsTypeLabel;
    private JRadioButton _fsfsRadio;
    private JRadioButton _bdbRadio;
    private ButtonGroup _fstypeGroup;
    private JLabel _connNameLabel;
    private JTextField _connNameField;

    public CreateReposPanel(URL initialPath) {
        super(new GridBagLayout());
        this.createComponents(URLFileSystem.getPlatformPathName((URL)initialPath));
        this.layoutComponents();
        this.listen();
    }

    public void actionPerformed(ActionEvent event) {
        if (event != null && event.getSource() == this._pathBrowseButton) {
            this.chooseRepositoryPath();
        }
    }

    public Component getInitialFocus() {
        return this._pathField;
    }

    public URL getRepositoryPath() {
        String path = this._pathField.getText();
        String string = path = path != null ? path.trim() : null;
        if (path != null && !path.equals("")) {
            return URLFactory.newDirURL((String)path);
        }
        return null;
    }

    public String getFileSystemType() {
        if (this._fsfsRadio.isSelected()) {
            return "fsfs";
        }
        if (this._bdbRadio.isSelected()) {
            return "bdb";
        }
        return "fsfs";
    }

    public String getConnectionName() {
        String text = this._connNameField.getText();
        return text != null ? text.trim() : null;
    }

    private void createComponents(String initalPath) {
        ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
        this._pathField = new JTextField();
        this._pathField.setText(initalPath);
        this._pathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._pathLabel, (Component)this._pathField, (String)res.getString("UI_CREATE_REPOS_LABEL_PATH"));
        this._pathBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._pathBrowseButton, (String)res.getString("UI_CREATE_REPOS_LABEL_BROWSE"));
        this._fsfsRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._fsfsRadio, (String)res.getString("UI_CREATE_REPOS_LABEL_FSFS"));
        this._bdbRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._bdbRadio, (String)res.getString("UI_CREATE_REPOS_LABEL_BDB"));
        this._fstypeGroup = new ButtonGroup();
        this._fstypeGroup.add(this._fsfsRadio);
        this._fstypeGroup.add(this._bdbRadio);
        this._fsfsRadio.setSelected(true);
        this._fsTypeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._fsTypeLabel, (Component)this._fsfsRadio, (String)res.getString("UI_CREATE_REPOS_LABEL_FSTYPE"));
        this._connNameLabel = new JLabel();
        this._connNameField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._connNameLabel, (Component)this._connNameField, (String)res.getString("UI_CREATE_REPOS_LABEL_CONN_NAME"));
    }

    private void layoutComponents() {
        this.add((Component)this._pathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 6, 5), 0, 0));
        this.add((Component)this._pathField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 6, 5), 100, 0));
        this.add((Component)this._pathBrowseButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 6, 0), 0, 0));
        this.add((Component)this._fsTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 5), 0, 0));
        this.add((Component)this._fsfsRadio, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 5, 6, 5), 0, 0));
        this.add((Component)this._bdbRadio, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 0), 0, 0));
        this.add((Component)this._connNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 5), 0, 0));
        this.add((Component)this._connNameField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(6, 0, 0, 5), 100, 0));
    }

    private void listen() {
        this._pathBrowseButton.addActionListener(this);
    }

    private void chooseRepositoryPath() {
        URLChooser chooser = this.getRepositoryPath() != null ? DialogUtil.newURLChooser((URL)this.getRepositoryPath()) : DialogUtil.newURLChooser();
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(1);
        if (chooser.showOpenDialog((Component)this) == 0) {
            this._pathField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
        }
    }
}

