/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class ExportFromReposPanel
extends JPanel {
    private final ResourcePicker _res;
    private final Collection _listeners;
    private JLabel _reposPathLabel;
    private JLabel _reposPath;
    private JLabel _destLabel;
    private FileField _fileField;
    private JButton _browseButton;
    private JCheckBox _revCheckBox;
    private JTextField _revField;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this._listeners = new LinkedList();
    }

    public ExportFromReposPanel(SVNUrl reposPath) {
        super(new GridBagLayout());
        this.$init$();
        this.createComponents(reposPath);
        this.layoutComponents();
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportPathListener(ExportPathListener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    public URL getExportPath() {
        String path = this._fileField.getText();
        return path != null && path.length() > 0 ? URLFactory.newDirURL((String)path) : null;
    }

    public SVNRevision getRevision() {
        String revStr;
        if (this._revCheckBox.isSelected() && (revStr = this._revField.getText()) != null && revStr.length() > 0) {
            try {
                SVNRevision sVNRevision = SVNRevision.getRevision((String)revStr);
                return sVNRevision;
            }
            catch (ParseException pe) {
                SVNRevision.Number number = SVNRevision.INVALID_REVISION;
                return number;
            }
        }
        return SVNRevision.HEAD;
    }

    private void createComponents(SVNUrl reposUrl) {
        this._reposPath = new JLabel();
        this._reposPath.setText(reposUrl.toString());
        this._reposPathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._reposPathLabel, (Component)this._reposPath, (String)this._res.getString("UI_EXP_REPOSPATH"));
        this._fileField = new FileField(true);
        this._fileField.setText("");
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._fileField, (String)this._res.getString("UI_EXP_DEST"));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)this._res.getString("UI_EXP_BROWSE"));
        this._revField = new JTextField();
        this._revField.setText("");
        this._revField.setEnabled(false);
        this._revCheckBox = new JCheckBox();
        this._revCheckBox.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this._revCheckBox, (String)this._res.getString("UI_EXP_REV"));
    }

    private void layoutComponents() {
        this.add((Component)this._reposPathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._reposPath, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 2, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._destLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this._fileField, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.add((Component)this._revCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(16, 5, 5, 0), 0, 0));
        this.add((Component)this._revField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(16, 6, 5, 0), 0, 0));
    }

    private void initListeners() {
        this._revCheckBox.addActionListener(new 1());
        this._browseButton.addActionListener(new 2());
        this._fileField.getDocument().addDocumentListener(new 3());
    }

    static JCheckBox ra$_revCheckBox(ExportFromReposPanel exportFromReposPanel) {
        return exportFromReposPanel._revCheckBox;
    }

    static JTextField ra$_revField(ExportFromReposPanel exportFromReposPanel) {
        return exportFromReposPanel._revField;
    }

    static JButton ra$_browseButton(ExportFromReposPanel exportFromReposPanel) {
        return exportFromReposPanel._browseButton;
    }

    static FileField ra$_fileField(ExportFromReposPanel exportFromReposPanel) {
        return exportFromReposPanel._fileField;
    }

    static Collection ra$_listeners(ExportFromReposPanel exportFromReposPanel) {
        return exportFromReposPanel._listeners;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() == ExportFromReposPanel.ra$_revCheckBox(ExportFromReposPanel.this)) {
                ExportFromReposPanel.ra$_revField(ExportFromReposPanel.this).setEnabled(ExportFromReposPanel.ra$_revCheckBox(ExportFromReposPanel.this).isSelected());
            }
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() == ExportFromReposPanel.ra$_browseButton(ExportFromReposPanel.this)) {
                URL current = null;
                String currentStr = ExportFromReposPanel.ra$_fileField(ExportFromReposPanel.this).getText();
                current = currentStr != null && currentStr.length() > 0 ? URLFactory.newDirURL((String)currentStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
                URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                chooser.setSelectionMode(0);
                chooser.setSelectionScope(1);
                if (chooser.showOpenDialog((Component)ExportFromReposPanel.this) == 0) {
                    ExportFromReposPanel.ra$_fileField(ExportFromReposPanel.this).setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                }
            }
        }
    }

    final class 3
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.firePathSelected();
        }

        public void insertUpdate(DocumentEvent e) {
            this.firePathSelected();
        }

        public void removeUpdate(DocumentEvent e) {
            this.firePathSelected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePathSelected() {
            String path = ExportFromReposPanel.ra$_fileField(ExportFromReposPanel.this).getText();
            Collection collection = ExportFromReposPanel.ra$_listeners(ExportFromReposPanel.this);
            synchronized (collection) {
                Iterator it = ExportFromReposPanel.ra$_listeners(ExportFromReposPanel.this).iterator();
                while (it.hasNext()) {
                    ((ExportPathListener)it.next()).exportPathSelected(path);
                }
            }
        }
    }
}

