/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;

public final class ExportFromWCPanel
extends JPanel {
    private final ResourcePicker _res;
    private final Collection _listeners;
    private JLabel _wcPathLabel;
    private JLabel _wcPath;
    private JLabel _destLabel;
    private FileField _fileField;
    private JButton _browseButton;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this._listeners = new LinkedList();
    }

    public ExportFromWCPanel(URL sourcePath) {
        super(new GridBagLayout());
        this.$init$();
        this.createComponents(sourcePath);
        this.layoutComponents();
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportPathListener(ExportPathListener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    public URL getExportPath() {
        String path = this._fileField.getText();
        return path != null && path.length() > 0 ? URLFactory.newDirURL((String)path) : null;
    }

    private void createComponents(URL sourcePath) {
        this._wcPath = new JLabel();
        this._wcPath.setText(URLFileSystem.getPlatformPathName((URL)sourcePath));
        this._wcPathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._wcPathLabel, (Component)this._wcPath, (String)this._res.getString("UI_EXP_WCPATH"));
        this._fileField = new FileField(true);
        this._fileField.setText("");
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._fileField, (String)this._res.getString("UI_EXP_DEST"));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)this._res.getString("UI_EXP_BROWSE"));
    }

    private void layoutComponents() {
        this.add((Component)this._wcPathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._wcPath, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._destLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this._fileField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(6, 5, 5, 0), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 5, 0), 0, 0));
    }

    private void initListeners() {
        this._browseButton.addActionListener(new 1());
        this._fileField.getDocument().addDocumentListener(new 2());
    }

    static JButton ra$_browseButton(ExportFromWCPanel exportFromWCPanel) {
        return exportFromWCPanel._browseButton;
    }

    static FileField ra$_fileField(ExportFromWCPanel exportFromWCPanel) {
        return exportFromWCPanel._fileField;
    }

    static Collection ra$_listeners(ExportFromWCPanel exportFromWCPanel) {
        return exportFromWCPanel._listeners;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() == ExportFromWCPanel.ra$_browseButton(ExportFromWCPanel.this)) {
                URL current = null;
                String currentStr = ExportFromWCPanel.ra$_fileField(ExportFromWCPanel.this).getText();
                current = currentStr != null && currentStr.length() > 0 ? URLFactory.newDirURL((String)currentStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
                URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                chooser.setSelectionMode(0);
                chooser.setSelectionScope(1);
                if (chooser.showOpenDialog((Component)ExportFromWCPanel.this) == 0) {
                    ExportFromWCPanel.ra$_fileField(ExportFromWCPanel.this).setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                }
            }
        }
    }

    final class 2
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.firePathSelected();
        }

        public void insertUpdate(DocumentEvent e) {
            this.firePathSelected();
        }

        public void removeUpdate(DocumentEvent e) {
            this.firePathSelected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void firePathSelected() {
            String path = ExportFromWCPanel.ra$_fileField(ExportFromWCPanel.this).getText();
            Collection collection = ExportFromWCPanel.ra$_listeners(ExportFromWCPanel.this);
            synchronized (collection) {
                Iterator it = ExportFromWCPanel.ra$_listeners(ExportFromWCPanel.this).iterator();
                while (it.hasNext()) {
                    ((ExportPathListener)it.next()).exportPathSelected(path);
                }
            }
        }
    }
}

