/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.BasicCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.util.SVNReposInfoComboBoxRenderer;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryTreeNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class FullCheckoutPanel
extends JPanel
implements CheckoutInfo,
ActionListener,
TreeSelectionListener {
    private final ISVNClientAdapter _client;
    private final Map _rootNodes;
    private DefaultMutableTreeNode _treeVirtualRoot;
    private JLabel _reposLabel;
    private JComboBox _reposList;
    private JLabel _treeLabel;
    private JTree _tree;
    private JScrollPane _treeScroller;
    private BasicCheckoutPanel _basicPanel;
    private URL _baseUrl;

    private void $init$() {
        this._rootNodes = new HashMap(20);
    }

    public FullCheckoutPanel(Collection reposInfos, URL checkoutBase, ISVNClientAdapter client) {
        super(new GridBagLayout());
        this.$init$();
        this._client = client;
        this._baseUrl = checkoutBase;
        this.createComponents(reposInfos);
        this.layoutComponents();
        this.initListeners();
    }

    public SVNRepositoryInfo getRepositoryInfo() {
        return (SVNRepositoryInfo)this._reposList.getSelectedItem();
    }

    public SVNUrl getSourceURL() {
        SVNRepositoryTreeNode selectedNode = (SVNRepositoryTreeNode)this._tree.getSelectionPath().getLastPathComponent();
        SVNUrl selectedUrl = selectedNode.getURL();
        SVNUrl reposUrl = this.getRepositoryInfo().getURL();
        if (SVNUrlUtils.getCommonRootUrl((SVNUrl)reposUrl, (SVNUrl)selectedUrl) == null) {
            throw new IllegalStateException(reposUrl.toString() + ", " + selectedUrl.toString());
        }
        return selectedUrl;
    }

    public URL getDestinationURL() {
        return this._basicPanel.getDestinationURL();
    }

    public SVNRevision getRevision() {
        return this._basicPanel.getRevision();
    }

    public boolean getRecursive() {
        return this._basicPanel.getRecursive();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._reposList) {
            SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
            this._treeVirtualRoot.remove(0);
            this._treeVirtualRoot.add(this.getRootNode(repos));
            ((DefaultTreeModel)this._tree.getModel()).reload(this._treeVirtualRoot);
            this._basicPanel.setDestinationURL(this._baseUrl);
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        boolean isRoot;
        SVNUrl source;
        SVNRepositoryTreeNode selectedNode = (SVNRepositoryTreeNode)this._tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        URL suggested = SVNUtil.suggestCheckoutDestination(this._baseUrl, source, isRoot, (isRoot = (source = selectedNode.getURL()).equals((Object)selectedNode.getParentRepository().getURL())) ? selectedNode.getParentRepository().getAlias() : null);
        this._basicPanel.setDestinationURL(suggested);
    }

    private void createComponents(Collection reposInfos) {
        ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
        this._reposList = new JComboBox<SVNRepositoryInfo>(reposInfos.toArray(new SVNRepositoryInfo[reposInfos.size()]));
        this._reposList.setRenderer(new SVNReposInfoComboBoxRenderer());
        this._reposList.setSelectedIndex(0);
        this._reposLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._reposLabel, (Component)this._reposList, (String)res.getString("UI_FULL_CHECKOUT_PANEL_LABEL_REPOS"));
        this._treeVirtualRoot = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(this._treeVirtualRoot);
        this._tree = new JTree(model);
        this._tree.setVisibleRowCount(10);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._treeVirtualRoot.add(this.getRootNode((SVNRepositoryInfo)this._reposList.getSelectedItem()));
        model.reload(this._treeVirtualRoot);
        this._tree.addTreeSelectionListener(this);
        this._treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._tree, (String)res.getString("UI_FULL_CHECKOUT_PANEL_LABEL_TREE"));
        this._treeScroller = new JScrollPane(this._tree);
        this._basicPanel = new BasicCheckoutPanel(null, null, this._baseUrl);
    }

    private void layoutComponents() {
        this.add((Component)this._reposLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this._reposList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 90, 0));
        this.add((Component)this._treeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add((Component)this._treeScroller, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._basicPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 16, 1, new Insets(5, 0, 2, 0), 0, 0));
    }

    private void initListeners() {
        this._reposList.addActionListener(this);
        this._basicPanel.addBCPListener(new 1());
    }

    private SVNRepositoryTreeNode getRootNode(SVNRepositoryInfo reposInfo) {
        String key = reposInfo.getURL().toString();
        SVNRepositoryTreeNode node = (SVNRepositoryTreeNode)this._rootNodes.get(key);
        if (node == null) {
            node = new SVNRepositoryTreeNode(reposInfo, SVNNodeKind.DIR, reposInfo.getURL(), "/", 0, this._client);
            this._rootNodes.put(key, node);
        }
        return node;
    }

    static void wa$_baseUrl(FullCheckoutPanel fullCheckoutPanel, URL uRL) {
        fullCheckoutPanel._baseUrl = uRL;
    }

    final class 1
    implements BasicCheckoutPanel.Listener {
        public void newURLChosen(URL newUrl) {
            FullCheckoutPanel.wa$_baseUrl(FullCheckoutPanel.this, newUrl);
        }
    }
}

