/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.Context;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowser;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.util.SVNLogMessagesRetriever;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergePanel
extends MonitoredPanel
implements ActionListener {
    private final ResourcePicker _res;
    private JLabel _fromLabel;
    private FileField _fromField;
    private JButton _fromBrowseButton;
    private ButtonGroup _fromRevisionGroup;
    private JRadioButton _fromHeadRadio;
    private JRadioButton _fromRevisionRadio;
    private NumberTextField _fromRevisionField;
    private JButton _fromRevisionButton;
    private JLabel _toLabel;
    private FileField _toField;
    private JButton _toBrowseButton;
    private ButtonGroup _toRevisionGroup;
    private JRadioButton _toHeadRadio;
    private JRadioButton _toRevisionRadio;
    private NumberTextField _toRevisionField;
    private JButton _toRevisionButton;
    private JCheckBox _sameURLBox;
    private JLabel _applyWCLabel;
    private FileField _applyWCField;
    private JButton _applyWCBrowseButton;
    private JCheckBox _noAncestryBox;
    private JCheckBox _forceBox;
    private JButton _testButton;
    private JLabel _statusLabel;
    private JTextArea _statusArea;
    private JScrollPane _scrollPane;
    private SVNUrl _fromSVNUrl;
    private SVNUrl _toSVNUrl;
    private Context _context;
    private SVNRevision _revisionStart;
    private SVNRevision _revisionEnd;
    private SVNRepositoryInfo _repoInfo;
    public static final String FROM_HEAD_RADIO_STATUS = "FROM_HEAD_RADIO_STATUS";
    public static final String FROM_REVISION_RADIO_STATUS = "FROM_REVISION_RADIO_STATUSC";
    public static final String FROM_REVISION = "FROM_REVISION";
    public static final String TO_FIELD = "TO_FIELD";
    public static final String TO_HEAD_RADIO_STATUS = "TO_HEAD_RADIO_STATUS";
    public static final String TO_REVISION_RADIO_STATUS = "TO_REVISION_RADIO_STATUS";
    public static final String TO_REVISION = "TO_REVISION";
    public static final String IGNORE_ANCESTRY_BOX_STATUS = "IGNORE_ANCESTRY_BOX_STATUS";
    public static final String FORCE_BOX_STATUS = "FORCE_BOX_STATUS";
    public static final String DRYRUN_BOX_STATUS = "DRYRUN_BOX_STATUS";
    public static final String SAME_URL_BOX_STATUS = "SAME_URL_BOX_STATUS";

    private void $init$() {
        this._revisionStart = new SVNRevision.Number(0L);
        this._revisionEnd = SVNRevision.HEAD;
    }

    public MergePanel() {
        super(new GridBagLayout());
        this.$init$();
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    private void createComponents() {
        this._fromLabel = new JLabel();
        this._fromField = new FileField();
        ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromField, (String)this._res.getString("UI_MERGE_PANEL_LABEL_FROM"));
        this._fromField.setEditable(true);
        this._fromBrowseButton = new JButton();
        this._fromBrowseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._fromBrowseButton, (String)this._res.getString("UI_MERGE_PANEL_BUTTON_FROM_BROWSE"));
        this._fromRevisionGroup = new ButtonGroup();
        this._fromHeadRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._fromHeadRadio, (String)this._res.getString("UI_MERGE_PANEL_RADIO_FROM_HEAD"));
        this._fromHeadRadio.setSelected(true);
        this._fromHeadRadio.addActionListener(this);
        this._fromRevisionGroup.add(this._fromHeadRadio);
        this._fromRevisionRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._fromRevisionRadio, (String)this._res.getString("UI_MERGE_PANEL_RADIO_FROM_REVISION"));
        this._fromRevisionRadio.addActionListener(this);
        this._fromRevisionGroup.add(this._fromRevisionRadio);
        this._fromRevisionField = new NumberTextField();
        this._fromRevisionField.setColumns(8);
        this._fromRevisionField.setDecimal(false);
        this._fromRevisionField.setDataType(Integer.class);
        this._fromRevisionField.setSigned(false);
        this._fromRevisionField.setEnabled(this._fromRevisionRadio.isSelected());
        this._fromRevisionButton = new JButton();
        this._fromRevisionButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._fromRevisionButton, (String)this._res.getString("UI_MERGE_PANEL_BUTTON_FROM_REVISION"));
        this._fromRevisionButton.setEnabled(this._fromRevisionRadio.isSelected());
        this._toLabel = new JLabel();
        this._toField = new FileField();
        ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toField, (String)this._res.getString("UI_MERGE_PANEL_LABEL_TO"));
        this._toField.setEditable(false);
        this._sameURLBox = new JCheckBox();
        this._sameURLBox.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._sameURLBox, (String)this._res.getString("UI_MERGE_PANEL_BOX_SAMEURL"));
        this._sameURLBox.setSelected(true);
        this._toBrowseButton = new JButton();
        this._toBrowseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._toBrowseButton, (String)this._res.getString("UI_MERGE_PANEL_BUTTON_TO_BROWSE"));
        this._toBrowseButton.setEnabled(false);
        this._toRevisionGroup = new ButtonGroup();
        this._toHeadRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._toHeadRadio, (String)this._res.getString("UI_MERGE_PANEL_RADIO_TO_HEAD"));
        this._toHeadRadio.setSelected(true);
        this._toHeadRadio.addActionListener(this);
        this._toRevisionGroup.add(this._toHeadRadio);
        this._toRevisionRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._toRevisionRadio, (String)this._res.getString("UI_MERGE_PANEL_RADIO_TO_REVISION"));
        this._toRevisionRadio.addActionListener(this);
        this._toRevisionGroup.add(this._toRevisionRadio);
        this._toRevisionField = new NumberTextField();
        this._toRevisionField.setColumns(8);
        this._toRevisionField.setDecimal(false);
        this._toRevisionField.setDataType(Integer.class);
        this._toRevisionField.setSigned(false);
        this._toRevisionField.setEnabled(this._toRevisionRadio.isSelected());
        this._toRevisionButton = new JButton();
        this._toRevisionButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._toRevisionButton, (String)this._res.getString("UI_MERGE_PANEL_BUTTON_TO_REVISION"));
        this._toRevisionButton.setEnabled(this._toRevisionRadio.isSelected());
        this._applyWCLabel = new JLabel();
        this._applyWCField = new FileField();
        ResourceUtils.resLabel((JLabel)this._applyWCLabel, (Component)this._applyWCField, (String)this._res.getString("UI_MERGE_PANEL_LABEL_APPLYWC"));
        this._applyWCField.setEditable(true);
        this._applyWCBrowseButton = new JButton();
        this._applyWCBrowseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._applyWCBrowseButton, (String)this._res.getString("UI_MERGE_PANEL_BUTTON_APPLYWC"));
        this._noAncestryBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._noAncestryBox, (String)this._res.getString("UI_MERGE_PANEL_BOX_NOANCESTRY"));
        this._toRevisionButton.setEnabled(this._toRevisionRadio.isSelected());
        this._forceBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._forceBox, (String)this._res.getString("UI_MERGE_PANEL_BOX_FORCE"));
        this._testButton = new JButton();
        this._testButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._testButton, (String)this._res.getString("UI_MERGE_PANEL_BUTTON_TEST"));
        this._statusLabel = new JLabel();
        this._statusArea = new JTextArea();
        this._statusArea.setEditable(false);
        this._statusArea.setRows(3);
        this._statusArea.setLineWrap(true);
        this._statusArea.setText("");
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusArea, (String)this._res.getString("UI_MERGE_PANEL_LABEL_STATUS"));
        this._scrollPane = new JScrollPane(this._statusArea);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        Insets insetsRadio = new Insets(6, 18, 2, 6);
        Insets insetsFields = new Insets(6, 2, 2, 85);
        Insets insetsBetweenSections = new Insets(15, 2, 2, 6);
        this.add((Component)this._fromLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._fromField, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, insetsFields, 0, 0));
        this.add((Component)this._fromBrowseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._fromHeadRadio, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._fromRevisionRadio, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._fromRevisionField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._fromRevisionButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._toLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, insetsBetweenSections, 0, 0));
        this.add((Component)this._sameURLBox, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._toField, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 17, 2, insetsFields, 0, 0));
        this.add((Component)this._toBrowseButton, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._toHeadRadio, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._toRevisionRadio, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._toRevisionField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._toRevisionButton, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._applyWCLabel, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 0, insetsBetweenSections, 0, 0));
        this.add((Component)this._applyWCField, new GridBagConstraints(0, 10, 3, 1, 1.0, 0.0, 17, 2, insetsFields, 0, 0));
        this.add((Component)this._applyWCBrowseButton, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._noAncestryBox, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._forceBox, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._testButton, new GridBagConstraints(0, 12, 3, 1, 0.0, 0.0, 17, 0, insetsBetweenSections, 0, 0));
        this.add((Component)this._statusLabel, new GridBagConstraints(0, 13, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 14, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this._fromRevisionButton)) {
            SVNLogMessagesRetriever logRetriever = new SVNLogMessagesRetriever(this.getFromUrl(), this._revisionStart, this._revisionEnd);
            ISVNLogMessage[] _logMessages = logRetriever.getLogMessages(this);
            SVNRevisionLister revLister = new SVNRevisionLister(_logMessages);
            revLister.addObserver(new 1());
            revLister.showLister();
            return;
        }
        if (e.getSource().equals(this._toRevisionButton)) {
            SVNLogMessagesRetriever logRetriever = new SVNLogMessagesRetriever(this.getToUrl(), this._revisionStart, this._revisionEnd);
            ISVNLogMessage[] _logMessages = logRetriever.getLogMessages(this);
            SVNRevisionLister revLister = new SVNRevisionLister(_logMessages);
            revLister.addObserver(new 2());
            revLister.showLister();
            return;
        }
        if (e.getSource().equals(this._fromBrowseButton)) {
            SVNRepositoryBrowser repoBrowser = this.createRepositoryBrowser(this.getFromUrl());
            repoBrowser.addObserver(new 3());
            repoBrowser.showBrowser();
            return;
        }
        if (e.getSource().equals(this._toBrowseButton)) {
            SVNRepositoryBrowser repoBrowser = this.createRepositoryBrowser(this.getToUrl());
            repoBrowser.addObserver(new 4());
            repoBrowser.showBrowser();
            return;
        }
        if (e.getSource().equals(this._sameURLBox)) {
            if (this._sameURLBox.isSelected()) {
                this._toField.setText(this._fromField.getText());
                this._toField.setEditable(false);
                this._toBrowseButton.setEnabled(false);
                return;
            }
            this._toField.setEditable(true);
            this._toBrowseButton.setEnabled(true);
            return;
        }
        if (e.getSource().equals(this._applyWCBrowseButton)) {
            this.chooseAppyWCPath();
            return;
        }
        boolean validContent = this.validateContent();
        this.fireValidContent(validContent);
        if (this._fromRevisionRadio.isSelected()) {
            this._fromRevisionField.setEnabled(true);
            this._fromRevisionButton.setEnabled(true);
        } else {
            this._fromRevisionField.setEnabled(false);
            this._fromRevisionButton.setEnabled(false);
        }
        if (this._toRevisionRadio.isSelected()) {
            this._toRevisionField.setEnabled(true);
            this._toRevisionButton.setEnabled(true);
        } else {
            this._toRevisionField.setEnabled(false);
            this._toRevisionButton.setEnabled(false);
        }
    }

    public void setTestButtonEnabled(Boolean enabled) {
        this._testButton.setEnabled(enabled);
    }

    private SVNRevision getFieldRevision(NumberTextField field) {
        if (field.getNumber() == null) {
            return null;
        }
        return new SVNRevision.Number(field.getNumber().longValue());
    }

    private void setFromRevisionField(SVNRevision rev) {
        this._fromRevisionField.setText(rev.toString());
    }

    private void setToRevisionField(SVNRevision rev) {
        this._toRevisionField.setText(rev.toString());
    }

    public boolean getNoAncestryStatus() {
        return this._noAncestryBox.isSelected();
    }

    public boolean getForceStatus() {
        return this._forceBox.isSelected();
    }

    public void setFromField(String urlString) {
        if (urlString != null) {
            this._fromField.setText(urlString);
        }
    }

    public void setToField(String urlString) {
        if (urlString != null) {
            this._toField.setText(urlString);
        }
    }

    public void setApplyWCField(String urlString) {
        if (urlString != null) {
            this._applyWCField.setText(urlString);
        }
    }

    public String getToField() {
        return this._toField.getText();
    }

    public String getFromField() {
        return this._fromField.getText();
    }

    public String getApplyWCField() {
        return this._applyWCField.getText();
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    public SVNUrl getFromUrl() {
        try {
            this._fromSVNUrl = new SVNUrl(this._fromField.getText());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this._fromSVNUrl;
    }

    public SVNUrl getToUrl() {
        try {
            this._toSVNUrl = new SVNUrl(this._toField.getText());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this._toSVNUrl;
    }

    public File getApplyWCFile() {
        return new File(this.getApplyWCField());
    }

    public SVNRevision getFromRevision() {
        return this._fromHeadRadio.isSelected() ? SVNRevision.HEAD : this.getFieldRevision(this._fromRevisionField);
    }

    public SVNRevision getToRevision() {
        return this._toHeadRadio.isSelected() ? SVNRevision.HEAD : this.getFieldRevision(this._toRevisionField);
    }

    private SVNRepositoryBrowser createRepositoryBrowser(SVNUrl url) {
        boolean repoCreated = true;
        this._repoInfo = SVNUtil.resolveRepository(url);
        if (this._repoInfo == null && (repoCreated = this.createTheRepository())) {
            this._repoInfo = SVNUtil.resolveRepository(url);
        }
        return new SVNRepositoryBrowser(this._repoInfo, url);
    }

    private boolean createTheRepository() {
        Wizard reposWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
        Context ctx = this.getContext();
        boolean success = false;
        ctx.setProperty(SVNRepositoryWizard.PROPERTY_NAME_EDITING, (Object)Boolean.FALSE);
        ctx.setProperty("PRESET_REPO_URL", (Object)this._repoInfo.getURL().toString());
        if (reposWizard != null && reposWizard.isAvailable(ctx)) {
            success = reposWizard.invoke(ctx);
        }
        return success;
    }

    void initListeners() {
        this._fromField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
        this._toField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
        this._fromRevisionField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
        this._toRevisionField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
        this._applyWCField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener(this));
        this._testButton.addActionListener(new MergeTester(null));
    }

    boolean validateRevision() {
        return (!this._fromRevisionRadio.isSelected() || this.getFromRevision() != null) && (!this._toRevisionRadio.isSelected() || this.getToRevision() != null);
    }

    boolean validateURL() {
        this._protocolMatcher.setSource(this.getToField());
        if (this._protocolMatcher.containsProtocol()) {
            this._protocolMatcher.setSource(this.getFromField());
            if (this._protocolMatcher.containsProtocol() && this.getApplyWCField() != null) {
                return true;
            }
        }
        return false;
    }

    private void chooseAppyWCPath() {
        URLChooser chooser = this.getWCPath() != null ? DialogUtil.newURLChooser((URL)this.getWCPath()) : DialogUtil.newURLChooser();
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(2);
        if (chooser.showOpenDialog((Component)this) == 0) {
            this.setApplyWCField(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
        }
    }

    public URL getWCPath() {
        String path = this.getApplyWCField();
        String string = path = path != null ? path.trim() : null;
        if (path != null && !path.equals("")) {
            return URLFileSystem.getParent((URL)URLFactory.newDirURL((String)path));
        }
        return null;
    }

    static JTextArea ra$_statusArea(MergePanel mergePanel) {
        return mergePanel._statusArea;
    }

    static JButton ra$_testButton(MergePanel mergePanel) {
        return mergePanel._testButton;
    }

    static void mav$setFromRevisionField(MergePanel mergePanel, SVNRevision sVNRevision) {
        mergePanel.setFromRevisionField(sVNRevision);
    }

    static void mav$setToRevisionField(MergePanel mergePanel, SVNRevision sVNRevision) {
        mergePanel.setToRevisionField(sVNRevision);
    }

    static JCheckBox ra$_sameURLBox(MergePanel mergePanel) {
        return mergePanel._sameURLBox;
    }

    final class 1
    implements Observer {
        public void update(Observable o, Object arg) {
            MergePanel.mav$setFromRevisionField(MergePanel.this, (SVNRevision)arg);
        }
    }

    final class 2
    implements Observer {
        public void update(Observable o, Object arg) {
            MergePanel.mav$setToRevisionField(MergePanel.this, (SVNRevision)arg);
        }
    }

    final class 3
    implements Observer {
        public void update(Observable o, Object arg) {
            MergePanel.this.setFromField(((SVNUrl)arg).toString());
            if (MergePanel.ra$_sameURLBox(MergePanel.this).isSelected()) {
                MergePanel.this.setToField(((SVNUrl)arg).toString());
            }
        }
    }

    final class 4
    implements Observer {
        public void update(Observable o, Object arg) {
            MergePanel.this.setToField(((SVNUrl)arg).toString());
        }
    }

    private final class MergeTester
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            MergePanel.ra$_statusArea(MergePanel.this).setText("");
            MergeTesterThread t = new MergeTesterThread(null);
            MergePanel.ra$_testButton(MergePanel.this).setEnabled(false);
            t.start();
        }

        private MergeTester() {
        }

        MergeTester(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class MergeTesterThread
    extends Thread {
        SVNUrl fromUrl;
        SVNUrl toUrl;
        SVNRevision fromRevision;
        SVNRevision toRevision;
        File destFile;
        boolean isNoAncestry;
        boolean isForce;
        boolean isDryRun;
        boolean isRecurse;

        private void $init$() {
            this.isRecurse = true;
        }

        public void run() {
            ISVNClientAdapter client = null;
            TextAreaNotificationListener tanListener = new TextAreaNotificationListener(null);
            WaitCursor wc = new WaitCursor((Component)MergePanel.this);
            EventQueue.invokeLater(new 1(this, wc));
            try {
                try {
                    this.getParameters();
                    client = SVNUtil.getIDEClientAdapter();
                    client.addNotifyListener((ISVNNotifyListener)tanListener);
                    client.merge(this.fromUrl, this.fromRevision, this.toUrl, this.toRevision, this.destFile, this.isForce, this.isRecurse, this.isDryRun);
                }
                catch (SVNClientException e) {
                    MergePanel.ra$_statusArea(MergePanel.this).append(e.getMessage());
                }
                catch (IOException e) {
                    MergePanel.ra$_statusArea(MergePanel.this).append(e.getMessage());
                }
            }
            finally {
                MergePanel.ra$_testButton(MergePanel.this).setEnabled(true);
                EventQueue.invokeLater(new 2(this, wc));
                if (client != null) {
                    client.removeNotifyListener((ISVNNotifyListener)tanListener);
                }
            }
        }

        private void getParameters() throws IOException {
            this.fromUrl = MergePanel.this.getFromUrl();
            this.fromRevision = MergePanel.this.getFromRevision();
            this.toUrl = MergePanel.this.getToUrl();
            this.toRevision = MergePanel.this.getToRevision();
            this.destFile = MergePanel.this.getApplyWCFile();
            if (!this.destFile.exists()) {
                throw new IOException();
            }
            this.isNoAncestry = MergePanel.this.getNoAncestryStatus();
            this.isForce = MergePanel.this.getForceStatus();
            this.isDryRun = true;
        }

        private MergeTesterThread() {
            this.$init$();
        }

        MergeTesterThread(2 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ MergeTesterThread this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(MergeTesterThread mergeTesterThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = mergeTesterThread;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ MergeTesterThread this$0;

            public void run() {
                this.v$wc.hide();
            }

            public 2(MergeTesterThread mergeTesterThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = mergeTesterThread;
            }
        }
    }

    private final class TextAreaNotificationListener
    implements ISVNNotifyListener {
        public void setCommand(int command) {
        }

        public void logCommandLine(String commandLine) {
            this.appendLater(commandLine);
        }

        public void logMessage(String message) {
            this.appendLater(message);
        }

        public void logError(String message) {
            this.appendLater(message);
        }

        public void logRevision(long revision) {
        }

        public void logCompleted(String message) {
            this.appendLater(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
        }

        public void logRevision(long revision, String path) {
        }

        private void appendLater(String message) {
            MergePanel.ra$_statusArea(MergePanel.this).append(message);
            MergePanel.ra$_statusArea(MergePanel.this).append("\n");
        }

        private TextAreaNotificationListener() {
        }

        TextAreaNotificationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

