/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.jdevimpl.vcs.svn.util.ProtocolMatcher;

public abstract class MonitoredPanel
extends JPanel {
    ProtocolMatcher _protocolMatcher;
    Collection _listeners;

    private void $init$() {
        this._listeners = new ArrayList(5);
    }

    public MonitoredPanel(LayoutManager layout) {
        super(layout);
        this.$init$();
        this._protocolMatcher = new ProtocolMatcher();
    }

    abstract void initListeners();

    public void addListener(PanelListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(PanelListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireValidContent(boolean validContent) {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((PanelListener)it.next()).setContainsURL(validContent);
            }
        }
    }

    public boolean validateContent() {
        return this.validateRevision() && this.validateURL();
    }

    public Component getInitialFocus() {
        return null;
    }

    abstract boolean validateRevision();

    abstract boolean validateURL();

    class FieldListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            this.validatePanelContent();
        }

        public void removeUpdate(DocumentEvent e) {
            this.validatePanelContent();
        }

        public void changedUpdate(DocumentEvent e) {
            this.validatePanelContent();
        }

        private void validatePanelContent() {
            boolean validContent = MonitoredPanel.this.validateContent();
            MonitoredPanel.this.fireValidContent(validContent);
        }

        FieldListener() {
        }
    }

    public static interface PanelListener {
        public void setContainsURL(boolean var1);
    }
}

