/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class NewRemoteDirPanel
extends JPanel {
    private final ResourcePicker _res;
    private final Collection _listeners;
    private final SVNUrl _parent;
    private JLabel _parentPathLabel;
    private JLabel _parentPath;
    private JLabel _dirNameLabel;
    private JTextField _dirNameField;
    private VCSCommentsCustomizer _commentsUI;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this._listeners = new LinkedList();
    }

    public NewRemoteDirPanel(SVNUrl parent) {
        super(new GridBagLayout());
        this.$init$();
        this._parent = parent;
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    public void addDirectoryNameListener(Listener listener) {
        this._listeners.add(listener);
    }

    public Component getInitialFocus() {
        return this._dirNameField;
    }

    public String getDirectoryName() {
        return this._dirNameField.getText();
    }

    public String getComments() {
        return (String)this._commentsUI.getOptions().get("setting_comments");
    }

    private void createComponents() {
        this._parentPath = new JLabel();
        this._parentPath.setText(this._parent.toString());
        this._parentPathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._parentPathLabel, (Component)this._parentPath, (String)this._res.getString("UI_CREATE_REMOTE_DIR_PARENT_PATH"));
        this._dirNameField = new JTextField();
        this._dirNameField.setText("");
        this._dirNameLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._dirNameLabel, (Component)this._dirNameField, (String)this._res.getString("UI_CREATE_REMOTE_DIR_DIR_NAME"));
        this._commentsUI = new VCSCommentsCustomizer();
        this._commentsUI.setShowReuseCommentsOption(false);
        this._commentsUI.setSuppressContextMenu(true);
    }

    private void layoutComponents() {
        this.add((Component)this._parentPathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 6), 0, 0));
        this.add((Component)this._parentPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._dirNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 6), 0, 0));
        this.add((Component)this._dirNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this._commentsUI.getComponent(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        this._dirNameField.getDocument().addDocumentListener(new 1());
    }

    static Collection ra$_listeners(NewRemoteDirPanel newRemoteDirPanel) {
        return newRemoteDirPanel._listeners;
    }

    static JTextField ra$_dirNameField(NewRemoteDirPanel newRemoteDirPanel) {
        return newRemoteDirPanel._dirNameField;
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            this.notifyDirNameChanged(NewRemoteDirPanel.ra$_dirNameField(NewRemoteDirPanel.this).getText());
        }

        public void removeUpdate(DocumentEvent e) {
            this.notifyDirNameChanged(NewRemoteDirPanel.ra$_dirNameField(NewRemoteDirPanel.this).getText());
        }

        public void changedUpdate(DocumentEvent e) {
            this.notifyDirNameChanged(NewRemoteDirPanel.ra$_dirNameField(NewRemoteDirPanel.this).getText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyDirNameChanged(String newName) {
            Collection collection = NewRemoteDirPanel.ra$_listeners(NewRemoteDirPanel.this);
            synchronized (collection) {
                Iterator it = NewRemoteDirPanel.ra$_listeners(NewRemoteDirPanel.this).iterator();
                while (it.hasNext()) {
                    ((Listener)it.next()).directoryNameChanged(newName);
                }
            }
        }
    }

    public interface Listener {
        public void directoryNameChanged(String var1);
    }
}

