/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNRevisionListPanel
extends JPanel
implements ListSelectionListener {
    private final ResourcePicker _res;
    private RevisionModel _revTableModel;
    private RevisionTable _revisionTable;
    private JScrollPane _revScollPane;
    private JLabel _commentLabel;
    private JTextArea _commentArea;
    private JScrollPane _commentScollPane;
    private ISVNLogMessage[] _logs;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    public SVNRevisionListPanel(ISVNLogMessage[] logs) {
        super(new GridBagLayout());
        this.$init$();
        this._logs = logs;
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this._revTableModel = new RevisionModel(null);
        this.setPanelContent();
        this._revisionTable = new RevisionTable((TableModel)((Object)this._revTableModel));
        this._revisionTable.getTableHeader().setReorderingAllowed(false);
        this._revisionTable.setDefaultRenderer(String.class, (TableCellRenderer)new NiceTableCellRenderer());
        this._revisionTable.setAutoResizeMode(1);
        this._revisionTable.setSortColumn(0, false);
        this._revisionTable.setSelectionMode(0);
        this._revisionTable.getSelectionModel().addListSelectionListener(this);
        this._revScollPane = this._revisionTable.getScrollPaneForTable();
        this._revScollPane.setBorder(BorderFactory.createEtchedBorder());
        this._revScollPane.setPreferredSize(new Dimension(400, 200));
        this._commentLabel = new JLabel();
        this._commentArea = new JTextArea();
        ResourceUtils.resLabel((JLabel)this._commentLabel, (Component)this._commentArea, (String)this._res.getString("UI_REVISION_LIST_PANEL_LABEL_COMMENT"));
        this._commentArea.setEditable(false);
        this._commentArea.setBackground(Color.LIGHT_GRAY);
        this._commentArea.setRows(3);
        this._commentScollPane = new JScrollPane();
        this._commentScollPane.getViewport().add(this._commentArea);
    }

    private void layoutComponents() {
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)this._revScollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, insets, 0, 0));
        this.add((Component)this._commentLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._commentScollPane, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, insets, 0, 0));
    }

    public SVNRevision getSelectedRevision() {
        if (this._revisionTable.getSelectedRow() != -1) {
            return this._logs[this._revisionTable.getSelectedRowsInModel()[0]].getRevision();
        }
        return null;
    }

    private void setPanelContent() {
        String[] columnNames = new String[]{"Revision", "Date", "Author"};
        this._revTableModel.setColNames(columnNames);
        Object[][] data = new Object[][]{{"", "", ""}};
        if (this._logs != null) {
            data = new Object[this._logs.length][columnNames.length];
            int row = 0;
            while (row < this._logs.length) {
                data[row][0] = this._logs[row].getRevision().getNumber();
                data[row][1] = this._logs[row].getDate();
                data[row][2] = this._logs[row].getAuthor();
                ++row;
            }
        }
        this._revTableModel.setData(data);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this._revisionTable.getSelectedRow() != -1) {
            this._commentArea.setText(this._logs[this._revisionTable.getSelectedRowsInModel()[0]].getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RevisionModel
    implements NiceTableModel {
        private String[] _columnNames;
        private Object[][] _data;

        private void $init$() {
            this._columnNames = null;
            this._data = null;
        }

        public void setColNames(String[] columnNames) {
            this._columnNames = columnNames;
        }

        public void setData(Object[][] data) {
            this._data = data;
        }

        public int getColumnAlignment(int column) {
            return 0;
        }

        public Comparator getColumnSortComparator(int column) {
            return null;
        }

        public int getRowCount() {
            return this._data.length;
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public String getColumnName(int columnIndex) {
            return this._columnNames[columnIndex];
        }

        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this._data[rowIndex][columnIndex];
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        private RevisionModel() {
            this.$init$();
        }

        RevisionModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RevisionTable
    extends NiceTable {
        public RevisionTable(TableModel model) {
            super(model);
        }
    }
}

