/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowser;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.util.SVNLogMessagesRetriever;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchPanel
extends MonitoredPanel
implements ActionListener {
    private final ResourcePicker _res;
    private JLabel _fromLabel;
    private FileField _fromField;
    private JLabel _toLabel;
    private FileField _toField;
    private JButton _browseButton;
    private ButtonGroup _revisionGroup;
    private JRadioButton _headRadio;
    private JRadioButton _revisionRadio;
    private NumberTextField _revisionField;
    private JButton _revisionButton;
    private final SVNRevision _revisionStart;
    private final SVNRevision _revisionEnd;
    private Context _context;
    private SVNUrl _toSVNUrl;
    private SVNRepositoryInfo _repoInfo;

    private void $init$() {
        this._revisionStart = new SVNRevision.Number(0L);
        this._revisionEnd = SVNRevision.HEAD;
    }

    public SwitchPanel() {
        super(new GridBagLayout());
        this.$init$();
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
    }

    private void createComponents() {
        this._fromLabel = new JLabel();
        this._fromField = new FileField();
        ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromField, (String)this._res.getString("UI_SWITCH_PANEL_LABEL_FROM"));
        this._fromField.setEditable(false);
        this._toLabel = new JLabel();
        this._toField = new FileField();
        ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toField, (String)this._res.getString("UI_SWITCH_PANEL_LABEL_TO"));
        this._browseButton = new JButton();
        this._browseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)this._res.getString("UI_SWITCH_PANEL_BUTTON_BROWSE"));
        this._revisionGroup = new ButtonGroup();
        this._headRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._headRadio, (String)this._res.getString("UI_SWITCH_PANEL_RADIO_HEAD"));
        this._headRadio.addActionListener(this);
        this._headRadio.setSelected(true);
        this._revisionGroup.add(this._headRadio);
        this._revisionRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._revisionRadio, (String)this._res.getString("UI_SWITCH_PANEL_RADIO_REVISION"));
        this._revisionRadio.addActionListener(this);
        this._revisionGroup.add(this._revisionRadio);
        this._revisionField = new NumberTextField();
        this._revisionField.setColumns(8);
        this._revisionField.setDecimal(false);
        this._revisionField.setDataType(Integer.class);
        this._revisionField.setSigned(false);
        this._revisionField.setEnabled(this._revisionRadio.isSelected());
        this._revisionButton = new JButton();
        this._revisionButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._revisionButton, (String)this._res.getString("UI_SWITCH_PANEL_BUTTON_REVISION"));
        this._revisionButton.setEnabled(this._revisionRadio.isSelected());
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        Insets insetsRadio = new Insets(6, 18, 2, 6);
        this.add((Component)this._fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._fromField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._toLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._toField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(6, 2, 2, 80), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this._headRadio, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._revisionRadio, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 55, 2, 6), 0, 0));
        this.add((Component)this._revisionButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        if (this._revisionRadio.isSelected()) {
            this._revisionField.setEnabled(true);
            this._revisionButton.setEnabled(true);
        } else {
            this._revisionField.setEnabled(false);
            this._revisionButton.setEnabled(false);
        }
        boolean validContent = this.validateContent();
        this.fireValidContent(validContent);
        if (e.getSource().equals(this._revisionButton)) {
            SVNLogMessagesRetriever logRetriever = new SVNLogMessagesRetriever(this.getToUrl(), this._revisionStart, this._revisionEnd);
            ISVNLogMessage[] _logMessages = logRetriever.getLogMessages(this);
            SVNRevisionLister revLister = new SVNRevisionLister(_logMessages);
            revLister.addObserver(new 1());
            revLister.showLister();
            return;
        }
        if (e.getSource().equals(this._browseButton)) {
            SVNRepositoryBrowser repoBrowser = this.createRepositoryBrowser(this.getToUrl());
            repoBrowser.addObserver(new 2());
            repoBrowser.showBrowser();
        }
    }

    public SVNRevision getRevision() {
        return this._headRadio.isSelected() ? SVNRevision.HEAD : this.getFieldRevision(this._revisionField);
    }

    public void setRevisionField(SVNRevision svnRevision) {
        this._revisionField.setText(svnRevision.toString());
    }

    public SVNUrl getToUrl() {
        try {
            this._toSVNUrl = new SVNUrl(this._toField.getText());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this._toSVNUrl;
    }

    private SVNRevision getFieldRevision(NumberTextField field) {
        if (field.getNumber() == null) {
            return null;
        }
        return new SVNRevision.Number(field.getNumber().longValue());
    }

    public void setToField(String toUrlString) {
        this._toField.setText(toUrlString);
    }

    public void setFromField(String fromUrlString) {
        this._fromField.setText(fromUrlString);
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    public String getToField() {
        return this._toField.getText();
    }

    private SVNRepositoryBrowser createRepositoryBrowser(SVNUrl url) {
        boolean repoCreated = true;
        this._repoInfo = SVNUtil.resolveRepository(url);
        if (this._repoInfo == null && (repoCreated = this.createTheRepository())) {
            this._repoInfo = SVNUtil.resolveRepository(url);
        }
        return new SVNRepositoryBrowser(this._repoInfo, url);
    }

    private boolean createTheRepository() {
        Wizard reposWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
        Context ctx = this.getContext();
        boolean success = false;
        ctx.setProperty(SVNRepositoryWizard.PROPERTY_NAME_EDITING, (Object)Boolean.FALSE);
        ctx.setProperty("PRESET_REPO_URL", (Object)this._repoInfo.getURL().toString());
        if (reposWizard != null && reposWizard.isAvailable(ctx)) {
            success = reposWizard.invoke(ctx);
        }
        return success;
    }

    void initListeners() {
        this._toField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener());
        this._revisionField.getDocument().addDocumentListener(new MonitoredPanel.FieldListener());
    }

    boolean validateRevision() {
        return !this._revisionRadio.isSelected() || this.getRevision() != null;
    }

    boolean validateURL() {
        this._protocolMatcher.setSource(this.getToField());
        return this._protocolMatcher.containsProtocol();
    }

    final class 1
    implements Observer {
        public void update(Observable o, Object arg) {
            SwitchPanel.this.setRevisionField((SVNRevision)arg);
        }
    }

    final class 2
    implements Observer {
        public void update(Observable o, Object arg) {
            SwitchPanel.this.setToField(((SVNUrl)arg).toString());
        }
    }
}

