/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.ui.RecursiveOperationPanel;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public final class UpdateCustomizer
extends VCSOptionsCustomizerAdapter {
    private UI _ui;

    public Component getComponent() {
        if (this._ui == null) {
            this._ui = new UI(null);
        }
        return this._ui;
    }

    public Map getOptions() {
        UI ui = (UI)this.getComponent();
        HashMap<String, Object> opts = new HashMap<String, Object>(7);
        opts.put("oracle.jdeveloper.subversion.REVISION", ui.getRevision());
        opts.put("oracle.jdeveloper.subversion.IGNORE_EXTERNALS", ui.isIgnoreExternalsSelected());
        opts.put("oracle.jdeveloper.subversion.RECURSIVE", ui.isRecursiveSelected());
        return opts;
    }

    public void setOptions(Map map) {
        Boolean b;
        UI ui = (UI)this.getComponent();
        SVNRevision revision = (SVNRevision)map.get("oracle.jdeveloper.subversion.REVISION");
        if (revision != null) {
            ui.setRevision(revision);
        }
        if ((b = (Boolean)map.get("oracle.jdeveloper.subversion.IGNORE_EXTERNALS")) != null) {
            ui.setIgnoreExternals(b);
        }
        if ((b = (Boolean)map.get("oracle.jdeveloper.subversion.RECURSIVE")) != null) {
            ui.setRecursiveSelected(b);
        }
    }

    public void validateOptions() throws VCSException {
        if (SVNRevision.INVALID_REVISION.equals((Object)((UI)this.getComponent()).getRevision())) {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            throw new VCSException(res.getString("INVALID_REVISION_ERROR_TITLE"), res.getString("INVALID_REVISION_ERROR_MESSAGE"));
        }
    }

    private final class UI
    extends JPanel
    implements ActionListener {
        private JCheckBox _revisionCheck;
        private JTextField _revisionField;
        private JCheckBox _ignoreExternalsCheck;
        private RecursiveOperationPanel _recursiveCheckPanel;

        private UI() {
            super(new GridBagLayout());
            this.createComponents();
            this.layoutComponents();
            this.listen();
        }

        public void setRevision(SVNRevision revision) {
            if (SVNRevision.HEAD.equals((Object)revision)) {
                this._revisionCheck.setSelected(false);
                this._revisionField.setText("");
                this._revisionField.setEnabled(false);
            } else {
                this._revisionCheck.setSelected(true);
                this._revisionField.setText(revision.toString());
                this._revisionField.setEnabled(true);
            }
        }

        public SVNRevision getRevision() {
            if (this._revisionCheck.isSelected()) {
                try {
                    SVNRevision sVNRevision = SVNRevision.getRevision((String)this._revisionField.getText());
                    return sVNRevision;
                }
                catch (ParseException pe) {
                    SVNRevision.Number number = SVNRevision.INVALID_REVISION;
                    return number;
                }
            }
            return SVNRevision.HEAD;
        }

        public void setIgnoreExternals(boolean ignore) {
            this._ignoreExternalsCheck.setSelected(ignore);
        }

        public boolean isIgnoreExternalsSelected() {
            return this._ignoreExternalsCheck.isSelected();
        }

        public void setRecursiveSelected(boolean recursive) {
            this._recursiveCheckPanel.setRecursiveSelected(recursive);
        }

        public boolean isRecursiveSelected() {
            return this._recursiveCheckPanel.isRecursiveSelected();
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this._revisionCheck) {
                this._revisionField.setEnabled(this._revisionCheck.isSelected());
            }
        }

        private void createComponents() {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            this._revisionCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._revisionCheck, (String)res.getString("UI_UPDATE_LABEL_REVISION"));
            this._revisionCheck.setSelected(false);
            this._revisionField = new JTextField();
            this._revisionField.setEnabled(false);
            this._ignoreExternalsCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._ignoreExternalsCheck, (String)res.getString("UI_UPDATE_LABEL_IGNORE_EXTERNALS"));
            this._ignoreExternalsCheck.setSelected(false);
            this._recursiveCheckPanel = new RecursiveOperationPanel();
            this._recursiveCheckPanel.setRecursiveSelected(true);
        }

        private void layoutComponents() {
            this.add((Component)this._revisionCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._revisionField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 6), 100, 0));
            this.add((Component)this._ignoreExternalsCheck, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.add((Component)this._recursiveCheckPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        }

        private void listen() {
            this._revisionCheck.addActionListener(this);
        }

        UI(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

