/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;

public final class SVNEnvironmentTraversable
extends VCSPropertyTraversable {
    private final VCSProfile _profile;
    private UI _propertyPage;
    private static final int TIMEOUT_SCALE_SECONDS = 1;
    private static final int TIMEOUT_SCALE_MINUTES = 2;
    private static final int TIMEOUT_SCALE_HOURS = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = SVNEnvironmentTraversable.class.desiredAssertionStatus() ^ true;
    }

    public SVNEnvironmentTraversable() {
        this.setHelpID("f1_svnpreferencesgeneral_html");
        this._profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (!$assertionsDisabled && this._profile == null) {
            throw new AssertionError();
        }
    }

    protected Component getPropertyPage() {
        if (this._propertyPage == null) {
            this._propertyPage = new UI(null);
        }
        return this._propertyPage;
    }

    protected String getDataKey() {
        return this._profile.getQualifiedDataKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
    }

    protected void validateProperties() throws TraversalException {
    }

    protected Map getProperties() {
        Integer quantity;
        HashMap<String, Comparable<Boolean>> properties = new HashMap<String, Comparable<Boolean>>(7);
        UI ui = (UI)this.getPropertyPage();
        properties.put("useOverlays", Boolean.valueOf(UI.mav$getUseOverlays(ui)));
        properties.put("useLabelDecorations", Boolean.valueOf(UI.mav$getUseLabelDecorations(ui)));
        int scale = 1;
        if (ui.getOperationTimeoutHours().isSelected()) {
            scale = 3;
        }
        if (ui.getOperationTimeoutMinutes().isSelected()) {
            scale = 2;
        }
        Integer quantity0 = (quantity = (Integer)ui.getOperationTimeoutQuantity().getNumber()) != null ? new Integer(this.calculateTimeoutSeconds(quantity, scale)) : SVNVersionToolsPreferences.DEFAULT_OPERATION_TIMEOUT;
        properties.put("property_operation_timeout", quantity0);
        return properties;
    }

    protected void setProperties(Map map) {
        int seconds;
        UI ui = (UI)this.getPropertyPage();
        Boolean b = (Boolean)map.get("useOverlays");
        UI.mav$setUseOverlays(ui, b != null ? b.booleanValue() : SVNVersionToolsPreferences.DEFAULT_USE_OVERLAYS.booleanValue());
        b = (Boolean)map.get("useLabelDecorations");
        UI.mav$setUseLabelDecorations(ui, b != null ? b.booleanValue() : SVNVersionToolsPreferences.DEFAULT_USE_LABEL_DECORATIONS.booleanValue());
        if (map.containsKey("property_operation_timeout")) {
            Object value = map.get("property_operation_timeout");
            seconds = (Integer)value;
        } else {
            seconds = SVNVersionToolsPreferences.DEFAULT_OPERATION_TIMEOUT;
        }
        int scale = this.calculateTimeoutScale(seconds);
        ui.getOperationTimeoutQuantity().setNumber((Number)new Integer(this.calculateTimeoutQuantity(seconds, scale)));
        if (scale == 3) {
            ui.getOperationTimeoutHours().setSelected(true);
        }
        if (scale == 2) {
            ui.getOperationTimeoutMinutes().setSelected(true);
        }
        if (scale == 1) {
            ui.getOperationTimeoutSeconds().setSelected(true);
        }
    }

    private int calculateTimeoutScale(int seconds) {
        if (seconds > 0 && seconds % 3600 == 0) {
            return 3;
        }
        if (seconds > 0 && seconds % 60 == 0) {
            return 2;
        }
        return 1;
    }

    private int calculateTimeoutQuantity(int seconds, int scale) {
        if (scale == 3) {
            return seconds / 3600;
        }
        if (scale == 2) {
            return seconds / 60;
        }
        return seconds;
    }

    private int calculateTimeoutSeconds(int quantity, int scale) {
        if (scale == 3) {
            return quantity * 3600;
        }
        if (scale == 2) {
            return quantity * 60;
        }
        return quantity;
    }

    private final class UI
    extends JPanel {
        private JLabel _envSettingsLabel;
        private JCheckBox _useOverlaysCheck;
        private JCheckBox _useDecorationsCheck;
        private JLabel _operationTimeoutLabel;
        private JRadioButton _operationTimeoutSeconds;
        private JRadioButton _operationTimeoutMinutes;
        private JRadioButton _operationTimeoutHours;
        private NumberTextField _operationTimeoutQuantity;
        private JTextField _autoCheckoutCommentField;

        private UI() {
            this.createComponents();
            this.layoutComponents();
        }

        private boolean getUseOverlays() {
            return this._useOverlaysCheck.isSelected();
        }

        private void setUseOverlays(boolean useOverlays) {
            this._useOverlaysCheck.setSelected(useOverlays);
        }

        private boolean getUseLabelDecorations() {
            return this._useDecorationsCheck.isSelected();
        }

        private void setUseLabelDecorations(boolean useDecorations) {
            this._useDecorationsCheck.setSelected(useDecorations);
        }

        private void createComponents() {
            this._envSettingsLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._envSettingsLabel, (Component)this._envSettingsLabel, (String)VCSArb.getString((int)201));
            this._useOverlaysCheck = new JCheckBox();
            this._useOverlaysCheck.setSelected(true);
            this._useOverlaysCheck.setText(VCSArb.getString((int)178));
            this._useOverlaysCheck.setMnemonic(VCSArb.getInteger((int)90));
            this._useDecorationsCheck = new JCheckBox();
            this._useDecorationsCheck.setSelected(true);
            this._useDecorationsCheck.setText(VCSArb.getString((int)128));
            this._useDecorationsCheck.setMnemonic(VCSArb.getInteger((int)29));
            this._operationTimeoutLabel = new JLabel();
            this._operationTimeoutSeconds = new JRadioButton();
            this._operationTimeoutMinutes = new JRadioButton();
            this._operationTimeoutHours = new JRadioButton();
            this._operationTimeoutQuantity = new NumberTextField();
            ResourceUtils.resLabel((JLabel)this._operationTimeoutLabel, (Component)this._operationTimeoutQuantity, (String)VCSArb.getString((int)197));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutSeconds, (String)VCSArb.getString((int)3));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutMinutes, (String)VCSArb.getString((int)61));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutHours, (String)VCSArb.getString((int)238));
            ButtonGroup operationTimeoutButtonGroup = new ButtonGroup();
            operationTimeoutButtonGroup.add(this._operationTimeoutSeconds);
            operationTimeoutButtonGroup.add(this._operationTimeoutMinutes);
            operationTimeoutButtonGroup.add(this._operationTimeoutHours);
            operationTimeoutButtonGroup = null;
            this._operationTimeoutQuantity.setColumns(10);
            this._operationTimeoutQuantity.setDecimal(true);
            this._operationTimeoutQuantity.setSigned(false);
            this._operationTimeoutQuantity.setDataType(Integer.class);
        }

        private void layoutComponents() {
            Insets insets = new Insets(2, 2, 2, 2);
            LayoutBuilder builder = new LayoutBuilder();
            builder.setDefaultAnchor(18);
            builder.add((Component)this._envSettingsLabel, insets, 3, false, true);
            builder.nl();
            builder.setDefaultAnchor(18);
            builder.addHGap();
            builder.add((Component)this._useOverlaysCheck, insets, 3, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._useDecorationsCheck, insets, 3, false, true);
            builder.nl();
            builder.setDefaultAnchor(18);
            builder.addVGap();
            builder.nl();
            builder.add((Component)this._operationTimeoutLabel, insets, 4, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._operationTimeoutQuantity, insets, 1, false, true);
            builder.add((Component)this._operationTimeoutSeconds, insets, 1, false, false);
            builder.add((Component)this._operationTimeoutMinutes, insets, 1, false, false);
            builder.add((Component)this._operationTimeoutHours, insets, 1, false, false);
            builder.addHFiller();
            builder.nl();
            builder.addVGap();
            builder.nl();
            builder.addToPanel((Container)this);
        }

        public JRadioButton getOperationTimeoutSeconds() {
            return this._operationTimeoutSeconds;
        }

        public JRadioButton getOperationTimeoutMinutes() {
            return this._operationTimeoutMinutes;
        }

        public JRadioButton getOperationTimeoutHours() {
            return this._operationTimeoutHours;
        }

        public NumberTextField getOperationTimeoutQuantity() {
            return this._operationTimeoutQuantity;
        }

        static void mav$setUseOverlays(UI uI, boolean bl) {
            uI.setUseOverlays(bl);
        }

        static void mav$setUseLabelDecorations(UI uI, boolean bl) {
            uI.setUseLabelDecorations(bl);
        }

        static boolean mav$getUseOverlays(UI uI) {
            return uI.getUseOverlays();
        }

        static boolean mav$getUseLabelDecorations(UI uI) {
            return uI.getUseLabelDecorations();
        }

        UI(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

