/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.properties;

import java.util.ArrayList;
import oracle.javatools.controls.nicetable.DefaultNiceTableModel;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesTableModel
extends DefaultNiceTableModel {
    private String[] columnNames;
    private String[][] _properties;

    private void $init$() {
        this.columnNames = new String[]{"Name", "Value"};
    }

    public int getRowCount() {
        if (this._properties == null) {
            return 0;
        }
        return this._properties.length;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnAlignment(int i) {
        return 2;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._properties == null) {
            return null;
        }
        return this._properties[rowIndex][columnIndex];
    }

    public void updateProperties(ISVNProperty[] properties, String scope) {
        this._properties = this.parseISVNPropertyArray(properties, scope);
        this.fireTableDataChanged();
    }

    private String[][] parseISVNPropertyArray(ISVNProperty[] properties, String scope) {
        if (properties == null || properties.length == 0) {
            return null;
        }
        ArrayList<ISVNProperty> propList = new ArrayList<ISVNProperty>();
        int i = 0;
        while (i < properties.length) {
            if (this.accept(properties[i].getName(), scope)) {
                propList.add(properties[i]);
            }
            ++i;
        }
        String[][] strArray = new String[propList.size()][this.getColumnCount()];
        int i2 = 0;
        while (i2 < strArray.length) {
            strArray[i2][0] = ((ISVNProperty)propList.get(i2)).getName();
            strArray[i2][1] = ((ISVNProperty)propList.get(i2)).getValue();
            ++i2;
        }
        return strArray;
    }

    private boolean accept(String propName, String scope) {
        if (scope.equals("All properties")) {
            return true;
        }
        if (scope.equals("Custom properties")) {
            return propName.startsWith("svn:") ^ true;
        }
        if (scope.equals("svn: properties")) {
            return propName.startsWith("svn:");
        }
        return false;
    }

    public PropertiesTableModel() {
        this.$init$();
    }
}

