/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.properties.PropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.ViewPropertiesController;
import oracle.jdevimpl.vcs.svn.properties.ui.PropertiesPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNPropertiesWindow
extends DockableWindow
implements ContextMenuListener {
    public static final String VIEW_NAME = "SVNPropertiesWindow";
    public static final ViewId VIEW_ID = new ViewId("ViewType_SVNProperties", "SVNPropertiesWindow");
    public static final String ALL_PROP = "All properties";
    public static final String SVN_PROP = "svn: properties";
    public static final String CUSTOM_PROP = "Custom properties";
    private Controller _controller;
    private ResourcePicker _res;
    private PropertiesPanel _panel;
    private NiceTable _table;
    private PropertiesTableModel _model;
    private Toolbar _toolbar;
    private JComboBox _scopeBox;
    private IdeAction _refreshAction;
    private IdeAction _addAction;
    private IdeAction _deleteAction;
    private IdeAction _saveAction;
    private IdeAction _editAction;
    private JLabel _resourceLabel;
    private ContextMenu _contextMenu;
    private PropActiveViewListener _viewListener;
    private Context _context;
    private File _currentResource;
    private PropMouseListener _mouseListener;
    private RowSelectionListener _rowSelectionListener;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    public SVNPropertiesWindow(Context context) {
        super(VIEW_ID.getId());
        this.$init$();
        this.setViewContext(context);
        this.registerViewListener();
        this.registerMouseListener();
        this.refresh(context);
    }

    public String getTabName() {
        return this._res.getString("PROPS_DOCKABLE_TAB_NAME");
    }

    public String getTitleName() {
        return this._res.getString("PROPS_DOCKABLE_TITLE");
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        switch (newState) {
            case 3: {
                this._panel.setTable(null);
                this._panel.setEnabled(false);
                this._panel = null;
                this.deregisterViewListener();
                this.deregisterMouseListener();
                break;
            }
        }
    }

    public Component getGUI() {
        if (this._panel == null) {
            this._panel = new PropertiesPanel(this.getToolbar(), this.getTable());
        }
        return this._panel;
    }

    public final Controller getController() {
        if (this._controller == null) {
            this._controller = new ViewPropertiesController();
        }
        return this._controller;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public final Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.initToolbar();
        }
        return this._toolbar;
    }

    private void initToolbar() {
        this._toolbar.add((Component)this.getScopeComboBox());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getRefreshAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getAddAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getEditAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getDeleteAction());
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getSaveAction());
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this.getResourceLabel());
    }

    private JLabel getResourceLabel() {
        if (this._resourceLabel == null) {
            this._resourceLabel = new JLabel(this._res.getString("ACTION_VIEWPROPERTIES_RESOURCE_PROMPT"));
        }
        return this._resourceLabel;
    }

    private JComboBox getScopeComboBox() {
        if (this._scopeBox == null) {
            this._scopeBox = new JComboBox<String>(new String[]{ALL_PROP, SVN_PROP, CUSTOM_PROP});
            this._scopeBox.addItemListener(new 1());
        }
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(renderer.getFontMetrics(renderer.getFont()), "Customized properties") + 30, this._scopeBox.getPreferredSize().height);
        this._scopeBox.setRenderer(renderer);
        this._scopeBox.setMaximumSize(d);
        this._scopeBox.setPreferredSize(d);
        this._scopeBox.setMinimumSize(d);
        return this._scopeBox;
    }

    private void updateCotroller() {
        this.getController().update(this.getDeleteAction(), this.getContext());
        this.getController().update(this.getSaveAction(), this.getContext());
        this.getAddAction().updateAction();
        this.getEditAction().updateAction();
    }

    private IdeAction getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = this.getLocalAction(51);
        }
        return this._refreshAction;
    }

    private IdeAction getAddAction() {
        if (this._addAction == null) {
            this._addAction = IdeAction.find((String)"oracle.jdeveloper.subversion.addproperty");
        }
        return this._addAction;
    }

    private IdeAction getDeleteAction() {
        if (this._deleteAction == null) {
            this._deleteAction = this.getLocalAction(20);
        }
        return this._deleteAction;
    }

    private IdeAction getSaveAction() {
        if (this._saveAction == null) {
            this._saveAction = this.getLocalAction(11);
            this._saveAction.setName(this._res.getString("ACTION_SAVEPROPERTIES_NAME"));
        }
        return this._saveAction;
    }

    private IdeAction getEditAction() {
        if (this._editAction == null) {
            this._editAction = IdeAction.find((String)"oracle.jdeveloper.subversion.editproperty");
        }
        return this._editAction;
    }

    private IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    public void refresh() {
        this.updatePropertieTable(this._currentResource);
    }

    protected void refresh(Context context) {
        if (context == null) {
            this.refresh();
            return;
        }
        this._currentResource = this.getResourceSelection(context.getSelection());
        this.updatePropertieTable(this._currentResource);
    }

    protected void remove() {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_VIEWPROPERTIES_DELETE_MESSAGE"), (String)this._res.getString("ACTION_VIEWPROPERTIES_DELETE_TITLE"), null)) {
            return;
        }
        int[] selectedRows = this.getTable().getSelectedRowsInModel();
        int i = 0;
        while (i < selectedRows.length) {
            String propName = (String)this.getTableModel().getValueAt(selectedRows[i], 0);
            this.removeProperty(this._currentResource, propName);
            ++i;
        }
        this.refresh();
    }

    protected void save() {
        String propName = (String)this.getTableModel().getValueAt(this._panel.getTable().getSelectedRow(), 0);
        this.saveProperty(this._currentResource, propName);
    }

    protected void updatePropertieTable(File resource) {
        this.setTableData(this.getProperties(resource));
        this.updateFilePromptLabel(resource == null ? "" : resource.getName());
    }

    private void updateFilePromptLabel(String fileName) {
        this.getResourceLabel().setText(this._res.getString("ACTION_VIEWPROPERTIES_RESOURCE_PROMPT") + fileName);
    }

    private void registerMouseListener() {
        this._mouseListener = new PropMouseListener(null);
        this._rowSelectionListener = new RowSelectionListener((JTable)this.getTable());
        this.getTable().addMouseListener((MouseListener)this._mouseListener);
        this.getTable().getSelectionModel().addListSelectionListener(this._rowSelectionListener);
    }

    private void deregisterMouseListener() {
        this.getTable().removeMouseListener((MouseListener)this._mouseListener);
        this.getTable().getSelectionModel().removeListSelectionListener(this._rowSelectionListener);
    }

    private void registerViewListener() {
        this._viewListener = new PropActiveViewListener();
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this._viewListener);
    }

    private void deregisterViewListener() {
        this._viewListener.removeSelectionListener();
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this._viewListener);
    }

    public File getResource() {
        this._currentResource = this.getResourceSelection(this.getViewContext().getSelection());
        return this._currentResource;
    }

    public Context getViewContext() {
        return this._context;
    }

    public void setViewContext(Context context) {
        this._context = context;
    }

    private boolean isProjectNavigatorView(View view) {
        return view.getId().equals("_SUB_ApplicationNavigatorWindow._SUB_ApplicationNavigatorName");
    }

    public void setTableData(ISVNProperty[] properties) {
        this.getTableModel().updateProperties(properties, this.getScope());
    }

    public String getScope() {
        return this._scopeBox == null || (String)this._scopeBox.getSelectedItem() == null ? ALL_PROP : (String)this._scopeBox.getSelectedItem();
    }

    private ISVNProperty[] getProperties(File resource) {
        this._currentResource = resource;
        if (resource == null) {
            return null;
        }
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            ISVNProperty[] iSVNPropertyArray = client.getProperties(resource);
            return iSVNPropertyArray;
        }
        catch (SVNClientException e) {
            ISVNProperty[] iSVNPropertyArray = null;
            return iSVNPropertyArray;
        }
    }

    private void saveProperty(File resource, String propertyName) {
        if (resource == null) {
            return;
        }
        SaveURLChooser urlChooser = new SaveURLChooser();
        File dest = null;
        DialogUtil.initURLChooser((URLChooser)urlChooser, (Context)this._context);
        if (urlChooser.showSaveDialog((Component)Ide.getMainWindow()) == 0) {
            dest = new File(URLFileSystem.getPlatformPathName((URL)urlChooser.getSelectedURL()));
        }
        if (dest == null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            byte[] value = client.propertyGet(resource, propertyName).getData();
            fos = new FileOutputStream(dest);
            fos.write(value);
            fos.close();
        }
        catch (SVNClientException e) {
            return;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void removeProperty(File resource, String propertyName) {
        if (resource == null) {
            return;
        }
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            client.propertyDel(resource, propertyName, false);
        }
        catch (SVNClientException e) {
            return;
        }
    }

    private File getResourceSelection(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        if (!(elements[0] instanceof Node) && !(elements[0] instanceof RelativeDirectoryContextFolder)) {
            return null;
        }
        Element element = elements[0];
        File resource = null;
        if (element instanceof Node) {
            resource = SVNUtil.toFile(((Node)element).getURL());
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (element instanceof RelativeDirectoryContextFolder) {
            RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)element;
            URLPath roots = folder.getRootDirectories();
            String path = folder.getRelativePath();
            for (URL root : roots) {
                if (!root.getPath().endsWith("src/")) continue;
                stringBuffer.append(URLFileSystem.getPlatformPathName((URL)root));
                break;
            }
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(path);
            resource = new File(stringBuffer.toString());
        }
        return resource;
    }

    public NiceTable getTable() {
        if (this._table == null) {
            this._table = new NiceTable((TableModel)((Object)this.getTableModel()));
            this._table.setAutoResizeMode(0);
            this._table.setSortColumn(0, false);
            Object[] prototypeValues = new String[]{"reasonablylongpropertyname", "thisisreasonablelongpropertyvaluethisisreasonablelongpropertyvalue"};
            this.getTable().autoSizeColumnsToFit(prototypeValues);
        }
        return this._table;
    }

    public PropertiesTableModel getTableModel() {
        if (this._model == null) {
            this._model = new PropertiesTableModel();
        }
        return this._model;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.addMenuItems(contextMenu);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addMenuItems(ContextMenu contextMenu) {
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getRefreshAction()));
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getAddAction()));
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getEditAction()));
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getDeleteAction()));
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getSaveAction()));
    }

    static Context ra$_context(SVNPropertiesWindow sVNPropertiesWindow) {
        return sVNPropertiesWindow._context;
    }

    static boolean mav$isProjectNavigatorView(SVNPropertiesWindow sVNPropertiesWindow, View view) {
        return sVNPropertiesWindow.isProjectNavigatorView(view);
    }

    static File mav$getResourceSelection(SVNPropertiesWindow sVNPropertiesWindow, Element[] elementArray) {
        return sVNPropertiesWindow.getResourceSelection(elementArray);
    }

    static IdeAction mav$getEditAction(SVNPropertiesWindow sVNPropertiesWindow) {
        return sVNPropertiesWindow.getEditAction();
    }

    static void mav$updateCotroller(SVNPropertiesWindow sVNPropertiesWindow) {
        sVNPropertiesWindow.updateCotroller();
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            SVNPropertiesWindow.this.refresh();
        }
    }

    private class PropActiveViewListener
    implements ActiveViewListener {
        private PropViewSelectionListener _selectionListener;

        private void $init$() {
            this._selectionListener = new PropViewSelectionListener(null);
        }

        public PropActiveViewListener() {
            this.$init$();
            this.addSelectionListener();
        }

        public void activeViewChanged(ActiveViewEvent e) {
            View view = e.getOldView();
            if (view != null && SVNPropertiesWindow.mav$isProjectNavigatorView(SVNPropertiesWindow.this, view)) {
                view.removeViewSelectionListener((ViewSelectionListener)this._selectionListener);
            }
            if (SVNPropertiesWindow.mav$isProjectNavigatorView(SVNPropertiesWindow.this, view = e.getNewView())) {
                view.addViewSelectionListener((ViewSelectionListener)this._selectionListener);
                SVNPropertiesWindow.this.refresh(view.getContext());
                SVNPropertiesWindow.this.setViewContext(view.getContext());
            }
        }

        public void removeSelectionListener() {
            if (SVNPropertiesWindow.ra$_context(SVNPropertiesWindow.this) == null) {
                return;
            }
            View view = SVNPropertiesWindow.ra$_context(SVNPropertiesWindow.this).getView();
            if (SVNPropertiesWindow.mav$isProjectNavigatorView(SVNPropertiesWindow.this, view)) {
                view.removeViewSelectionListener((ViewSelectionListener)this._selectionListener);
            }
        }

        public void addSelectionListener() {
            if (SVNPropertiesWindow.ra$_context(SVNPropertiesWindow.this) == null) {
                return;
            }
            View view = SVNPropertiesWindow.ra$_context(SVNPropertiesWindow.this).getView();
            if (SVNPropertiesWindow.mav$isProjectNavigatorView(SVNPropertiesWindow.this, view)) {
                view.addViewSelectionListener((ViewSelectionListener)this._selectionListener);
            }
        }
    }

    private class PropViewSelectionListener
    implements ViewSelectionListener {
        public void viewSelectionChanged(ViewSelectionEvent e) {
            File resource = SVNPropertiesWindow.mav$getResourceSelection(SVNPropertiesWindow.this, e.getSelection());
            SVNPropertiesWindow.this.updatePropertieTable(resource);
        }

        private PropViewSelectionListener() {
        }

        PropViewSelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SaveURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC = "f1_svnsaveproperty_html";

        SaveURLChooser() {
            this.setHelpID(HELP_TOPIC);
        }

        protected URL canonicalizeApprovalURL(URL url) {
            if (URLFileSystem.isDirectory((URL)url)) {
                return URLFileSystem.canonicalize((URL)url);
            }
            String fileName = URLFileSystem.getFileName((URL)url);
            URL dirURL = URLFileSystem.canonicalize((URL)URLFileSystem.getParent((URL)url));
            return URLFactory.newURL((URL)dirURL, (String)fileName);
        }
    }

    private final class PropMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SVNPropertiesWindow.this.getContextMenu().show(SVNPropertiesWindow.this.getContext(e));
            }
            if (e.getClickCount() == 2) {
                try {
                    SVNPropertiesWindow.mav$getEditAction(SVNPropertiesWindow.this).performAction();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SVNPropertiesWindow.this.getContextMenu().show(SVNPropertiesWindow.this.getContext(e));
            }
        }

        private PropMouseListener() {
        }

        PropMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RowSelectionListener
    implements ListSelectionListener {
        JTable table;

        RowSelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                SVNPropertiesWindow.mav$updateCotroller(SVNPropertiesWindow.this);
            }
            if (e.getValueIsAdjusting()) {
                // empty if block
            }
        }
    }
}

