/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.repos;

import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ideri.importexport.ExportWizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.ui.SVNRepositoryImportExportPanel;

public final class SVNRepositoryImportExportWizard
implements ExportWizard,
ImportWizard {
    private final ResourcePicker _res;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    public String getExportWizardName(Context context) {
        return this._res.getString("REPOS_CONN_EXP_IMP_NAME");
    }

    public String getImportWizardName(Context context) {
        return this._res.getString("REPOS_CONN_EXP_IMP_NAME");
    }

    public Icon getExportWizardIcon(Context context) {
        return this._res.getImage("NAV_ICON_REPOSITORIES_NODE");
    }

    public Icon getImportWizardIcon(Context context) {
        return this._res.getImage("NAV_ICON_REPOSITORIES_NODE");
    }

    public String getExportWizardTooltipText(Context context) {
        return this._res.getString("REPOS_CONN_EXP_TOOLTIP");
    }

    public String getImportWizardTooltipText(Context context) {
        return this._res.getString("REPOS_CONN_IMP_TOOLTIP");
    }

    public boolean isAvailableAsExportWizard(Context context) {
        VCSProfile activeProfile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (activeProfile != null) {
            return "oracle.jdeveloper.subversion".equals(activeProfile.getID()) && !SVNRepositoryManager.getInstance().isEmpty();
        }
        return false;
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return true;
    }

    public boolean invokeExportWizard(Context context, String[] params) {
        SVNRepositoryImportExportPanel ui = new SVNRepositoryImportExportPanel();
        ui.setImportMode(false);
        ui.setExplanatoryText(this._res.getString("REPOS_CONN_EXP_DIALOG_HINT"));
        return ui.runDialog(VCSWindowUtils.getCurrentWindow(), this._res.getString("REPOS_CONN_EXP_DIALOG_TITLE"), "f1_svnexportsvnconnections_html");
    }

    public boolean invokeImportWizard(Context context, String[] params) {
        SVNRepositoryImportExportPanel ui = new SVNRepositoryImportExportPanel();
        ui.setImportMode(true);
        ui.setExplanatoryText(this._res.getString("REPOS_CONN_IMP_DIALOG_HINT"));
        if (ui.runDialog(VCSWindowUtils.getCurrentWindow(), this._res.getString("REPOS_CONN_IMP_DIALOG_TITLE"), "f1_svnimportsvnconnections_html")) {
            SVNRepositoryNavigatorAPI.getInstance().showRepositoryNavigator();
            return true;
        }
        return false;
    }

    public SVNRepositoryImportExportWizard() {
        this.$init$();
    }
}

