/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.util.NullNotificationListener;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;

public final class SVNRepositoryInfoValidator {
    private static final NullNotificationListener sNullListener = new NullNotificationListener();
    private SVNRepositoryInfo _reposInfo;
    private ISVNClientAdapter _client;
    private ISVNNotifyListener _listener;
    private boolean isRepoValid;

    private void $init$() {
        this.isRepoValid = false;
    }

    public SVNRepositoryInfoValidator(SVNRepositoryInfo reposInfo, ISVNClientAdapter client) {
        this.$init$();
        if (reposInfo == null || client == null) {
            throw new NullPointerException();
        }
        this._reposInfo = reposInfo;
        this._client = client;
    }

    public SVNRepositoryInfoValidator(SVNRepositoryInfo reposInfo, ISVNClientAdapter client, ISVNNotifyListener notificationListener) {
        this(reposInfo, client);
        this._listener = notificationListener;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate() {
        VCSPropertyMap vtoolsPrefs = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        int TIMEOUT = vtoolsPrefs != null ? ((Integer)vtoolsPrefs.getMap().get("property_operation_timeout")).intValue() : SVNVersionToolsPreferences.DEFAULT_OPERATION_TIMEOUT.intValue();
        this._client.addNotifyListener(this.getNotificationListener());
        try {
            SVNClientInteraction.getInstance().beginInteraction(this._client, this._reposInfo);
            InfoThread it = new InfoThread(null);
            FutureTask<Object> ft = new FutureTask<Object>(it, null);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 5, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            executor.execute(ft);
            ft.get(TIMEOUT, TimeUnit.SECONDS);
            boolean bl = this.isRepoValid;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            SVNClientInteraction.getInstance().endInteraction();
            this._client.removeNotifyListener(this.getNotificationListener());
            return bl;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
            this._client.removeNotifyListener(this.getNotificationListener());
        }
    }

    private ISVNNotifyListener getNotificationListener() {
        return this._listener != null ? this._listener : sNullListener;
    }

    static ISVNClientAdapter ra$_client(SVNRepositoryInfoValidator sVNRepositoryInfoValidator) {
        return sVNRepositoryInfoValidator._client;
    }

    static SVNRepositoryInfo ra$_reposInfo(SVNRepositoryInfoValidator sVNRepositoryInfoValidator) {
        return sVNRepositoryInfoValidator._reposInfo;
    }

    static void wa$isRepoValid(SVNRepositoryInfoValidator sVNRepositoryInfoValidator, boolean bl) {
        sVNRepositoryInfoValidator.isRepoValid = bl;
    }

    private final class InfoThread
    implements Runnable {
        public void run() {
            try {
                ISVNInfo info = SVNRepositoryInfoValidator.ra$_client(SVNRepositoryInfoValidator.this).getInfo(SVNRepositoryInfoValidator.ra$_reposInfo(SVNRepositoryInfoValidator.this).getURL());
                SVNRepositoryInfoValidator.wa$isRepoValid(SVNRepositoryInfoValidator.this, info != null && info.getRevision() != null);
            }
            catch (Exception ie) {
                SVNRepositoryInfoValidator.wa$isRepoValid(SVNRepositoryInfoValidator.this, false);
            }
        }

        private InfoThread() {
        }

        InfoThread(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

