/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNURLInfoIO {
    private static final long SERIALVERSION_V1 = 1L;

    public byte[] marshall(SVNURLInfo urlInfo) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeLong(1L);
        dataOut.writeInt(urlInfo.getTextStatus());
        dataOut.writeInt(urlInfo.getPropStatus());
        dataOut.writeLong(urlInfo.getRevision());
        dataOut.writeLong(urlInfo.getLastChangedRevision());
        String author = urlInfo.getLastCommitAuthor();
        dataOut.writeUTF(author != null ? author : "");
        SVNUrl url = urlInfo.getURL();
        dataOut.writeUTF(url != null ? url.toString() : "");
        dataOut.flush();
        byte[] byArray = out.toByteArray();
        try {
            return byArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                dataOut.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SVNURLInfo unmarshall(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream dataIn = new DataInputStream(in);
        dataIn.readLong();
        int textStatus = dataIn.readInt();
        int propStatus = dataIn.readInt();
        long revision = dataIn.readLong();
        long lastChangedRevision = dataIn.readLong();
        String author = dataIn.readUTF();
        String url = dataIn.readUTF();
        SVNURLInfo sVNURLInfo = new SVNURLInfo(textStatus, propStatus, revision, lastChangedRevision, author.length() > 0 ? author : null, url.length() > 0 ? new SVNUrl(url) : null);
        try {
            return sVNURLInfo;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                dataIn.close();
            }
            catch (IOException iOException) {}
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

