/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.profiler;

import oracle.jdeveloper.profiler.OjvmProfilerConnection;
import oracle.jdeveloper.profiler.ProfilerConnection;

public class ProfilerAPI {
    private static ProfilerConnection profConn;
    public static boolean isActive;

    private ProfilerAPI() {
    }

    public static void startSampling() {
        profConn.startSampling();
    }

    public static void stopSampling() {
        profConn.stopSampling();
    }

    public static int startEvent(int n, String string) {
        return profConn.startEvent(n, string);
    }

    public static int startEvent(int n) {
        return profConn.startEvent(n, null);
    }

    public static void endEvent(int n, String string) {
        profConn.endEvent(n, string);
    }

    public static void endEvent(int n) {
        profConn.endEvent(n, null);
    }

    public static void pulseEvent(int n, String string) {
        profConn.pulseEvent(n, string);
    }

    public static boolean isEventActive(int n) {
        return profConn.isEventActive(n);
    }

    public static void addComment(int n, String string) {
        profConn.addComment(n, string);
    }

    public static void addStackToComment(int n) {
        profConn.addStackToComment(n);
    }

    public static void clearEventHistory() {
        profConn.clearEventHistory();
    }

    public static void dumpEventHistory() {
        profConn.dumpEventHistory();
    }

    public static void addComment(int n, Object object) {
        ProfilerAPI.addComment(n, String.valueOf(object));
    }

    public static void addComment(int n, int n2) {
        ProfilerAPI.addComment(n, String.valueOf(n2));
    }

    public static void addComment(int n, char c) {
        ProfilerAPI.addComment(n, String.valueOf(c));
    }

    public static void addComment(int n, boolean bl) {
        ProfilerAPI.addComment(n, String.valueOf(bl));
    }

    public static void addComment(int n, float f) {
        ProfilerAPI.addComment(n, String.valueOf(f));
    }

    public static void addComment(int n, double d) {
        ProfilerAPI.addComment(n, String.valueOf(d));
    }

    public static void addComment(int n, long l) {
        ProfilerAPI.addComment(n, String.valueOf(l));
    }

    public static void addComment(int n, char[] cArray) {
        ProfilerAPI.addComment(n, String.valueOf(cArray));
    }

    public static void addComment(int n, char[] cArray, int n2, int n3) {
        ProfilerAPI.addComment(n, String.valueOf(cArray, n2, n3));
    }

    public static long getTimer() {
        return profConn.getTimer();
    }

    public static void createEvent(int n, long l, long l2, String string) {
        profConn.createEvent(n, l, l2, string);
    }

    public static String getDMSParams() {
        return profConn.getDMSParams();
    }

    static {
        try {
            String string = System.getProperty("jdev.profiler");
            if (string == null) {
                profConn = new OjvmProfilerConnection();
                isActive = OjvmProfilerConnection.checkLib();
            } else {
                profConn = (ProfilerConnection)Class.forName(string).newInstance();
            }
        }
        catch (Throwable throwable) {
            isActive = false;
        }
        if (!isActive) {
            profConn = new ProfilerConnection();
        }
    }
}

