/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency;

import java.awt.EventQueue;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DeclarationProvider;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.IdDeclarationProvider;

public abstract class IdDeclaration
implements Declaration {
    protected String id;

    public static IdDeclaration findDeclaration(Context context, String id) throws InterruptedException {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalArgumentException("Cannot be called on event thread");
        }
        DependencyManager dm = DependencyManager.getDependencyManager();
        for (DeclarationProvider provider : dm.getDeclarationProviders()) {
            IdDeclarationProvider idp;
            IdDeclaration declaration;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!(provider instanceof IdDeclarationProvider) || (declaration = (idp = (IdDeclarationProvider)provider).getDeclaration(context, id)) == null) continue;
            return declaration;
        }
        return null;
    }

    public IdDeclaration(String id) {
        this.id = id;
    }

    public String getDeclarationId() {
        return this.id;
    }

    public boolean canDelete() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IdDeclaration) {
            IdDeclaration other = (IdDeclaration)object;
            return this.getDeclarationId().equals(other.getDeclarationId());
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclarationId().hashCode();
    }
}

