/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency;

import java.net.URL;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFileSystem;

public final class SourceUtils {
    public static void openSourceFile(Workspace workspace, Project project, URL url) {
        SourceUtils.openSourceFile(workspace, project, url, 0, 0);
    }

    public static void openSourceFile(Workspace workspace, Project project, URL url, int startOffset, int endOffset) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context context = new Context(node);
            context.setWorkspace(workspace);
            context.setProject(project);
            LineNavigationPoint point = new LineNavigationPoint(context, startOffset, false);
            NavigationManager.getNavigationManager().navigateTo((NavigationPoint)point);
        }
        catch (Exception e) {
            DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to open " + URLFileSystem.getPlatformPathName((URL)url), e);
        }
    }
}

