/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.IdDeclarationProvider;
import oracle.ide.dependency.SourceUtils;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLDeclarationProvider
implements IdDeclarationProvider {
    private static final String PREFIX = "url:";

    public static String getDeclarationId(URL url) {
        return PREFIX + url.toString();
    }

    public static URL getURL(String id) {
        if (URLDeclarationProvider.isURLDeclaration(id)) {
            try {
                URL uRL = new URL(id.substring(PREFIX.length()));
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isURLDeclaration(String id) {
        return id != null && id.startsWith(PREFIX);
    }

    @Override
    public IdDeclaration getDeclaration(Context context, String id) throws InterruptedException {
        URL url = URLDeclarationProvider.getURL(id);
        if (url != null) {
            Workspace workspace = context.getWorkspace();
            Project project = URLDeclarationProvider.getProject(context, url);
            return new URLDeclaration(workspace, project, url, id);
        }
        return null;
    }

    @Override
    public boolean canGetDeclaration(Context context) {
        return false;
    }

    @Override
    public Declaration getDeclaration(Context context) {
        return null;
    }

    @Override
    public boolean canGetDeclarations(Context context, Node node) {
        return true;
    }

    @Override
    public Collection<? extends Declaration> getDeclarations(Context context, Node node) {
        URL url = node.getURL();
        Workspace workspace = context.getWorkspace();
        Project project = URLDeclarationProvider.getProject(context, url);
        return Collections.singleton(new URLDeclaration(workspace, project, url));
    }

    private static Project getProject(Context context, URL url) {
        return context.getProject();
    }

    private static final class URLDeclaration
    extends IdDeclaration {
        private Workspace workspace;
        private Project project;
        private URL url;

        public URLDeclaration(Workspace workspace, Project project, URL url) {
            this(workspace, project, url, URLDeclarationProvider.getDeclarationId(url));
        }

        public URLDeclaration(Workspace workspace, Project project, String id) {
            this(workspace, project, URLDeclarationProvider.getURL(id), id);
        }

        public URLDeclaration(Workspace workspace, Project project, URL url, String id) {
            super(id);
            this.workspace = workspace;
            this.project = project;
            this.url = url;
        }

        public URL getURL() {
            return this.url;
        }

        public void show() {
            SourceUtils.openSourceFile(this.workspace, this.project, this.url);
        }
    }
}

