/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency.index;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.dependency.IdReference;
import oracle.ide.dependency.SourceReference;
import oracle.ide.dependency.SourceUtils;
import oracle.ide.dependency.index.DependencyCriteria;
import oracle.ide.index.IndexingContext;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public abstract class IndexReference
extends IdReference
implements SourceReference {
    private Workspace workspace;
    private Project project;
    private URL url;
    private int startOffset;
    private int endOffset;

    public IndexReference(IndexingContext context, int startOffset, int endOffset) {
        this(Ide.getActiveWorkspace(), context.getProject(), context.getURL(), startOffset, endOffset);
    }

    public IndexReference(Workspace workspace, Project project, URL url, int startOffset, int endOffset) {
        this.workspace = workspace;
        this.project = project;
        this.url = url;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Project getProject() {
        return this.project;
    }

    public URL getURL() {
        return this.url;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void show() {
        SourceUtils.openSourceFile(this.getWorkspace(), this.getProject(), this.getURL(), this.getStartOffset(), this.getEndOffset());
    }

    public QueryCriteria getQueryCriteria() {
        return DependencyCriteria.getReferenceCriteria(this.getDeclarationId());
    }
}

