/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.dependency.index.IndexReference;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.dependency.index.DependencyCollector;
import oracle.ideimpl.index.IndexingContextImpl;
import oracle.javatools.data.PropertyStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexReferenceProvider
implements ReferenceProvider {
    protected abstract Collection<QueryCriteria> getReferenceCriteria(Context var1, Declaration var2);

    protected ContentSet getContentSet(Context context, Project project, Declaration declaration) {
        return ProjectContent.getInstance((PropertyStorage)project).getAllContents();
    }

    @Override
    public boolean canGetReference(Context context) {
        return false;
    }

    @Override
    public Reference getReference(Context context) {
        return null;
    }

    @Override
    public boolean canGetReferences(Context context, Node node) {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<? extends Reference> getReferences(Context context, Node node) throws InterruptedException {
        Project project = context.getProject();
        Index index = IndexManager.getIndexManager().getIndex(project);
        try {
            index.lock();
            DependencyCollector dc = new DependencyCollector();
            IndexingContextImpl ic = new IndexingContextImpl(project);
            ic.setFilterKey((Object)"dependency.reference");
            ic.startIndexing();
            try {
                ic.index(node.getURL(), (long)-1, (DataCollector)dc);
            }
            finally {
                ic.endIndexing();
            }
            Collection<IndexReference> collection = Collections.unmodifiableCollection(dc.getReferences());
            {
                catch (Throwable throwable) {
                    index.unlock();
                    throw throwable;
                }
            }
            index.unlock();
        }
        catch (LockFailedException e) {
            DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to get references for " + URLFileSystem.getPlatformPathName((URL)node.getURL()), e);
        }
        finally {
            index.release();
        }
        index.release();
        return Collections.emptySet();
    }

    @Override
    public boolean canFindReferences(Context context, Scope scope, Declaration declaration) {
        return true;
    }

    @Override
    public Collection<? extends Reference> findReferences(Context context, Scope scope, Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        ArrayList<IndexReference> references = new ArrayList<IndexReference>();
        for (Project project : scope.getProjects()) {
            ContentSet content = this.getContentSet(context, project, declaration);
            Index index = IndexManager.getIndexManager().getIndex(project, content);
            try {
                try {
                    index.lock();
                    try {
                        for (QueryCriteria criteria : this.getReferenceCriteria(context, declaration)) {
                            URL[] urls;
                            URL[] uRLArray = urls = (URL[])index.query(criteria).get();
                            int n = 0;
                            while (n < uRLArray.length) {
                                URL url = uRLArray[n];
                                if (scope.isIncluded(project, content, url)) {
                                    DependencyCollector dc = new DependencyCollector();
                                    IndexingContextImpl ic = new IndexingContextImpl(project);
                                    ic.setFilterKey((Object)"dependency.reference");
                                    ic.startIndexing();
                                    try {
                                        ic.index(url, (long)-1, (DataCollector)dc);
                                    }
                                    finally {
                                        ic.endIndexing();
                                    }
                                    Collection<IndexReference> urlReferences = dc.getReferences();
                                    Iterator<IndexReference> iterator = urlReferences.iterator();
                                    while (iterator.hasNext()) {
                                        IndexReference reference = iterator.next();
                                        if (this.verify(context, reference, declaration)) continue;
                                        iterator.remove();
                                    }
                                    references.addAll(urlReferences);
                                }
                                ++n;
                            }
                        }
                    }
                    finally {
                        index.unlock();
                    }
                }
                catch (LockFailedException e) {
                    DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
                }
                catch (ExecutionException e) {
                    DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
                }
            }
            finally {
                index.release();
            }
        }
        return Collections.unmodifiableCollection(references);
    }

    protected boolean verify(Context context, IndexReference reference, Declaration declaration) throws InterruptedException {
        return reference.isReferenceTo(context, declaration);
    }
}

