/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.dependency;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DeclarationProvider;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.model.Node;
import oracle.ide.performance.PerformanceLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManagerImpl
extends DependencyManager {
    private static final ProgressIndicator NULL_PROGRESS_INDICATOR = new 1();
    final CopyOnWriteArrayList<DeclarationProvider> declarationProviders;
    final CopyOnWriteArrayList<ReferenceProvider> referenceProviders;

    private void $init$() {
        this.declarationProviders = new CopyOnWriteArrayList();
        this.referenceProviders = new CopyOnWriteArrayList();
    }

    static void checkEventThread() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalArgumentException("Cannot be called on event thread");
        }
    }

    @Override
    public Logger getLogger() {
        return Logger.getLogger(DependencyManager.class.getName());
    }

    @Override
    public Declaration getDeclaration(Context context) {
        Result result = DependencyManagerImpl.createResult();
        this.callProviders(this.declarationProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getDeclaration", new 2(this, context, result));
        return (Declaration)result.getResult();
    }

    @Override
    public Reference getReference(Context context) {
        Result result = DependencyManagerImpl.createResult();
        this.callProviders(this.referenceProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReference", new 3(this, context, result));
        return (Reference)result.getResult();
    }

    @Override
    public Collection<Reference> getReferences(Context context, Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        HashSet references = new HashSet();
        this.callProviders(this.referenceProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new 4(this, context, node, references));
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public Collection<Declaration> getDeclarations(Context context, Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        HashSet declarations = new HashSet();
        this.callProviders(this.declarationProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new 5(this, context, node, declarations));
        return Collections.unmodifiableCollection(declarations);
    }

    @Override
    public Collection<Reference> findReferences(Context context, Scope scope, Declaration declaration) throws InterruptedException {
        return this.findReferences(context, scope, declaration, NULL_PROGRESS_INDICATOR);
    }

    @Override
    public Collection<Reference> findReferences(Context context, Scope scope, Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        HashSet references = new HashSet();
        this.callProviders(this.referenceProviders, progress, "oracle.ideimpl.dependency.DependencyManagerImpl.findUrlsReferencing", new 6(this, context, scope, declaration, references));
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public void addDeclarationProvider(DeclarationProvider provider) {
        this.declarationProviders.add(provider);
    }

    @Override
    public void addReferenceProvider(ReferenceProvider provider) {
        this.referenceProviders.add(provider);
    }

    @Override
    public Collection<DeclarationProvider> getDeclarationProviders() {
        return Collections.unmodifiableCollection(this.declarationProviders);
    }

    @Override
    public Collection<ReferenceProvider> getReferenceProviders() {
        return Collections.unmodifiableCollection(this.referenceProviders);
    }

    private <T> void callProviders(Collection<T> providers, ProgressIndicator progress, String name, ProviderTask<T> task) {
        try {
            this.callProviders(providers, progress, name, new 7(this, task));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Non-interruptible task threw InterruptedException", e);
        }
    }

    private <T> void callProviders(Collection<T> providers, ProgressIndicator progress, String name, InterruptibleProviderTask<T> task) throws InterruptedException {
        for (T provider : providers) {
            try {
                long start = System.nanoTime();
                boolean result = task.run(provider, progress);
                PerformanceLogger.get().log(name, provider.getClass().getName(), System.nanoTime() - start);
                if (result) continue;
                break;
            }
            catch (RuntimeException e) {
                this.getLogger().log(Level.SEVERE, "Exception in " + provider.getClass().getName(), e);
            }
        }
    }

    private static <T> Result<T> createResult() {
        return new Result(null);
    }

    public DependencyManagerImpl() {
        this.$init$();
    }

    static final class 1
    implements ProgressIndicator {
        public void setProgress(int progress) {
        }

        public void setProgressText(String text) {
        }

        public boolean isCanceled() {
            return false;
        }
    }

    final class 2
    implements ProviderTask {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Result v$result;
        final /* synthetic */ DependencyManagerImpl this$0;

        public boolean run(DeclarationProvider provider, ProgressIndicator progress) {
            if (provider.canGetDeclaration(this.v$context)) {
                this.v$result.setResult(provider.getDeclaration(this.v$context));
                return this.v$result.isSet() ^ true;
            }
            return true;
        }

        public 2(DependencyManagerImpl dependencyManagerImpl, Context context, Result result) {
            this.v$result = result;
            this.v$context = context;
            this.this$0 = dependencyManagerImpl;
        }
    }

    final class 3
    implements ProviderTask {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Result v$result;
        final /* synthetic */ DependencyManagerImpl this$0;

        public boolean run(ReferenceProvider provider, ProgressIndicator progress) {
            if (provider.canGetReference(this.v$context)) {
                this.v$result.setResult(provider.getReference(this.v$context));
            }
            return this.v$result.isSet() ^ true;
        }

        public 3(DependencyManagerImpl dependencyManagerImpl, Context context, Result result) {
            this.v$result = result;
            this.v$context = context;
            this.this$0 = dependencyManagerImpl;
        }
    }

    final class 4
    implements InterruptibleProviderTask {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Node v$node;
        private final /* synthetic */ HashSet v$references;
        final /* synthetic */ DependencyManagerImpl this$0;

        public boolean run(ReferenceProvider provider, ProgressIndicator progress) throws InterruptedException {
            Collection<? extends Reference> results;
            if (provider.canGetReferences(this.v$context, this.v$node) && (results = provider.getReferences(this.v$context, this.v$node)) != null) {
                this.v$references.addAll(results);
            }
            return true;
        }

        public 4(DependencyManagerImpl dependencyManagerImpl, Context context, Node node, HashSet hashSet) {
            this.v$references = hashSet;
            this.v$node = node;
            this.v$context = context;
            this.this$0 = dependencyManagerImpl;
        }
    }

    final class 5
    implements InterruptibleProviderTask {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Node v$node;
        private final /* synthetic */ HashSet v$declarations;
        final /* synthetic */ DependencyManagerImpl this$0;

        public boolean run(DeclarationProvider provider, ProgressIndicator progress) throws InterruptedException {
            Collection<? extends Declaration> results;
            if (provider.canGetDeclarations(this.v$context, this.v$node) && (results = provider.getDeclarations(this.v$context, this.v$node)) != null) {
                this.v$declarations.addAll(results);
            }
            return true;
        }

        public 5(DependencyManagerImpl dependencyManagerImpl, Context context, Node node, HashSet hashSet) {
            this.v$declarations = hashSet;
            this.v$node = node;
            this.v$context = context;
            this.this$0 = dependencyManagerImpl;
        }
    }

    final class 6
    implements InterruptibleProviderTask {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Scope v$scope;
        private final /* synthetic */ Declaration v$declaration;
        private final /* synthetic */ HashSet v$references;
        final /* synthetic */ DependencyManagerImpl this$0;

        public boolean run(ReferenceProvider provider, ProgressIndicator progress) throws InterruptedException {
            Collection<? extends Reference> results;
            if (provider.canFindReferences(this.v$context, this.v$scope, this.v$declaration) && (results = provider.findReferences(this.v$context, this.v$scope, this.v$declaration, progress)) != null) {
                this.v$references.addAll(results);
            }
            return true;
        }

        public 6(DependencyManagerImpl dependencyManagerImpl, Context context, Scope scope, Declaration declaration, HashSet hashSet) {
            this.v$references = hashSet;
            this.v$declaration = declaration;
            this.v$scope = scope;
            this.v$context = context;
            this.this$0 = dependencyManagerImpl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 7
    implements InterruptibleProviderTask {
        private final /* synthetic */ ProviderTask v$task;
        final /* synthetic */ DependencyManagerImpl this$0;

        @Override
        public boolean run(T provider, ProgressIndicator progress) {
            return this.v$task.run(provider, progress);
        }

        public 7(DependencyManagerImpl dependencyManagerImpl, ProviderTask providerTask) {
            this.v$task = providerTask;
            this.this$0 = dependencyManagerImpl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private interface ProviderTask<T> {
        public boolean run(T var1, ProgressIndicator var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private interface InterruptibleProviderTask<T> {
        public boolean run(T var1, ProgressIndicator var2) throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Result<T> {
        private T result;

        T getResult() {
            return this.result;
        }

        void setResult(T result) {
            this.result = result;
        }

        boolean isSet() {
            return this.result != null;
        }

        private Result() {
        }

        Result(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

