/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.dependency.index;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.IdDeclarationProvider;
import oracle.ide.dependency.IdReference;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.index.DependencyCriteria;
import oracle.ide.dependency.index.IndexDeclaration;
import oracle.ide.dependency.index.IndexDeclarationProvider;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ideimpl.dependency.index.DependencyCollector;
import oracle.ideimpl.index.IndexingContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexIdDeclarationProvider
extends IndexDeclarationProvider
implements IdDeclarationProvider {
    @Override
    public Collection<QueryCriteria> getDeclarationCriteria(Context context, Reference reference) {
        if (reference instanceof IdReference) {
            String id = ((IdReference)reference).getDeclarationId();
            return Collections.singleton(DependencyCriteria.getDeclarationCriteria(id));
        }
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IdDeclaration getDeclaration(Context context, String id) throws InterruptedException {
        Project project = context.getProject();
        if (project == null) return null;
        Index index = IndexManager.getIndexManager().getIndex(project);
        try {
            try {
                URL[] urls;
                QueryCriteria criteria = new QueryCriteria();
                criteria.put((Object)"dependency.declaration", (Object)id);
                URL[] uRLArray = urls = (URL[])index.query(criteria).get();
                int n = 0;
                while (n < uRLArray.length) {
                    URL url = uRLArray[n];
                    DependencyCollector dc = new DependencyCollector();
                    IndexingContextImpl ic = new IndexingContextImpl(project);
                    ic.setFilterKey((Object)"dependency.declaration");
                    ic.startIndexing();
                    try {
                        ic.index(url, (long)-1, (DataCollector)dc);
                    }
                    finally {
                        ic.endIndexing();
                    }
                    for (IndexDeclaration declaration : dc.getDeclarations()) {
                        IdDeclaration idDeclaration;
                        if (!(declaration instanceof IdDeclaration) || !id.equals((idDeclaration = (IdDeclaration)declaration).getDeclarationId())) continue;
                        IdDeclaration idDeclaration2 = idDeclaration;
                        return idDeclaration2;
                    }
                    ++n;
                }
                return null;
            }
            finally {
                index.release();
            }
        }
        catch (ExecutionException e) {
            DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to get declaration for " + id, e);
            return null;
        }
    }
}

