/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xmlc.XMLComparator;
import oracle.xmlc.XMLComparatorException;
import oracle.xmlc.engine.ComparatorEngine;
import oracle.xmlc.engine.CompareRequest;
import oracle.xmlc.engine.CompareResult;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.engine.DiffEngineXML;
import oracle.xmlc.engine.DifferenceType;
import oracle.xmlc.engine.MergeEngineXML;
import oracle.xmlc.engine.MergeRequest;
import oracle.xmlc.model.XMLAttribute;
import oracle.xmlc.model.XMLCDATA;
import oracle.xmlc.model.XMLCharacterBlock;
import oracle.xmlc.model.XMLCharacterBlockLine;
import oracle.xmlc.model.XMLComment;
import oracle.xmlc.model.XMLDeclaration;
import oracle.xmlc.model.XMLDoctype;
import oracle.xmlc.model.XMLDocumentRoot;
import oracle.xmlc.model.XMLElement;
import oracle.xmlc.model.XMLProcessingInstruction;
import oracle.xmlc.model.XMLResourceElement;
import oracle.xmlc.parser.SourceParser;
import oracle.xmlc.parser.SourceParserException;
import oracle.xmlc.xdelta.Anchor;
import oracle.xmlc.xdelta.AnchorType;
import oracle.xmlc.xdelta.Content;
import oracle.xmlc.xdelta.Hunk;
import oracle.xmlc.xdelta.HunkType;
import oracle.xmlc.xdelta.Index;
import oracle.xmlc.xdelta.Node;
import oracle.xmlc.xdelta.NodeType;
import oracle.xmlc.xdelta.Offsets;
import oracle.xmlc.xdelta.Path;
import oracle.xmlc.xdelta.Range;
import oracle.xmlc.xdelta.Result;
import oracle.xmlc.xdelta.XDelta;
import oracle.xmlc.xdelta.XMerge;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultXMLComparator
extends XMLComparator {
    private static final String XMLNS_XD = "http://xmlns.oracle.com/xdelta";
    private final SourceParser _sourceParser;
    private Properties _outputProperties;
    private boolean _canceled;
    private ComparatorEngine _engine;
    private GrammarProvider _grammarProvider;

    DefaultXMLComparator(SourceParser sourceParser) {
        this._sourceParser = sourceParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDelta compare(Source src1, Source src2, javax.xml.transform.Result delta) throws XMLComparatorException {
        XMLResourceElement src1Tree = this.parseSource(src1);
        XMLResourceElement src2Tree = this.parseSource(src2);
        this.testRootElementsComparable(src1Tree, src2Tree);
        Map<XMLResourceElement, NodePath> src1PathMap = this.createPathMap(src1Tree);
        Map<XMLResourceElement, NodePath> src2PathMap = this.createPathMap(src2Tree);
        DiffEngineXML engine = new DiffEngineXML();
        DefaultXMLComparator defaultXMLComparator = this;
        synchronized (defaultXMLComparator) {
            if (this._canceled) {
                XDelta xDelta = null;
                return xDelta;
            }
            this._engine = engine;
        }
        CompareResult compareResult = engine.compare(new CompareRequest(src1Tree, src2Tree, src1.getSystemId(), src2.getSystemId()), false);
        if (this._canceled) {
            return null;
        }
        XDelta xdelta = this.createXDeltaModel(ComparatorMode.COMPARE, compareResult, src1PathMap, src2PathMap);
        this.constructResultFromDOM(xdelta, delta);
        DefaultXMLComparator defaultXMLComparator2 = this;
        synchronized (defaultXMLComparator2) {
            this._engine = null;
        }
        return xdelta;
    }

    private void constructResultFromDOM(XDelta xdelta, javax.xml.transform.Result result) throws XMLComparatorException {
        if (result == null) {
            return;
        }
        try {
            this.constructResultFromDOM(this.createXDeltaDOM(xdelta), result);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLComparatorException(pce);
        }
    }

    private void constructResultFromDOM(Document dom, javax.xml.transform.Result result) throws XMLComparatorException {
        try {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    transformerFactory.setAttribute("indent-number", 2);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("media-type", "text/xml");
                transformer.transform(new DOMSource(dom), result);
            }
            catch (TransformerConfigurationException tce) {
                throw new XMLComparatorException(tce);
            }
            catch (TransformerException te) {
                throw new XMLComparatorException(te);
            }
        }
        finally {
            this._sourceParser.cleanup();
        }
    }

    private XDelta createXDeltaModel(ComparatorMode mode, CompareResult compareResult, Map<XMLResourceElement, NodePath> src1PathMap, Map<XMLResourceElement, NodePath> src2PathMap) throws XMLComparatorException {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        this.createXDeltaHunks(mode, compareResult.getResult(), compareResult.getRequest().getSourceSystemId(), src1PathMap, compareResult.getRequest().getTargetSystemId(), src2PathMap, null, null, hunks, new HashSet<XMLResourceElement>());
        XDelta xdelta = new XDelta();
        xdelta.setHunks(hunks.toArray(new Hunk[0]));
        return xdelta;
    }

    private Document createXDeltaDOM(XDelta xdelta) throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        document.appendChild(this._createXDeltaDOM(xdelta, document));
        return document;
    }

    private org.w3c.dom.Node _createXDeltaDOM(XDelta xdelta, Document document) {
        Element xdeltaElement = document.createElementNS(XMLNS_XD, "xd:xdelta");
        Hunk[] hunkArray = xdelta.getHunks();
        int n = 0;
        while (n < hunkArray.length) {
            Hunk hunk = hunkArray[n];
            Element hunkElement = document.createElementNS(XMLNS_XD, "xd:hunk");
            xdeltaElement.appendChild(hunkElement);
            if (hunk.getId() != null) {
                hunkElement.setAttribute("id", hunk.getId());
            }
            if (hunk.getHunkType() != null) {
                hunkElement.setAttribute("hunk-type", this.createStringFromEnum(hunk.getHunkType()));
            }
            Content[] contentArray = hunk.getContents();
            int n2 = 0;
            while (n2 < contentArray.length) {
                Content content = contentArray[n2];
                Element contentElement = document.createElementNS(XMLNS_XD, "xd:content");
                hunkElement.appendChild(contentElement);
                Path[] pathArray = content.getPaths();
                int n3 = 0;
                while (n3 < pathArray.length) {
                    Path path = pathArray[n3];
                    contentElement.appendChild(this._createXDeltaDOM(path, document));
                    ++n3;
                }
                Node[] nodeArray = content.getNodes();
                int n4 = 0;
                while (n4 < nodeArray.length) {
                    Node node = nodeArray[n4];
                    Element nodeElement = document.createElementNS(XMLNS_XD, "xd:node");
                    contentElement.appendChild(nodeElement);
                    if (node.getAttributeName() != null) {
                        nodeElement.setAttribute("attribute-name", node.getAttributeName());
                    }
                    nodeElement.setAttribute("node-type", this.createStringFromEnum(node.getNodeType()));
                    nodeElement.setTextContent(node.getValue());
                    ++n4;
                }
                ++n2;
            }
            ++n;
        }
        return xdeltaElement;
    }

    private Element _createXDeltaDOM(Path path, Document document) {
        Element pathElement;
        if (!(path instanceof Anchor)) {
            pathElement = document.createElementNS(XMLNS_XD, "xd:path");
        } else {
            pathElement = document.createElementNS(XMLNS_XD, "xd:anchor");
            pathElement.setAttribute("anchor-type", this.createStringFromEnum(((Anchor)path).getAnchorType()));
        }
        if (path.getDocument() != null) {
            pathElement.setAttribute("document", path.getDocument());
        }
        if (path.getXPath() != null) {
            pathElement.setAttribute("xpath", path.getXPath());
        }
        if (path.getOffsets() != null) {
            Offsets offsets = path.getOffsets();
            pathElement.setAttribute("offsets", String.valueOf(offsets.getStart()) + ',' + String.valueOf(offsets.getEnd()));
        }
        if (path.getRange() != null) {
            Range range = path.getRange();
            pathElement.setAttribute("range", String.valueOf(range.getStart()) + ',' + String.valueOf(range.getLength()));
        }
        return pathElement;
    }

    private String createStringFromEnum(Enum enumeration) {
        return enumeration.name().toLowerCase().replace('_', '-');
    }

    private Map<XMLResourceElement, NodePath> createPathMap(XMLResourceElement tree) {
        if (tree == null) {
            return new HashMap<XMLResourceElement, NodePath>();
        }
        LinkedHashMap<XMLResourceElement, NodePath> pathMap = new LinkedHashMap<XMLResourceElement, NodePath>();
        this._createPathMap(tree, pathMap, new XPathBuilder(null));
        for (Map.Entry pathEntry : pathMap.entrySet()) {
            ((NodePath)pathEntry.getValue()).setOffsets(this._sourceParser.getElementOffsets((XMLResourceElement)pathEntry.getKey()));
            if (!((XMLResourceElement)pathEntry.getKey() instanceof XMLCharacterBlockLine)) continue;
            ((NodePath)pathEntry.getValue()).setRange(new int[]{((XMLResourceElement)pathEntry.getKey()).getXMLParent().getChildElementList().indexOf((XMLResourceElement)pathEntry.getKey()), 1});
        }
        return pathMap;
    }

    private void _createPathMap(XMLResourceElement element, Map<XMLResourceElement, NodePath> pathMap, XPathBuilder xpathBuilder) {
        String parentPath;
        XMLResourceElement parent = element.getXMLParent();
        while (parent != null && !(parent instanceof XMLElement)) {
            parent = parent.getXMLParent();
        }
        NodePath parentNodePath = parent != null ? pathMap.get(parent) : null;
        String string = parentPath = parentNodePath != null ? parentNodePath.getXPath() : null;
        if (element instanceof XMLDocumentRoot) {
            pathMap.put(element, new NodePath("/", null));
        }
        if (element instanceof XMLDoctype || element instanceof XMLDeclaration) {
            pathMap.put(element, new NodePath(null, null));
        }
        if (element instanceof XMLProcessingInstruction) {
            pathMap.put(element, new NodePath(xpathBuilder.createElementPath(parentPath, XPathFunction.PI), null));
        }
        if (element instanceof XMLComment) {
            pathMap.put(element, new NodePath(xpathBuilder.createElementPath(parentPath, XPathFunction.COMMENT), null));
        }
        if (element instanceof XMLCharacterBlock && this._sourceParser.isOffsetCapable()) {
            pathMap.put(element, new NodePath(null));
            if (element.getXMLParent() instanceof XMLCDATA) {
                pathMap.put(element.getXMLParent(), new NodePath(null));
            }
            Iterator itr = element.getChildElements();
            while (itr != null && itr.hasNext()) {
                pathMap.put((XMLResourceElement)itr.next(), new NodePath(null));
            }
        }
        if (element instanceof XMLCharacterBlock && !this._sourceParser.isOffsetCapable() && !(element.getXMLParent() instanceof XMLCDATA)) {
            pathMap.put(element, new NodePath(xpathBuilder.createElementPath(parentPath, XPathFunction.TEXT), null));
            Iterator itr = element.getChildElements();
            while (itr != null && itr.hasNext()) {
                pathMap.put((XMLResourceElement)itr.next(), pathMap.get(element));
            }
        }
        if (element instanceof XMLAttribute) {
            if (element.getName().startsWith("xmlns:") || element.getName().equals("xmlns")) {
                pathMap.put(element, new NodePath(null, null));
            } else {
                pathMap.put(element, new NodePath(xpathBuilder.createAttributePath(pathMap.get(element.getXMLParent()).getXPath(), element.getName()), null));
            }
        }
        if (element instanceof XMLElement) {
            pathMap.put(element, new NodePath(xpathBuilder.createElementPath(parentPath, element.getName()), null));
        }
        this._createPathMap(element.getDiffChildren(), pathMap, xpathBuilder);
    }

    private void _createPathMap(Iterator itr, Map<XMLResourceElement, NodePath> pathMap, XPathBuilder xpathBuilder) {
        while (itr != null && itr.hasNext()) {
            this._createPathMap((XMLResourceElement)itr.next(), pathMap, xpathBuilder);
        }
    }

    private void createXDeltaHunks(ComparatorMode mode, XMLResourceElement element, String baseSystemId, Map<XMLResourceElement, NodePath> basePathMap, String edit1SystemId, Map<XMLResourceElement, NodePath> edit1PathMap, String edit2SystemId, Map<XMLResourceElement, NodePath> edit2PathMap, Collection<Hunk> hunks, Set<XMLResourceElement> visitedElementSet) throws XMLComparatorException {
        HashMap<XMLResourceElement, Integer> hunkIdMap = new HashMap<XMLResourceElement, Integer>();
        this.createHunkIdMap(element, hunkIdMap);
        this.createXDeltaHunks(mode, element, baseSystemId, basePathMap, edit1SystemId, edit1PathMap, edit2SystemId, edit2PathMap, hunks, visitedElementSet, hunkIdMap);
    }

    private void createXDeltaHunks(ComparatorMode mode, XMLResourceElement element, String baseSystemId, Map<XMLResourceElement, NodePath> basePathMap, String edit1SystemId, Map<XMLResourceElement, NodePath> edit1PathMap, String edit2SystemId, Map<XMLResourceElement, NodePath> edit2PathMap, Collection<Hunk> hunks, Set<XMLResourceElement> visitedElementSet, Map<XMLResourceElement, Integer> hunkIdMap) throws XMLComparatorException {
        XMLResourceElement baseElement = (XMLResourceElement)element.getComparableElement(ContributorSequence.BASE_OBJECT);
        XMLResourceElement edit1Element = (XMLResourceElement)element.getComparableElement(ContributorSequence.FIRST_OBJECT);
        XMLResourceElement edit2Element = (XMLResourceElement)element.getComparableElement(ContributorSequence.SECOND_OBJECT);
        if (baseElement != null) {
            visitedElementSet.add(baseElement);
        }
        if (edit1Element != null) {
            visitedElementSet.add(edit1Element);
        }
        if (edit2Element != null) {
            visitedElementSet.add(edit2Element);
        }
        if (element instanceof XMLDocumentRoot) {
            if (edit1Element != null && !this.equalsNullSafe(edit1Element.getCompareString(true), element.getCompareString(true))) {
                this.errorUncomparable(1);
            }
            if (edit2Element != null && !this.equalsNullSafe(edit2Element.getCompareString(true), element.getCompareString(true))) {
                this.errorUncomparable(2);
            }
        }
        HunkType hunkType = HunkType.NO_CHANGE;
        if (this.startsDifference(element)) {
            hunkType = HunkType.CHANGE;
        }
        boolean noChangeHunks = this.getOutputProperties().getProperty("no-change-hunks").equals("yes");
        if (hunkType == HunkType.CHANGE || noChangeHunks && !(element instanceof XMLDocumentRoot) && !(element instanceof XMLAttribute) && !(element instanceof XMLCDATA) && !(element instanceof XMLCharacterBlock)) {
            Hunk hunk = new Hunk();
            if (mode == ComparatorMode.SYNC && this.startsConflict(element)) {
                hunk.setId(String.valueOf(hunkIdMap.get(element)));
            }
            if (noChangeHunks) {
                hunk.setHunkType(hunkType);
            }
            hunks.add(hunk);
            LinkedHashMap<HashNode, Content> contentMap = new LinkedHashMap<HashNode, Content>();
            this.createXDeltaContent(contentMap, element, baseElement, baseSystemId, ContributorSequence.BASE_OBJECT, basePathMap, visitedElementSet, hunkType);
            this.createXDeltaContent(contentMap, element, edit1Element, edit1SystemId, ContributorSequence.FIRST_OBJECT, edit1PathMap, visitedElementSet, hunkType);
            if (edit2PathMap != null) {
                this.createXDeltaContent(contentMap, element, edit2Element, edit2SystemId, ContributorSequence.SECOND_OBJECT, edit2PathMap, visitedElementSet, hunkType);
            }
            hunk.setContents(contentMap.values().toArray(new Content[0]));
        }
        if (this.startsDifference(element)) {
            return;
        }
        Iterator itr = element.getDiffChildren();
        while (itr != null && itr.hasNext()) {
            this.createXDeltaHunks(mode, (XMLResourceElement)itr.next(), baseSystemId, basePathMap, edit1SystemId, edit1PathMap, edit2SystemId, edit2PathMap, hunks, visitedElementSet, hunkIdMap);
        }
    }

    private boolean equalsNullSafe(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private void createXDeltaContent(Map<HashNode, Content> contentMap, XMLResourceElement element, XMLResourceElement contributorElement, String systemId, ContributorSequence contributor, Map<XMLResourceElement, NodePath> pathMap, Set<XMLResourceElement> visitedElementSet, HunkType hunkType) throws XMLComparatorException {
        if (contributorElement == null || contributorElement instanceof XMLCharacterBlockLine && contributorElement.getValue() == null) {
            XMLResourceElement parentElement = element;
            XMLResourceElement contributorParentElement = null;
            while ((parentElement = parentElement.getXMLParent()) != null && (contributorParentElement = (XMLResourceElement)parentElement.getComparableElement(contributor)) == null) {
            }
            if (contributorParentElement == null) {
                this.errorUncomparable(3);
            }
            this.populateXDeltaContentMap(contentMap, null, this.createXDeltaAnchor(this.getXDeltaNodeType(element), systemId, pathMap, contributorParentElement, visitedElementSet));
        } else {
            NodePath nodePath = pathMap.get(contributorElement);
            Path path = new Path();
            this.initializeXDeltaPath(path, systemId, nodePath);
            Node node = new Node();
            if (contributorElement instanceof XMLAttribute) {
                node.setAttributeName(contributorElement.getName());
            }
            node.setNodeType(this.getXDeltaNodeType(contributorElement));
            if (hunkType == HunkType.CHANGE || this.getOutputProperties().getProperty("no-change-nodes").equals("yes")) {
                node.setValue(this.getElementValue(element, contributor, node.getNodeType() == NodeType.TEXT || node.getNodeType() == NodeType.CDATA_SECTION || node.getNodeType() == NodeType.ATTRIBUTE));
            } else {
                node.setValue("");
            }
            this.populateXDeltaContentMap(contentMap, new HashNode(node), path);
        }
    }

    private void errorUncomparable(int code) throws XMLComparatorException {
        XMLComparatorException xmlce = new XMLComparatorException(code + ": Change in XML document cannot be compared");
        xmlce.setSeverity(0);
        throw xmlce;
    }

    private Anchor createXDeltaAnchor(NodeType nodeType, String systemId, Map<XMLResourceElement, NodePath> pathMap, XMLResourceElement contributorParentElement, Set<XMLResourceElement> visitedElementSet) throws XMLComparatorException {
        Anchor anchor = new Anchor();
        if (nodeType == NodeType.ATTRIBUTE) {
            anchor.setAnchorType(AnchorType.ATTRIBUTE_LIST);
            this.initializeXDeltaPath(anchor, systemId, pathMap.get(contributorParentElement));
        } else {
            XMLResourceElement contributorAncestorElement = this.getElementParent(contributorParentElement);
            XMLResourceElement siteElement = contributorParentElement != null ? this.getSiteAnchorElement(contributorAncestorElement, pathMap, visitedElementSet) : null;
            anchor.setAnchorType(siteElement != null ? AnchorType.SITE : AnchorType.PARENT);
            this.initializeXDeltaPath(anchor, systemId, pathMap.get(siteElement != null ? siteElement : contributorAncestorElement));
        }
        return anchor;
    }

    private void initializeXDeltaPath(Path path, String systemId, NodePath nodePath) throws XMLComparatorException {
        int[] rangeArray;
        int[] offsetsArray;
        path.setDocument(systemId);
        path.setXPath(nodePath != null ? nodePath.getXPath() : null);
        int[] nArray = offsetsArray = nodePath != null ? nodePath.getOffsets() : null;
        if (!(offsetsArray == null || path.isAnchor() && ((Anchor)path).getAnchorType() != AnchorType.SITE)) {
            Offsets offsets = new Offsets();
            offsets.setStart(offsetsArray[0]);
            offsets.setEnd(path.isAnchor() ? offsetsArray[0] : offsetsArray[1]);
            path.setOffsets(offsets);
        }
        int[] nArray2 = rangeArray = nodePath != null ? nodePath.getRange() : null;
        if (rangeArray != null && !this._sourceParser.isOffsetCapable()) {
            Range range = new Range();
            range.setStart(rangeArray[0]);
            range.setLength(path.isAnchor() ? 0 : rangeArray[1]);
            path.setRange(range);
        }
        if (path.getXPath() == null && path.getOffsets() == null) {
            this.errorUncomparable(4);
        }
    }

    private XMLResourceElement getElementParent(XMLResourceElement element) {
        while (element != null) {
            if (element instanceof XMLElement) {
                return element;
            }
            if (element.getXMLParent() == null) {
                return element;
            }
            element = element.getXMLParent();
        }
        return element;
    }

    private void populateXDeltaContentMap(Map<HashNode, Content> contentMap, HashNode hashNode, Path path) {
        Node[] nodeArray;
        Content content = contentMap.get(hashNode);
        if (content != null) {
            ArrayList<Path> paths = new ArrayList<Path>(Arrays.asList(content.getPaths()));
            paths.add(path);
            content.setPaths(paths.toArray(new Path[0]));
            return;
        }
        content = new Content();
        content.setPaths(new Path[]{path});
        if (hashNode != null) {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = hashNode.getNode();
        } else {
            nodeArray = new Node[]{};
        }
        content.setNodes(nodeArray);
        contentMap.put(hashNode, content);
    }

    private NodeType getXDeltaNodeType(XMLResourceElement element) {
        if (element instanceof XMLDocumentRoot) {
            return NodeType.DOCUMENT;
        }
        if (element instanceof XMLElement) {
            return NodeType.ELEMENT;
        }
        if (element instanceof XMLAttribute) {
            return NodeType.ATTRIBUTE;
        }
        if (element instanceof XMLCharacterBlock) {
            return NodeType.TEXT;
        }
        if (element instanceof XMLCharacterBlockLine) {
            return NodeType.TEXT;
        }
        if (element instanceof XMLCDATA) {
            return NodeType.CDATA_SECTION;
        }
        if (element instanceof XMLDoctype) {
            return NodeType.DOCUMENT_TYPE;
        }
        if (element instanceof XMLDeclaration) {
            return NodeType.NOTATION;
        }
        if (element instanceof XMLProcessingInstruction) {
            return NodeType.PROCESSING_INSTRUCTION;
        }
        if (element instanceof XMLComment) {
            return NodeType.COMMENT;
        }
        throw new IllegalArgumentException();
    }

    private XMLResourceElement getSiteAnchorElement(XMLResourceElement parentElement, Map<XMLResourceElement, NodePath> pathMap, Set<XMLResourceElement> visitedElementSet) {
        return this.getSiteAnchorElement(parentElement.getDiffChildren(), pathMap, visitedElementSet);
    }

    private XMLResourceElement getSiteAnchorElement(Iterator elements, Map<XMLResourceElement, NodePath> pathMap, Set<XMLResourceElement> visitedElementSet) {
        while (elements != null && elements.hasNext()) {
            XMLResourceElement element = this._getSiteAnchorElement((XMLResourceElement)elements.next(), pathMap, visitedElementSet);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private XMLResourceElement _getSiteAnchorElement(XMLResourceElement element, Map<XMLResourceElement, NodePath> pathMap, Set<XMLResourceElement> visitedElementSet) {
        if (visitedElementSet.contains(element)) {
            return null;
        }
        if (element instanceof XMLAttribute || pathMap.get(element) == null) {
            return null;
        }
        return element;
    }

    private XMLResourceElement parseSource(Source source) throws XMLComparatorException {
        try {
            XMLResourceElement xMLResourceElement = this._sourceParser.parseSource(source);
            return xMLResourceElement;
        }
        catch (SourceParserException spe) {
            throw this.createComparatorException(spe);
        }
    }

    private String getElementValue(XMLResourceElement element, ContributorSequence contributor, boolean format) throws XMLComparatorException {
        try {
            String string = this._sourceParser.getElementValue(element, contributor, format);
            return string;
        }
        catch (SourceParserException spe) {
            throw this.createComparatorException(spe);
        }
    }

    private XMLComparatorException createComparatorException(SourceParserException spe) {
        XMLComparatorException xmlce = new XMLComparatorException(spe);
        xmlce.setSeverity(spe.getSeverity() == 1 ? 1 : 0);
        return xmlce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDelta compare(Source src1, Source src2, Source src3, javax.xml.transform.Result delta) throws XMLComparatorException {
        XMLResourceElement src1Tree = this.parseSource(src1);
        XMLResourceElement src2Tree = this.parseSource(src2);
        XMLResourceElement src3Tree = this.parseSource(src3);
        this.testRootElementsComparable(src3Tree, src1Tree);
        this.testRootElementsComparable(src3Tree, src2Tree);
        Map<XMLResourceElement, NodePath> src1PathMap = this.createPathMap(src1Tree);
        Map<XMLResourceElement, NodePath> src2PathMap = this.createPathMap(src2Tree);
        Map<XMLResourceElement, NodePath> src3PathMap = this.createPathMap(src3Tree);
        MergeEngineXML engine = new MergeEngineXML();
        DefaultXMLComparator defaultXMLComparator = this;
        synchronized (defaultXMLComparator) {
            if (this._canceled) {
                XDelta xDelta = null;
                return xDelta;
            }
            this._engine = engine;
        }
        CompareResult compareResult = engine.merge(new MergeRequest(src1Tree, src2Tree, src3Tree, src1.getSystemId(), src2.getSystemId(), src3.getSystemId()), false);
        if (this._canceled) {
            return null;
        }
        XDelta xdelta = this.createXDeltaModel(ComparatorMode.COMPARE, compareResult, src3PathMap, src1PathMap, src2PathMap);
        this.constructResultFromDOM(xdelta, delta);
        DefaultXMLComparator defaultXMLComparator2 = this;
        synchronized (defaultXMLComparator2) {
            this._engine = null;
        }
        return xdelta;
    }

    private XDelta createXDeltaModel(ComparatorMode mode, CompareResult compareResult, Map<XMLResourceElement, NodePath> basePathMap, Map<XMLResourceElement, NodePath> edit1PathMap, Map<XMLResourceElement, NodePath> edit2PathMap) throws XMLComparatorException {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        this.createXDeltaHunks(mode, compareResult.getResult(), ((MergeRequest)compareResult.getRequest()).getCommonAncestorSystemId(), basePathMap, compareResult.getRequest().getSourceSystemId(), edit1PathMap, compareResult.getRequest().getTargetSystemId(), edit2PathMap, hunks, new HashSet<XMLResourceElement>());
        XDelta xdelta = new XDelta();
        xdelta.setHunks(hunks.toArray(new Hunk[0]));
        return xdelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMerge sync(Source base, Source edit1, Source edit2, javax.xml.transform.Result merge) throws XMLComparatorException {
        XMLResourceElement baseTree = this.parseSource(base);
        XMLResourceElement edit1Tree = this.parseSource(edit1);
        XMLResourceElement edit2Tree = this.parseSource(edit2);
        this.testRootElementsComparable(baseTree, edit1Tree);
        this.testRootElementsComparable(baseTree, edit2Tree);
        Map<XMLResourceElement, NodePath> basePathMap = this.createPathMap(baseTree);
        Map<XMLResourceElement, NodePath> edit1PathMap = this.createPathMap(edit1Tree);
        Map<XMLResourceElement, NodePath> edit2PathMap = this.createPathMap(edit2Tree);
        MergeEngineXML engine = new MergeEngineXML();
        DefaultXMLComparator defaultXMLComparator = this;
        synchronized (defaultXMLComparator) {
            if (this._canceled) {
                XMerge xMerge = null;
                return xMerge;
            }
            this._engine = engine;
        }
        CompareResult compareResult = engine.merge(new MergeRequest(edit1Tree, edit2Tree, baseTree, edit1.getSystemId(), edit2.getSystemId(), base.getSystemId()), false);
        if (this._canceled) {
            return null;
        }
        XMerge xmerge = new XMerge();
        xmerge.setXDelta(this.createXDeltaModel(ComparatorMode.SYNC, compareResult, basePathMap, edit1PathMap, edit2PathMap));
        XMLResourceElement resultTree = compareResult.getResult();
        if (resultTree.getSelectedContributor() == null) {
            this.errorUncomparable(5);
        }
        ArrayList<TraversalState> conflictStates = new ArrayList<TraversalState>();
        HashMap<XMLResourceElement, Integer> hunkIdMap = new HashMap<XMLResourceElement, Integer>();
        this.createHunkIdMap(resultTree, hunkIdMap);
        this.createMergeTree(resultTree, conflictStates, hunkIdMap);
        Map<XMLResourceElement, NodePath> resultPathMap1 = this.createPathMap(resultTree);
        try {
            Result result = new Result();
            String resultString = this._sourceParser.convertInternalModelToString((XMLDocumentRoot)resultTree);
            if (this.getOutputProperties().getProperty("reformat-sync-result").equals("yes")) {
                TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
                textBuffer.read((Reader)new StringReader(resultString));
                textBuffer.writeLock();
                this._sourceParser.reformat(textBuffer);
                StringWriter stringWriter = new StringWriter();
                textBuffer.write((Writer)stringWriter);
                resultString = stringWriter.getBuffer().toString();
            }
            result.setValue(resultString);
            xmerge.setResult(result);
            if (this._sourceParser.isOffsetCapable()) {
                StreamSource resultSource = new StreamSource(new StringReader(xmerge.getResult().getValue()));
                resultSource.setSystemId("result[" + base + "," + edit1 + "," + edit2 + "]");
                this.copyResultOffsetsToPathMap(resultSource, resultPathMap1);
            }
        }
        catch (IOException ioe) {
            throw new XMLComparatorException(ioe);
        }
        catch (SourceParserException spe) {
            throw new XMLComparatorException(spe);
        }
        ArrayList<Index> indices = new ArrayList<Index>();
        this.createXMergeIndices(resultTree, conflictStates, indices, null, resultPathMap1, new HashSet<XMLResourceElement>(), new TraversalState());
        xmerge.setIndices(indices.toArray(new Index[0]));
        this.constructResultFromDOM(xmerge, merge);
        DefaultXMLComparator defaultXMLComparator2 = this;
        synchronized (defaultXMLComparator2) {
            this._engine = null;
        }
        return xmerge;
    }

    private void testRootElementsComparable(XMLResourceElement srcTree1, XMLResourceElement srcTree2) throws XMLComparatorException {
        XMLElement element1 = this.getRootElement(srcTree1);
        XMLElement element2 = this.getRootElement(srcTree2);
        if (element1 == null && element2 == null) {
            return;
        }
        if (element1 != null && element2 != null && element1.getName().equals(element2.getName())) {
            return;
        }
        this.errorUncomparable(6);
    }

    private XMLElement getRootElement(XMLResourceElement srcTree) {
        Iterator itr = srcTree.getDiffChildren();
        while (itr != null && itr.hasNext()) {
            Object child = itr.next();
            if (!(child instanceof XMLElement)) continue;
            return (XMLElement)child;
        }
        return null;
    }

    private void constructResultFromDOM(XMerge xmerge, javax.xml.transform.Result result) throws XMLComparatorException {
        if (result == null) {
            return;
        }
        try {
            this.constructResultFromDOM(this.createXMergeDOM(xmerge), result);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLComparatorException(pce);
        }
    }

    private void copyResultOffsetsToPathMap(Source resultSource, Map<XMLResourceElement, NodePath> resultPathMap1) throws SourceParserException {
        Map<XMLResourceElement, NodePath> resultPathMap2 = this.createPathMap(this._sourceParser.parseSource(resultSource));
        XMLResourceElement element1 = null;
        XMLResourceElement element2 = null;
        Iterator<XMLResourceElement> itr1 = resultPathMap1.keySet().iterator();
        Iterator<XMLResourceElement> itr2 = resultPathMap2.keySet().iterator();
        while (itr1.hasNext() && itr2.hasNext()) {
            if (element1 != null && element2 != null) {
                NodePath nodePath1 = resultPathMap1.get(element1);
                NodePath nodePath2 = resultPathMap2.get(element2);
                if (nodePath1 != null && nodePath2 != null) {
                    nodePath1.setOffsets(nodePath2.getOffsets());
                }
            }
            XMLResourceElement previousElement1 = element1;
            element1 = itr1.next();
            if (previousElement1 instanceof XMLCDATA || previousElement1 instanceof XMLCharacterBlock && previousElement1.getChildElementCount() <= 0) continue;
            element2 = itr2.next();
        }
    }

    private void createHunkIdMap(XMLResourceElement element, Map<XMLResourceElement, Integer> hunkIdMap) {
        if (this.startsConflict(element)) {
            hunkIdMap.put(element, hunkIdMap.size());
            return;
        }
        Iterator itr = element.getDiffChildren();
        while (itr != null && itr.hasNext()) {
            this.createHunkIdMap((XMLResourceElement)itr.next(), hunkIdMap);
        }
    }

    private void createMergeTree(XMLResourceElement element, Collection<TraversalState> conflictStates, Map<XMLResourceElement, Integer> hunkIdMap) {
        Iterator itr;
        ArrayList<XMLResourceElement> children = new ArrayList<XMLResourceElement>();
        Iterator itr2 = element.getDiffChildren();
        while (itr2 != null && itr2.hasNext()) {
            XMLResourceElement childElement = (XMLResourceElement)itr2.next();
            if (this.startsConflict(childElement)) {
                TraversalState conflictState = new TraversalState(childElement);
                conflictState.setParent(element);
                conflictState.setPredecessor(children.isEmpty() ? null : (XMLResourceElement)children.get(children.size() - 1));
                conflictState.setHunkId(hunkIdMap.get(childElement));
                conflictStates.add(conflictState);
                continue;
            }
            if (childElement.getSelectedContributor() == null || childElement.getComparableElement(childElement.getSelectedContributor()) == null) continue;
            children.add(childElement);
        }
        while ((itr = element.getDiffChildren()) != null && itr.hasNext()) {
            XMLResourceElement childElement = (XMLResourceElement)itr.next();
            element.removeDiffChild(childElement);
        }
        for (XMLResourceElement childElement : children) {
            element.addDiffChild(childElement);
        }
        Iterator itr3 = children.iterator();
        while (itr3.hasNext()) {
            this.createMergeTree((XMLResourceElement)itr3.next(), conflictStates, hunkIdMap);
        }
    }

    private boolean startsDifference(XMLResourceElement element) {
        return element.getDifferenceType() != DifferenceType.UNCHANGED;
    }

    private boolean startsConflict(XMLResourceElement element) {
        return this.startsDifference(element) && element.getSelectedContributor() == null;
    }

    private void createXMergeIndices(XMLResourceElement element, Collection<TraversalState> conflictStates, Collection<Index> indices, String resultSystemId, Map<XMLResourceElement, NodePath> resultPathMap, Set<XMLResourceElement> visitedElementSet, TraversalState scratchState) throws XMLComparatorException {
        visitedElementSet.add(element);
        scratchState.setParent(element);
        scratchState.setPredecessor(null);
        this._createXMergeIndices(element, conflictStates, indices, resultSystemId, resultPathMap, visitedElementSet, scratchState);
        Iterator itr = element.getDiffChildren();
        while (itr != null && itr.hasNext()) {
            scratchState.setPredecessor((XMLResourceElement)itr.next());
            visitedElementSet.add(scratchState.getPredecessor());
            this._createXMergeIndices(element, conflictStates, indices, resultSystemId, resultPathMap, visitedElementSet, scratchState);
        }
        Iterator itr2 = element.getDiffChildren();
        while (itr2 != null && itr2.hasNext()) {
            this.createXMergeIndices((XMLResourceElement)itr2.next(), conflictStates, indices, resultSystemId, resultPathMap, visitedElementSet, scratchState);
        }
    }

    private void _createXMergeIndices(XMLResourceElement element, Collection<TraversalState> conflictStates, Collection<Index> indices, String resultSystemId, Map<XMLResourceElement, NodePath> resultPathMap, Set<XMLResourceElement> visitedElementSet, TraversalState scratchState) throws XMLComparatorException {
        for (TraversalState conflictState : conflictStates) {
            if (!conflictState.equals(scratchState)) continue;
            this._createXMergeIndices(this.getXDeltaNodeType(conflictState.getResult()), element, indices, resultSystemId, resultPathMap, visitedElementSet, conflictState.getHunkId());
        }
    }

    private void _createXMergeIndices(NodeType nodeType, XMLResourceElement element, Collection<Index> indices, String resultSystemId, Map<XMLResourceElement, NodePath> resultPathMap, Set<XMLResourceElement> visitedElementSet, int hunkId) throws XMLComparatorException {
        Index index = new Index();
        index.setPath(this.createXDeltaAnchor(nodeType, resultSystemId, resultPathMap, element, visitedElementSet));
        index.setHunkId(String.valueOf(hunkId));
        indices.add(index);
    }

    private Document createXMergeDOM(XMerge xmerge) throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        String xmlns = "http://xmlns.oracle.com/xmerge";
        Element xmergeElement = document.createElementNS(xmlns, "xm:xmerge");
        document.appendChild(xmergeElement);
        Element resultElement = document.createElementNS(xmlns, "xm:result");
        xmergeElement.appendChild(resultElement);
        xmergeElement.appendChild(this._createXDeltaDOM(xmerge.getXDelta(), document));
        resultElement.setTextContent(xmerge.getResult().getValue());
        Index[] indexArray = xmerge.getIndices();
        int n = 0;
        while (n < indexArray.length) {
            Index index = indexArray[n];
            Element indexElement = document.createElementNS(xmlns, "xm:index");
            xmergeElement.appendChild(indexElement);
            indexElement.setAttribute("hunk-id", String.valueOf(index.getHunkId()));
            indexElement.appendChild(this._createXDeltaDOM(index.getPath(), document));
            ++n;
        }
        return document;
    }

    @Override
    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        Properties outputProperties = this.getOutputProperties();
        if (!outputProperties.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        outputProperties.setProperty(name, value);
    }

    @Override
    public String getOutputProperty(String name) throws IllegalArgumentException {
        Properties outputProperties = this.getOutputProperties();
        if (!outputProperties.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        return outputProperties.getProperty(name);
    }

    private Properties getOutputProperties() {
        if (this._outputProperties != null) {
            return this._outputProperties;
        }
        this._outputProperties = new Properties();
        this._outputProperties.put("no-change-hunks", "no");
        this._outputProperties.put("no-change-nodes", "no");
        this._outputProperties.put("default-ns-safe-xpaths", "no");
        this._outputProperties.put("reformat-sync-result", "no");
        return this._outputProperties;
    }

    @Override
    public void setGrammarProvider(GrammarProvider gp) {
        this._grammarProvider = gp;
    }

    @Override
    public GrammarProvider getGrammarProvider() {
        return this._grammarProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        DefaultXMLComparator defaultXMLComparator = this;
        synchronized (defaultXMLComparator) {
            this._canceled = true;
            if (this._engine != null) {
                this._engine.cancel();
            }
        }
    }

    static Properties mav$getOutputProperties(DefaultXMLComparator defaultXMLComparator) {
        return defaultXMLComparator.getOutputProperties();
    }

    static boolean mav$equalsNullSafe(DefaultXMLComparator defaultXMLComparator, Object object, Object object2) {
        return defaultXMLComparator.equalsNullSafe(object, object2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XPathFunction
    extends Enum<XPathFunction> {
        private static final /* synthetic */ XPathFunction[] $v;
        public static final /* enum */ XPathFunction TEXT;
        public static final /* enum */ XPathFunction COMMENT;
        public static final /* enum */ XPathFunction PI;
        private final String _token;

        public static XPathFunction valueOf(String string) {
            return Enum.valueOf(XPathFunction.class, string);
        }

        public static final XPathFunction[] values() {
            return (XPathFunction[])$v.clone();
        }

        static {
            XPathFunction[] xPathFunctionArray = new XPathFunction[3];
            xPathFunctionArray[2] = PI = new XPathFunction("PI", 2, "processing-instruction()");
            xPathFunctionArray[1] = COMMENT = new XPathFunction("COMMENT", 1, "comment()");
            xPathFunctionArray[0] = TEXT = new XPathFunction("TEXT", 0, "text()");
            $v = xPathFunctionArray;
        }

        private XPathFunction(String token, int n2, String string2) {
            this._token = token;
        }

        String getToken() {
            return this._token;
        }
    }

    private class XPathBuilder {
        private Map<String, int[]> _canonicalPathMap;

        private void $init$() {
            this._canonicalPathMap = new HashMap<String, int[]>();
        }

        String createElementPath(String parentElementPath, String name) {
            return this.createElementPath(parentElementPath, name, null);
        }

        String createElementPath(String parentElementPath, XPathFunction function) {
            return this.createElementPath(parentElementPath, null, function);
        }

        private String createElementPath(String parentElementPath, String name, XPathFunction function) {
            StringBuffer xpathBuffer = new StringBuffer();
            if (parentElementPath != null) {
                xpathBuffer.append(parentElementPath);
            }
            if (!xpathBuffer.toString().endsWith("/")) {
                xpathBuffer.append('/');
            }
            this.appendNameOrFunction(xpathBuffer, name, function);
            String canonicalPath = xpathBuffer.toString();
            int[] cardinality = this._canonicalPathMap.get(canonicalPath);
            if (cardinality == null) {
                cardinality = new int[1];
                this._canonicalPathMap.put(canonicalPath, cardinality);
            }
            xpathBuffer.append('[');
            cardinality[0] = cardinality[0] + 1;
            xpathBuffer.append(cardinality[0]);
            xpathBuffer.append(']');
            return xpathBuffer.toString();
        }

        private void appendNameOrFunction(StringBuffer xpathBuffer, String name, XPathFunction function) {
            if (function != null) {
                xpathBuffer.append(function.getToken());
                return;
            }
            if (DefaultXMLComparator.mav$getOutputProperties(DefaultXMLComparator.this).getProperty("default-ns-safe-xpaths").equals("yes")) {
                xpathBuffer.append("*[name()='");
                xpathBuffer.append(name);
                xpathBuffer.append("']");
                return;
            }
            xpathBuffer.append(name);
        }

        String createAttributePath(String elementPath, String name) {
            return this.createAttributePath(elementPath, name, null);
        }

        private String createAttributePath(String elementPath, String name, XPathFunction function) {
            StringBuffer xpathBuffer = new StringBuffer();
            xpathBuffer.append(elementPath);
            xpathBuffer.append("/@");
            this.appendNameOrFunction(xpathBuffer, name, function);
            return xpathBuffer.toString();
        }

        private XPathBuilder() {
            this.$init$();
        }

        XPathBuilder(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class NodePath {
        private final String _xpath;
        private int[] _offsets;
        private int[] _range;

        private NodePath() {
            this((String)null);
        }

        private NodePath(String xpath) {
            this._xpath = xpath;
        }

        String getXPath() {
            return this._xpath;
        }

        int[] getOffsets() {
            return this._offsets;
        }

        void setOffsets(int[] offsets) {
            this._offsets = offsets;
        }

        int[] getRange() {
            return this._range;
        }

        void setRange(int[] range) {
            this._range = range;
        }

        public String toString() {
            return "xpath=" + this._xpath + ",offsets=" + Arrays.asList(new Object[]{this._offsets}) + ",range=" + Arrays.asList(new Object[]{this._range});
        }

        NodePath(String string, 1 var2_2) {
            this(string);
        }

        NodePath(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComparatorMode
    extends Enum<ComparatorMode> {
        private static final /* synthetic */ ComparatorMode[] $v;
        public static final /* enum */ ComparatorMode COMPARE;
        public static final /* enum */ ComparatorMode SYNC;

        public static ComparatorMode valueOf(String string) {
            return Enum.valueOf(ComparatorMode.class, string);
        }

        public static final ComparatorMode[] values() {
            return (ComparatorMode[])$v.clone();
        }

        static {
            ComparatorMode[] comparatorModeArray = new ComparatorMode[2];
            comparatorModeArray[1] = SYNC = new ComparatorMode("SYNC", 1);
            comparatorModeArray[0] = COMPARE = new ComparatorMode("COMPARE", 0);
            $v = comparatorModeArray;
        }

        private ComparatorMode(String string2, int n2) {
        }
    }

    private class HashNode {
        private Node _node;

        HashNode(Node node) {
            this._node = node;
        }

        Node getNode() {
            return this._node;
        }

        public int hashCode() {
            return this._node.getValue().intern().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof HashNode)) {
                return false;
            }
            Node otherNode = ((HashNode)o)._node;
            if (!DefaultXMLComparator.mav$equalsNullSafe(DefaultXMLComparator.this, (Object)this._node.getNodeType(), (Object)otherNode.getNodeType())) {
                return false;
            }
            if (!DefaultXMLComparator.mav$equalsNullSafe(DefaultXMLComparator.this, this._node.getAttributeName(), otherNode.getAttributeName())) {
                return false;
            }
            return DefaultXMLComparator.mav$equalsNullSafe(DefaultXMLComparator.this, this._node.getValue(), otherNode.getValue());
        }
    }

    private static class TraversalState {
        private XMLResourceElement _result;
        private XMLResourceElement _parent;
        private XMLResourceElement _predecessor;
        private int _hunkId;

        TraversalState() {
        }

        TraversalState(XMLResourceElement result) {
            this._result = result;
        }

        XMLResourceElement getResult() {
            return this._result;
        }

        void setParent(XMLResourceElement parent) {
            this._parent = parent;
        }

        XMLResourceElement getPredecessor() {
            return this._predecessor;
        }

        void setPredecessor(XMLResourceElement predecessor) {
            this._predecessor = predecessor;
        }

        int getHunkId() {
            return this._hunkId;
        }

        void setHunkId(int hunkId) {
            this._hunkId = hunkId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TraversalState)) {
                return false;
            }
            TraversalState otherTraversalState = (TraversalState)o;
            return this._parent == otherTraversalState._parent && this._predecessor == otherTraversalState._predecessor;
        }

        public String toString() {
            return "parent=" + this._parent + ",predecessor=" + this._predecessor;
        }
    }
}

