/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc;

import oracle.xmlc.DefaultXMLComparator;
import oracle.xmlc.XMLComparator;
import oracle.xmlc.XMLComparatorConfigurationException;
import oracle.xmlc.parser.SourceParser;
import oracle.xmlc.parser.SourceParserImplV2;

public abstract class XMLComparatorFactory {
    public static final XMLComparatorFactory newInstance() {
        try {
            String factoryClassName = System.getProperty("oracle.xmlc.factory");
            XMLComparatorFactory comparatorFactory = factoryClassName == null ? new DefaultXMLComparatorFactory(null) : (XMLComparatorFactory)Class.forName(factoryClassName).newInstance();
            String parserClassName = System.getProperty("oracle.xmlc.parser");
            SourceParserImplV2 sourceParser = parserClassName == null ? new SourceParserImplV2() : (SourceParser)Class.forName(parserClassName).newInstance();
            comparatorFactory.setSourceParser(sourceParser);
            XMLComparatorFactory xMLComparatorFactory = comparatorFactory;
            return xMLComparatorFactory;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae);
        }
    }

    public abstract SourceParser getSourceParser();

    public abstract void setSourceParser(SourceParser var1);

    public abstract XMLComparator newXMLComparator() throws XMLComparatorConfigurationException;

    private static class DefaultXMLComparatorFactory
    extends XMLComparatorFactory {
        private SourceParser _sourceParser;

        public SourceParser getSourceParser() {
            return this._sourceParser;
        }

        public void setSourceParser(SourceParser sourceParser) {
            this._sourceParser = sourceParser;
        }

        public XMLComparator newXMLComparator() throws XMLComparatorConfigurationException {
            if (this._sourceParser == null) {
                throw new XMLComparatorConfigurationException("SourceParser must be non-null");
            }
            return new DefaultXMLComparator(this._sourceParser);
        }

        private DefaultXMLComparatorFactory() {
        }

        DefaultXMLComparatorFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

