/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.engine;

import oracle.xmlc.engine.ComparableElement;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.engine.DifferenceSequence;
import oracle.xmlc.engine.DifferenceType;

class CompareResultElement {
    protected ComparableElement[] _updates;
    protected DifferenceType[] _statusMapping;
    private int _index;
    private int _baseIndex;
    protected ComparableElement _comparableElement;

    private void $init$() {
        this._updates = new ComparableElement[]{null, null};
        this._statusMapping = new DifferenceType[]{DifferenceType.UNCHANGED, DifferenceType.UNCHANGED};
        this._comparableElement = null;
    }

    public CompareResultElement(ComparableElement comparableElement, int index, int baseIndex) {
        this.$init$();
        this._comparableElement = comparableElement;
        this._baseIndex = baseIndex;
        this._index = index;
    }

    public CompareResultElement(CompareResultElement comparableElement) {
        this.$init$();
        if (comparableElement != null) {
            this._comparableElement = comparableElement.getComparableElement();
            this._baseIndex = comparableElement.getBaseIndex();
            this._index = comparableElement.getIndex();
        }
    }

    public ComparableElement getComparableElement() {
        return this._comparableElement;
    }

    public void setComparableElement(ComparableElement comparableElement) {
        this._comparableElement = comparableElement;
    }

    public void setDiffStatus(DifferenceType status, DifferenceSequence diffIteration) {
        this._statusMapping[diffIteration.ordinal()] = status;
    }

    public DifferenceType getDiffStatus(int diffIteration) {
        return this._statusMapping[diffIteration];
    }

    public DifferenceType getDifferenceType() {
        DifferenceType firstDiffStatus = this.getDiffStatus(DifferenceSequence.FIRST.ordinal());
        DifferenceType secondDiffStatus = this.getDiffStatus(DifferenceSequence.SECOND.ordinal());
        if (firstDiffStatus == DifferenceType.CHANGED || secondDiffStatus == DifferenceType.CHANGED) {
            return DifferenceType.CHANGED;
        }
        if (firstDiffStatus == DifferenceType.ADDED || secondDiffStatus == DifferenceType.ADDED) {
            return DifferenceType.ADDED;
        }
        if (firstDiffStatus == DifferenceType.DELETED || secondDiffStatus == DifferenceType.DELETED) {
            return DifferenceType.DELETED;
        }
        return DifferenceType.UNCHANGED;
    }

    public void setUpdate(ComparableElement update, DifferenceSequence diffIteration) {
        this._updates[diffIteration.ordinal()] = update;
    }

    public ComparableElement getUpdate(int diffIteration) {
        return this._updates[diffIteration];
    }

    public ComparableElement getComparableElement(ContributorSequence whichContributor) {
        DifferenceType firstDiffStatus = this.getDiffStatus(0);
        DifferenceType secondDiffStatus = this.getDiffStatus(1);
        if (firstDiffStatus == DifferenceType.UNCHANGED && secondDiffStatus == DifferenceType.UNCHANGED) {
            return this.getComparableElement();
        }
        if (whichContributor == ContributorSequence.BASE_OBJECT) {
            if (firstDiffStatus != DifferenceType.ADDED && secondDiffStatus != DifferenceType.ADDED) {
                return this.getComparableElement();
            }
        } else if (whichContributor == ContributorSequence.FIRST_OBJECT) {
            if (firstDiffStatus == DifferenceType.ADDED) {
                return this.getUpdate(whichContributor.ordinal() - 1);
            }
            if (firstDiffStatus == DifferenceType.CHANGED) {
                return this.getUpdate(whichContributor.ordinal() - 1);
            }
            if (firstDiffStatus == DifferenceType.UNCHANGED && secondDiffStatus != DifferenceType.ADDED) {
                return this.getComparableElement();
            }
        } else if (whichContributor == ContributorSequence.SECOND_OBJECT) {
            if (secondDiffStatus == DifferenceType.ADDED) {
                return this.getUpdate(whichContributor.ordinal() - 1);
            }
            if (secondDiffStatus == DifferenceType.CHANGED) {
                return this.getUpdate(whichContributor.ordinal() - 1);
            }
            if (secondDiffStatus == DifferenceType.UNCHANGED && firstDiffStatus != DifferenceType.ADDED) {
                return this.getComparableElement();
            }
        }
        return null;
    }

    public String getCompareDisplayString(ContributorSequence whichContributor) {
        ComparableElement element = this.getComparableElement(whichContributor);
        if (element != null) {
            return element.getCompareDisplayString();
        }
        return "";
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public int getBaseIndex() {
        return this._baseIndex;
    }

    public void setBaseIndex(int baseIndex) {
        this._baseIndex = baseIndex;
    }
}

