/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.xmlc.engine.ComparableElement;
import oracle.xmlc.engine.ComparatorEngine;
import oracle.xmlc.engine.CompareRequest;
import oracle.xmlc.engine.CompareResult;
import oracle.xmlc.engine.CompareResultElement;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.engine.DifferenceType;
import oracle.xmlc.engine.TextDiffAlgorithm;
import oracle.xmlc.model.XMLAttribute;
import oracle.xmlc.model.XMLCharacterBlock;
import oracle.xmlc.model.XMLCharacterBlockLine;
import oracle.xmlc.model.XMLElement;
import oracle.xmlc.model.XMLResourceElement;

public class DiffEngineXML
extends ComparatorEngine {
    private XMLResourceElementPriorityQueue _document1Queue;
    private XMLResourceElementPriorityQueue _document2Queue;
    protected int _diffIteration;
    private int _differenceCounter;
    private Collection _treeMutations;

    private void $init$() {
        this._differenceCounter = 0;
        this._treeMutations = new ArrayList();
    }

    public void resetDiffEngine() {
        this._diffIteration = 0;
        this._differenceCounter = 0;
    }

    public CompareResult compare(CompareRequest compareRequest, boolean ignoreWhitespace) {
        XMLResourceElement resultElement = this.compare(compareRequest.getSourceContents(), compareRequest.getTargetContents(), ignoreWhitespace);
        this.executeTreeMutations();
        return new CompareResult(compareRequest, resultElement);
    }

    XMLResourceElement compare(XMLResourceElement rootInDoc1, XMLResourceElement rootInDoc2, boolean ignoreWhitespace) {
        if (rootInDoc1 == null && rootInDoc2 != null) {
            this.setDifferenceType(rootInDoc2, DifferenceType.ADDED, true);
            rootInDoc1 = rootInDoc2;
        } else if (rootInDoc1 != null && rootInDoc2 == null) {
            this.setDifferenceType(rootInDoc1, DifferenceType.DELETED, true);
        } else if (rootInDoc1 != null && rootInDoc2 != null) {
            if (this._document1Queue == null) {
                this._document1Queue = new XMLResourceElementPriorityQueue(null);
            } else {
                XMLResourceElementPriorityQueue.mav$clear(this._document1Queue);
            }
            if (this._document2Queue == null) {
                this._document2Queue = new XMLResourceElementPriorityQueue(null);
            } else {
                XMLResourceElementPriorityQueue.mav$clear(this._document2Queue);
            }
            this.enQueueTreeByWeight(rootInDoc1, this._document1Queue, ignoreWhitespace);
            XMLResourceElementPriorityQueue.mav$enQueue(this._document2Queue, rootInDoc2, rootInDoc2.getWeight(ignoreWhitespace), rootInDoc2.getSignature(ignoreWhitespace));
            if (this.isCanceled()) {
                return null;
            }
            this.locateMatches(ignoreWhitespace);
            if (rootInDoc1.getMatchingElement(this._diffIteration) == null && rootInDoc2.getMatchingElement(this._diffIteration) == null) {
                rootInDoc1.setMatchingElement(rootInDoc2, this._diffIteration);
            }
            this.computeDelta(rootInDoc1, ignoreWhitespace);
        }
        ++this._diffIteration;
        return rootInDoc1;
    }

    private void enQueueTreeByWeight(XMLResourceElement element, XMLResourceElementPriorityQueue priorityQueue, boolean ignoreWhitespace) {
        if (this.isCanceled()) {
            return;
        }
        XMLResourceElementPriorityQueue.mav$enQueue(priorityQueue, element, element.getWeight(ignoreWhitespace), element.getSignature(ignoreWhitespace));
        Iterator children = element.getDiffChildren();
        while (children != null && children.hasNext() && !this.isCanceled()) {
            this.enQueueTreeByWeight((XMLResourceElement)children.next(), priorityQueue, ignoreWhitespace);
        }
    }

    private void enQueueElementsByWeight(Iterator elements, XMLResourceElementPriorityQueue priorityQueue, boolean ignoreWhitespace) {
        while (elements != null && elements.hasNext()) {
            XMLResourceElement element = (XMLResourceElement)elements.next();
            XMLResourceElementPriorityQueue.mav$enQueue(priorityQueue, element, element.getWeight(ignoreWhitespace), element.getSignature(ignoreWhitespace));
        }
    }

    private void locateMatches(boolean ignoreWhitespace) {
        while (!XMLResourceElementPriorityQueue.mav$isEmpty(this._document2Queue)) {
            XMLResourceElement heaviestElementInDoc2 = XMLResourceElementPriorityQueue.mav$get(this._document2Queue, 0);
            XMLResourceElement matchInDoc1 = null;
            if (XMLResourceElementPriorityQueue.mav$containsDuplicateSignatures(this._document2Queue, heaviestElementInDoc2.getSignature(ignoreWhitespace))) {
                XMLResourceElementPriorityQueue.mav$removeElements(this._document2Queue, heaviestElementInDoc2.getSignature(ignoreWhitespace));
                continue;
            }
            heaviestElementInDoc2 = XMLResourceElementPriorityQueue.mav$removeHead(this._document2Queue);
            matchInDoc1 = this.getMatch(heaviestElementInDoc2, ignoreWhitespace);
            if (matchInDoc1 != null) {
                this.matchChildrenAndParents(matchInDoc1, heaviestElementInDoc2, ignoreWhitespace);
                continue;
            }
            this.enQueueElementsByWeight(heaviestElementInDoc2.getDiffChildren(), this._document2Queue, ignoreWhitespace);
        }
    }

    private XMLResourceElement getMatch(XMLResourceElement elementInDoc2, boolean ignoreWhitespace) {
        LinkedList<XMLResourceElement> candidates = new LinkedList<XMLResourceElement>();
        LinkedList<XMLResourceElement> removalList = new LinkedList<XMLResourceElement>();
        long elementInDoc2Weight = elementInDoc2.getWeight(ignoreWhitespace);
        long elementInDoc2Signature = elementInDoc2.getSignature(ignoreWhitespace);
        Iterator itr = XMLResourceElementPriorityQueue.mav$getElements(this._document1Queue);
        while (itr != null && itr.hasNext()) {
            XMLResourceElement candidate = (XMLResourceElement)itr.next();
            if (candidate.getWeight(ignoreWhitespace) > elementInDoc2Weight) {
                removalList.add(candidate);
                continue;
            }
            if (candidate.getWeight(ignoreWhitespace) < elementInDoc2Weight) break;
            if (candidate.getSignature(ignoreWhitespace) != elementInDoc2Signature) continue;
            candidates.add(candidate);
        }
        itr = removalList.iterator();
        while (itr != null && itr.hasNext()) {
            XMLResourceElementPriorityQueue.mav$remove(this._document2Queue, (XMLResourceElement)itr.next());
        }
        if (candidates.size() == 1) {
            return (XMLResourceElement)candidates.get(0);
        }
        return null;
    }

    private void matchChildrenAndParents(XMLResourceElement matchInDoc1, XMLResourceElement matchInDoc2, boolean ignoreWhitespace) {
        matchInDoc1.setMatchingElement(matchInDoc2, this._diffIteration);
        XMLResourceElementPriorityQueue.mav$remove(this._document1Queue, matchInDoc1);
        XMLResourceElementPriorityQueue.mav$remove(this._document2Queue, matchInDoc2);
        this.matchChildren(matchInDoc1, matchInDoc2, ignoreWhitespace);
        XMLResourceElement matchInDoc1Parent = matchInDoc1.getXMLParent();
        XMLResourceElement matchInDoc2Parent = matchInDoc2.getXMLParent();
        while (matchInDoc1Parent != null && matchInDoc2Parent != null) {
            if (matchInDoc1Parent.getMatchingElement(this._diffIteration) != null || matchInDoc2Parent.getMatchingElement(this._diffIteration) != null || matchInDoc1Parent.getName() == null || !matchInDoc1Parent.getName().equals(matchInDoc2Parent.getName())) break;
            matchInDoc1Parent.setMatchingElement(matchInDoc2Parent, this._diffIteration);
            XMLResourceElementPriorityQueue.mav$remove(this._document1Queue, matchInDoc1Parent);
            XMLResourceElementPriorityQueue.mav$remove(this._document2Queue, matchInDoc2Parent);
            matchInDoc1Parent = matchInDoc1Parent.getXMLParent();
            matchInDoc2Parent = matchInDoc2Parent.getXMLParent();
        }
    }

    private void matchChildren(XMLResourceElement matchInDoc1, XMLResourceElement matchInDoc2, boolean ignoreWhitespace) {
        Iterator childrenInDoc1 = matchInDoc1.getDiffChildren();
        List childrenInDoc2 = matchInDoc2.getDiffChildList();
        childrenInDoc2 = childrenInDoc2 != null ? new ArrayList(childrenInDoc2) : null;
        block0: while (childrenInDoc1 != null && childrenInDoc1.hasNext()) {
            XMLResourceElement childInDoc1 = (XMLResourceElement)childrenInDoc1.next();
            int i = 0;
            while (i < childrenInDoc2.size()) {
                XMLResourceElement childInDoc2 = (XMLResourceElement)childrenInDoc2.get(i);
                if (childInDoc1.getSignature(ignoreWhitespace) == childInDoc2.getSignature(ignoreWhitespace)) {
                    childInDoc1.setMatchingElement(childInDoc2, this._diffIteration);
                    if (this._document1Queue != null) {
                        XMLResourceElementPriorityQueue.mav$remove(this._document1Queue, childInDoc1);
                    }
                    if (this._document2Queue != null) {
                        XMLResourceElementPriorityQueue.mav$remove(this._document2Queue, childInDoc2);
                    }
                    this.matchChildren(childInDoc1, childInDoc2, ignoreWhitespace);
                    childrenInDoc2.remove(childInDoc2);
                    continue block0;
                }
                ++i;
            }
        }
        matchInDoc1._subtreeMatched = true;
        matchInDoc2._subtreeMatched = true;
    }

    private void computeDelta(XMLResourceElement elementInDoc1, boolean ignoreWhitespace) {
        XMLResourceElement matchInDoc2 = elementInDoc1.getMatchingElement(this._diffIteration);
        if (matchInDoc2 != null) {
            if (!elementInDoc1._subtreeMatched || !matchInDoc2._subtreeMatched) {
                this.propagateMatchToDirectDiffChildren(elementInDoc1, ignoreWhitespace);
            }
            this.computeChildDelta(elementInDoc1, matchInDoc2, ignoreWhitespace, elementInDoc1 instanceof XMLCharacterBlock);
        }
        Iterator diffChildren = elementInDoc1.getDiffChildren();
        while (diffChildren != null && diffChildren.hasNext()) {
            this.computeDelta((XMLResourceElement)diffChildren.next(), ignoreWhitespace);
        }
    }

    private void propagateMatchToDirectDiffChildren(XMLResourceElement elementInDoc1, boolean ignoreWhitespace) {
        XMLResourceElement matchInDoc2 = elementInDoc1.getMatchingElement(this._diffIteration);
        if (matchInDoc2 != null) {
            Iterator childrenInDoc1 = elementInDoc1.getDiffChildren();
            LinkedList childrenInDoc2 = matchInDoc2.getDiffChildList() == null ? null : new LinkedList(matchInDoc2.getDiffChildList());
            block0: while (childrenInDoc1 != null && childrenInDoc1.hasNext() && childrenInDoc2 != null) {
                XMLResourceElement childInDoc1 = (XMLResourceElement)childrenInDoc1.next();
                if (childInDoc1.getMatchingElement(this._diffIteration) != null || !childInDoc1.hasUniqueSignatureWithinParent(ignoreWhitespace)) continue;
                Iterator children2 = childrenInDoc2.iterator();
                while (children2 != null && children2.hasNext()) {
                    XMLResourceElement childInDoc2 = (XMLResourceElement)children2.next();
                    if (childInDoc2.getMatchingElement(this._diffIteration) == null && childInDoc2.hasUniqueSignatureWithinParent(ignoreWhitespace)) {
                        if (childInDoc1.getSignature(ignoreWhitespace) != childInDoc2.getSignature(ignoreWhitespace)) continue;
                        childInDoc1.setMatchingElement(childInDoc2, this._diffIteration);
                        children2.remove();
                        continue block0;
                    }
                    children2.remove();
                }
            }
        }
    }

    void executeTreeMutations() {
        Iterator itr = this._treeMutations.iterator();
        while (itr.hasNext()) {
            ((TreeMutation)itr.next()).execute();
        }
        this._treeMutations.clear();
    }

    protected void computeChildDelta(XMLResourceElement parent1, XMLResourceElement parent2, boolean ignoreWhitespace, boolean createUpdates) {
        XMLResourceElement childInDoc2;
        XMLResourceElement childInDoc1;
        List childrenInDoc1 = parent1.getDiffChildList();
        List childrenInDoc2 = parent2.getDiffChildList();
        childrenInDoc1 = childrenInDoc1 != null ? new ArrayList(childrenInDoc1) : null;
        List list = childrenInDoc2 = childrenInDoc2 != null ? new ArrayList(childrenInDoc2) : null;
        if (parent1 instanceof XMLElement && parent2 instanceof XMLElement) {
            1 c = new 1();
            if (childrenInDoc1 != null) {
                Collections.sort(childrenInDoc1, c);
            }
            if (childrenInDoc2 != null) {
                Collections.sort(childrenInDoc2, c);
            }
        }
        int list1StartIndex = 0;
        int list1EndIndex = childrenInDoc1 == null ? -1 : childrenInDoc1.size() - 1;
        int list2StartIndex = 0;
        int list2EndIndex = childrenInDoc2 == null ? -1 : childrenInDoc2.size() - 1;
        while (list1StartIndex <= list1EndIndex && list2StartIndex <= list2EndIndex) {
            childInDoc1 = (XMLResourceElement)childrenInDoc1.get(list1StartIndex);
            childInDoc2 = (XMLResourceElement)childrenInDoc2.get(list2StartIndex);
            if (childInDoc1.getMatchingElement(this._diffIteration) == null || childInDoc1.getMatchingElement(this._diffIteration) != childInDoc2) break;
            if (this.isElementValueChanged(childInDoc1, ignoreWhitespace)) {
                this.setDifferenceType(childInDoc1, DifferenceType.CHANGED, false);
            }
            ++list1StartIndex;
            ++list2StartIndex;
        }
        while (list1StartIndex <= list1EndIndex && list2StartIndex <= list2EndIndex) {
            childInDoc1 = (XMLResourceElement)childrenInDoc1.get(list1EndIndex);
            childInDoc2 = (XMLResourceElement)childrenInDoc2.get(list2EndIndex);
            if (childInDoc1.getMatchingElement(this._diffIteration) == null || childInDoc1.getMatchingElement(this._diffIteration) != childInDoc2) break;
            if (this.isElementValueChanged(childInDoc1, ignoreWhitespace)) {
                this.setDifferenceType(childInDoc1, DifferenceType.CHANGED, false);
            }
            --list1EndIndex;
            --list2EndIndex;
        }
        if (list1StartIndex > 0 && list2StartIndex > 0 && (list1StartIndex <= list1EndIndex || list2StartIndex <= list2EndIndex)) {
            --list1StartIndex;
            --list2StartIndex;
        }
        if (list1StartIndex <= list1EndIndex) {
            childrenInDoc1 = childrenInDoc1.subList(list1StartIndex, list1EndIndex + 1);
        } else if (childrenInDoc1 != null) {
            childrenInDoc1.clear();
        }
        if (list2StartIndex <= list2EndIndex) {
            childrenInDoc2 = childrenInDoc2.subList(list2StartIndex, list2EndIndex + 1);
        } else if (childrenInDoc2 != null) {
            childrenInDoc2.clear();
        }
        if (childrenInDoc1 != null && childrenInDoc1.size() > 0 || childrenInDoc2 != null && childrenInDoc2.size() > 0) {
            CompareResultElement[] resultElements = new TextDiffAlgorithmForDiffEngineXML(null).compare(childrenInDoc1 == null ? new ComparableElement[]{} : childrenInDoc1.toArray(new ComparableElement[0]), childrenInDoc2 == null ? new ComparableElement[]{} : childrenInDoc2.toArray(new ComparableElement[0]), null, ignoreWhitespace, true, createUpdates);
            XMLResourceElement predecessor = null;
            int i = 0;
            while (i < resultElements.length) {
                if (resultElements[i].getDifferenceType() == DifferenceType.UNCHANGED) {
                    XMLResourceElement e = (XMLResourceElement)resultElements[i].getComparableElement(ContributorSequence.BASE_OBJECT);
                    CompareResultElement r = resultElements[i];
                    e.setMatchingElement((XMLResourceElement)r.getUpdate(0), this._diffIteration);
                    if (this.isElementValueChanged(e, ignoreWhitespace)) {
                        this.setDifferenceType(e, DifferenceType.CHANGED, false);
                    }
                    predecessor = e;
                }
                if (resultElements[i].getDifferenceType() == DifferenceType.CHANGED) {
                    XMLResourceElement e = (XMLResourceElement)resultElements[i].getComparableElement(ContributorSequence.BASE_OBJECT);
                    if (e == null) {
                        e = new XMLCharacterBlockLine(null);
                        this._treeMutations.add(new TreeMutation(parent1, e, predecessor, this._diffIteration, ignoreWhitespace));
                    }
                    CompareResultElement r = resultElements[i];
                    e.setMatchingElement((XMLResourceElement)r.getUpdate(0), this._diffIteration);
                    if (this._diffIteration != 1 || e._diffStatus[this._diffIteration - 1] != DifferenceType.ADDED || e.getMatchingElement(this._diffIteration) != null) {
                        this.setDifferenceType(e, DifferenceType.CHANGED, false);
                    }
                    predecessor = e;
                } else if (resultElements[i].getDifferenceType() == DifferenceType.ADDED) {
                    XMLResourceElement e = (XMLResourceElement)resultElements[i].getComparableElement(ContributorSequence.FIRST_OBJECT);
                    if (e.getMatchingElement(this._diffIteration) == null) {
                        this.setDifferenceType(e, DifferenceType.ADDED, true);
                        this._treeMutations.add(new TreeMutation(parent1, e, predecessor, this._diffIteration, ignoreWhitespace));
                    } else {
                        if (!e._subtreeMatched) {
                            this.matchChildren(e, e.getMatchingElement(this._diffIteration), ignoreWhitespace);
                        }
                        this.setDifferenceType(e, DifferenceType.MOVED_TO, true);
                        this._treeMutations.add(new TreeMutation(parent1, e, predecessor, this._diffIteration, ignoreWhitespace));
                    }
                    predecessor = e;
                } else if (resultElements[i].getDifferenceType() == DifferenceType.DELETED) {
                    XMLResourceElement e = (XMLResourceElement)resultElements[i].getComparableElement(ContributorSequence.BASE_OBJECT);
                    if (e.getMatchingElement(this._diffIteration) == null) {
                        this.setDifferenceType(e, DifferenceType.DELETED, true);
                    } else {
                        if (!e._subtreeMatched) {
                            this.matchChildren(e, e.getMatchingElement(this._diffIteration), ignoreWhitespace);
                        }
                        this.setDifferenceType(e, DifferenceType.MOVED_FROM, true);
                    }
                    predecessor = e;
                }
                ++i;
            }
        }
    }

    private boolean isElementValueChanged(XMLResourceElement element, boolean ignoreWhitespace) {
        XMLResourceElement matchingElement = element.getMatchingElement(this._diffIteration);
        if (matchingElement != null) {
            if (element.getValue(ignoreWhitespace) == null && matchingElement.getValue(ignoreWhitespace) == null) {
                return false;
            }
            if (element.getValue(ignoreWhitespace) != null && matchingElement.getValue(ignoreWhitespace) != null) {
                return element.getValue(ignoreWhitespace).equals(matchingElement.getValue(ignoreWhitespace)) ^ true;
            }
            return true;
        }
        return true;
    }

    protected void setDifferenceType(XMLResourceElement element, DifferenceType differenceType, boolean includeChildren) {
        element._diffStatus[this._diffIteration] = differenceType;
        this.startDifference(element);
        if (includeChildren) {
            Iterator children = element.getDiffChildren();
            while (children != null && children.hasNext()) {
                this.setDifferenceType((XMLResourceElement)children.next(), differenceType, includeChildren);
            }
        }
    }

    private void startDifference(XMLResourceElement element) {
        if (element._diffStatus[this._diffIteration] == DifferenceType.CHANGED) {
            element._differenceIdentifier = ++this._differenceCounter;
        } else if (element._diffStatus[this._diffIteration] != DifferenceType.UNCHANGED && element._diffStatus[this._diffIteration] != DifferenceType.MOVED_TO) {
            element._differenceIdentifier = element.getXMLParent() == null || element._diffStatus[this._diffIteration] != element.getXMLParent()._diffStatus[this._diffIteration] ? ++this._differenceCounter : this._differenceCounter;
            if (element._diffStatus[this._diffIteration] == DifferenceType.MOVED_FROM && element.getMatchingElement(this._diffIteration) != null) {
                element.getMatchingElement((int)this._diffIteration)._differenceIdentifier = element._differenceIdentifier;
            }
        }
    }

    public DiffEngineXML() {
        this.$init$();
    }

    private static class TreeMutation {
        private final XMLResourceElement _parent;
        private final XMLResourceElement _e;
        private final XMLResourceElement _predecessor;
        private final int _iteration;
        private final boolean _ignoreWhitespace;

        TreeMutation(XMLResourceElement parent, XMLResourceElement e, XMLResourceElement predecessor, int iteration, boolean ignoreWhitespace) {
            this._parent = parent;
            this._e = e;
            this._predecessor = predecessor;
            this._iteration = iteration;
            this._ignoreWhitespace = ignoreWhitespace;
        }

        void execute() {
            this._e.setMutationDiffIteration(this._iteration);
            if (this._iteration == 0 || !this.consolidateExistingMutation()) {
                this._parent.addDiffChildAfter(this._e, this._predecessor);
            }
        }

        private boolean consolidateExistingMutation() {
            String eStr = this.getCompareString(this._e, this._ignoreWhitespace);
            Iterator itr = this._parent.getDiffChildren();
            while (itr != null && itr.hasNext()) {
                XMLResourceElement child = (XMLResourceElement)itr.next();
                int childIteration = child.getMutationDiffIteration();
                if (childIteration < 0 || childIteration == this._iteration || this._e.getCompareType() != child.getCompareType() || !eStr.equals(this.getCompareString(child, this._ignoreWhitespace))) continue;
                if (child.getSignature(this._ignoreWhitespace) != this._e.getSignature(this._ignoreWhitespace)) {
                    child.setMatchingElement(child, childIteration);
                    child.setMatchingElement(this._e, this._iteration);
                    DifferenceType[] diffStatus = new DifferenceType[2];
                    diffStatus[childIteration] = child.getDiffStatus(childIteration);
                    diffStatus[this._iteration] = this._e.getDiffStatus(this._iteration);
                    child._diffStatus = diffStatus;
                }
                child.setMutationDiffIteration(-1);
                return true;
            }
            return false;
        }

        private String getCompareString(XMLResourceElement element, boolean ignoreWhitespace) {
            String str = element.getName() != null ? element.getName() : element.getValue(ignoreWhitespace);
            return str != null ? str : "";
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof XMLAttribute) || !(o2 instanceof XMLAttribute)) {
                return 0;
            }
            return ((XMLAttribute)o1).getName().compareTo(((XMLAttribute)o2).getName());
        }
    }

    private class XMLResourceElementPriorityQueue {
        private LinkedList _queue = new LinkedList();
        private LinkedList _weights = new LinkedList();
        private LinkedList _signatures = new LinkedList();

        private XMLResourceElementPriorityQueue() {
        }

        private void enQueue(XMLResourceElement element, long weight, long signature) {
            int i = 0;
            while (i < this._queue.size() && !DiffEngineXML.this.isCanceled()) {
                if ((Long)this._weights.get(i) < weight) {
                    this._queue.add(i, element);
                    this._weights.add(i, weight);
                    this._signatures.add(i, signature);
                    return;
                }
                ++i;
            }
            this._queue.add(element);
            this._weights.add(weight);
            this._signatures.add(signature);
        }

        private boolean containsDuplicateSignatures(long signature) {
            return this._signatures.indexOf(signature) != this._signatures.lastIndexOf(signature);
        }

        private Iterator getElements() {
            return this._queue.iterator();
        }

        private XMLResourceElement get(int index) {
            if (index >= 0 && index < this.size()) {
                return (XMLResourceElement)this._queue.get(index);
            }
            return null;
        }

        private boolean isEmpty() {
            return this._queue == null ? true : this._queue.isEmpty();
        }

        private int size() {
            return this._queue == null ? 0 : this._queue.size();
        }

        private void clear() {
            this._queue.clear();
            this._weights.clear();
            this._signatures.clear();
        }

        private XMLResourceElement remove(XMLResourceElement element) {
            return this.remove(this._queue.indexOf(element));
        }

        private XMLResourceElement removeHead() {
            return this.remove(0);
        }

        private void removeElements(long signature) {
            Long sig = signature;
            while (this._signatures.contains(sig)) {
                this.remove(this._signatures.indexOf(sig));
            }
        }

        private XMLResourceElement remove(int index) {
            if (index >= 0 && index < this.size()) {
                this._weights.remove(index);
                this._signatures.remove(index);
                return (XMLResourceElement)this._queue.remove(index);
            }
            return null;
        }

        static XMLResourceElement mav$remove(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue, XMLResourceElement xMLResourceElement) {
            return xMLResourceElementPriorityQueue.remove(xMLResourceElement);
        }

        static Iterator mav$getElements(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue) {
            return xMLResourceElementPriorityQueue.getElements();
        }

        static XMLResourceElement mav$get(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue, int n) {
            return xMLResourceElementPriorityQueue.get(n);
        }

        static boolean mav$containsDuplicateSignatures(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue, long l) {
            return xMLResourceElementPriorityQueue.containsDuplicateSignatures(l);
        }

        static XMLResourceElement mav$removeHead(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue) {
            return xMLResourceElementPriorityQueue.removeHead();
        }

        static void mav$removeElements(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue, long l) {
            xMLResourceElementPriorityQueue.removeElements(l);
        }

        static boolean mav$isEmpty(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue) {
            return xMLResourceElementPriorityQueue.isEmpty();
        }

        static void mav$enQueue(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue, XMLResourceElement xMLResourceElement, long l, long l2) {
            xMLResourceElementPriorityQueue.enQueue(xMLResourceElement, l, l2);
        }

        XMLResourceElementPriorityQueue(1 var2_2) {
            this();
        }

        static void mav$clear(XMLResourceElementPriorityQueue xMLResourceElementPriorityQueue) {
            xMLResourceElementPriorityQueue.clear();
        }

        public final class 1 {
        }
    }

    private class TextDiffAlgorithmForDiffEngineXML
    extends TextDiffAlgorithm {
        protected boolean isContentsEqual(ComparableElement element1, ComparableElement element2, boolean ignoreWhitespace) {
            XMLResourceElement e1 = (XMLResourceElement)element1;
            XMLResourceElement e2 = (XMLResourceElement)element2;
            if (e1.getCompareType() != e2.getCompareType()) {
                return false;
            }
            String line1 = e1.getCompareString(DiffEngineXML.this._diffIteration, ignoreWhitespace);
            String line2 = e2.getCompareString(DiffEngineXML.this._diffIteration, ignoreWhitespace);
            if (line1 == null && line2 == null) {
                return true;
            }
            if (line1 != null && line2 != null) {
                return line1.equals(line2);
            }
            return false;
        }

        private TextDiffAlgorithmForDiffEngineXML() {
        }

        TextDiffAlgorithmForDiffEngineXML(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

