/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.engine;

import java.util.Iterator;
import oracle.xmlc.engine.ComparatorEngine;
import oracle.xmlc.engine.CompareResult;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.engine.DiffEngineXML;
import oracle.xmlc.engine.DifferenceSequence;
import oracle.xmlc.engine.DifferenceType;
import oracle.xmlc.engine.MergeRequest;
import oracle.xmlc.model.XMLResourceElement;

public class MergeEngineXML
extends ComparatorEngine {
    private DiffEngineXML _diffEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        super.cancel();
        MergeEngineXML mergeEngineXML = this;
        synchronized (mergeEngineXML) {
            if (this._diffEngine != null) {
                this._diffEngine.cancel();
            }
        }
    }

    public CompareResult merge(MergeRequest mergeRequest, boolean ignoreWhitespace) {
        if (mergeRequest.getCommonAncestorContents() == null) {
            throw new UnsupportedOperationException();
        }
        XMLResourceElement resultElement = this.threeWayMerge(mergeRequest, ignoreWhitespace);
        return new CompareResult(mergeRequest, resultElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLResourceElement threeWayMerge(MergeRequest mergeRequest, boolean ignoreWhitespace) {
        MergeEngineXML mergeEngineXML = this;
        synchronized (mergeEngineXML) {
            if (this.isCanceled()) {
                XMLResourceElement xMLResourceElement = null;
                return xMLResourceElement;
            }
            this._diffEngine = new DiffEngineXML();
        }
        XMLResourceElement commonAncestor = mergeRequest.getCommonAncestorContents();
        XMLResourceElement source = mergeRequest.getSourceContents();
        XMLResourceElement target = mergeRequest.getTargetContents();
        commonAncestor = this._diffEngine.compare(commonAncestor, source, ignoreWhitespace);
        commonAncestor = this._diffEngine.compare(commonAncestor, target, ignoreWhitespace);
        this._diffEngine.executeTreeMutations();
        if (this.isCanceled()) {
            return null;
        }
        this.threeWayMergeDefaultSelections(commonAncestor, ignoreWhitespace);
        MergeEngineXML mergeEngineXML2 = this;
        synchronized (mergeEngineXML2) {
            this._diffEngine = null;
        }
        return commonAncestor;
    }

    protected void threeWayMergeDefaultSelections(XMLResourceElement element, boolean ignoreWhitespace) {
        if (element == null) {
            return;
        }
        DifferenceType firstDiffStatus = element._diffStatus[DifferenceSequence.FIRST.ordinal()];
        DifferenceType secondDiffStatus = element._diffStatus[DifferenceSequence.SECOND.ordinal()];
        boolean checkChildren = true;
        if (firstDiffStatus == DifferenceType.UNCHANGED && secondDiffStatus == DifferenceType.UNCHANGED) {
            element.select(ContributorSequence.SECOND_OBJECT);
            checkChildren = true;
        } else if (firstDiffStatus == DifferenceType.UNCHANGED && secondDiffStatus == DifferenceType.CHANGED) {
            element.select(ContributorSequence.SECOND_OBJECT);
            checkChildren = true;
        } else if (firstDiffStatus == DifferenceType.CHANGED && secondDiffStatus == DifferenceType.UNCHANGED) {
            element.select(ContributorSequence.FIRST_OBJECT);
            checkChildren = true;
        } else if (firstDiffStatus == DifferenceType.CHANGED && secondDiffStatus == DifferenceType.CHANGED) {
            if (element.getComparableElement(ContributorSequence.FIRST_OBJECT) != null && element.getComparableElement(ContributorSequence.SECOND_OBJECT) != null) {
                long firstSignature = ((XMLResourceElement)element.getComparableElement(ContributorSequence.FIRST_OBJECT)).getSignature(ignoreWhitespace);
                long firstWeight = ((XMLResourceElement)element.getComparableElement(ContributorSequence.FIRST_OBJECT)).getWeight(ignoreWhitespace);
                long secondSignature = ((XMLResourceElement)element.getComparableElement(ContributorSequence.SECOND_OBJECT)).getSignature(ignoreWhitespace);
                long secondWeight = ((XMLResourceElement)element.getComparableElement(ContributorSequence.SECOND_OBJECT)).getWeight(ignoreWhitespace);
                if (firstSignature == secondSignature && firstWeight == secondWeight) {
                    element.select(ContributorSequence.SECOND_OBJECT);
                    checkChildren = true;
                }
            }
        } else if (firstDiffStatus == DifferenceType.MOVED_TO && this.isMoveFromSameElement(element, DifferenceSequence.FIRST)) {
            XMLResourceElement match = element.getMatchingElement(DifferenceSequence.FIRST.ordinal());
            XMLResourceElement other = match.getMatchingElement(DifferenceSequence.SECOND.ordinal());
            if (Math.abs(match.getXMLParent().getDiffChildList().indexOf(element) - match.getXMLParent().getDiffChildList().indexOf(other)) <= 1) {
                element.select(ContributorSequence.SECOND_OBJECT);
            }
            checkChildren = false;
        } else if (secondDiffStatus == DifferenceType.MOVED_TO && this.isMoveFromSameElement(element, DifferenceSequence.SECOND)) {
            XMLResourceElement match = element.getMatchingElement(DifferenceSequence.SECOND.ordinal());
            XMLResourceElement other = match.getMatchingElement(DifferenceSequence.FIRST.ordinal());
            if (Math.abs(match.getXMLParent().getDiffChildList().indexOf(element) - match.getXMLParent().getDiffChildList().indexOf(other)) <= 1) {
                element.select(ContributorSequence.SECOND_OBJECT);
            }
            checkChildren = false;
        } else if (firstDiffStatus == DifferenceType.MOVED_FROM && secondDiffStatus == DifferenceType.MOVED_FROM) {
            Iterator subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                XMLResourceElement e = (XMLResourceElement)subtree.next();
                e.select(ContributorSequence.SECOND_OBJECT);
            }
            checkChildren = false;
        } else if (firstDiffStatus == DifferenceType.ADDED && secondDiffStatus == DifferenceType.ADDED) {
            boolean hasConflicts = false;
            Iterator subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                XMLResourceElement e = (XMLResourceElement)subtree.next();
                XMLResourceElement firstAddition = (XMLResourceElement)e.getComparableElement(ContributorSequence.FIRST_OBJECT);
                XMLResourceElement secondAddition = (XMLResourceElement)e.getComparableElement(ContributorSequence.SECOND_OBJECT);
                if (firstAddition != null && secondAddition != null) {
                    String firstAdditionName = firstAddition.getName();
                    String secondAdditionName = secondAddition.getName();
                    if (firstAdditionName != null && secondAdditionName != null && !firstAdditionName.equals(secondAdditionName)) {
                        hasConflicts = true;
                        break;
                    }
                    if (firstAdditionName == null && secondAdditionName != null || firstAdditionName != null && secondAdditionName == null) {
                        hasConflicts = true;
                        break;
                    }
                    String firstAdditionValue = firstAddition.getValue(ignoreWhitespace);
                    String secondAdditionValue = secondAddition.getValue(ignoreWhitespace);
                    if (firstAdditionValue != null && secondAdditionValue != null && !firstAdditionValue.equals(secondAdditionValue)) {
                        hasConflicts = true;
                        break;
                    }
                    if ((firstAdditionValue != null || secondAdditionValue == null) && (firstAdditionValue == null || secondAdditionValue != null)) continue;
                    hasConflicts = true;
                    break;
                }
                if ((firstAddition != null || secondAddition == null) && (firstAddition == null || secondAddition != null)) continue;
                hasConflicts = true;
                break;
            }
            if (!hasConflicts) {
                subtree = element.preorderIterator();
                while (subtree != null && subtree.hasNext()) {
                    XMLResourceElement e = (XMLResourceElement)subtree.next();
                    e.select(ContributorSequence.SECOND_OBJECT);
                }
            }
            checkChildren = false;
        } else if ((firstDiffStatus == DifferenceType.ADDED || firstDiffStatus == DifferenceType.MOVED_TO) && secondDiffStatus != DifferenceType.CHANGED) {
            boolean hasConflicts = false;
            Iterator subtree = element.preorderIterator();
            XMLResourceElement e = (XMLResourceElement)subtree.next();
            DifferenceType topLevelSecondDiffStatus = e._diffStatus[DifferenceSequence.SECOND.ordinal()];
            int topLevelDifferenceIdentifier = e._differenceIdentifier;
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (topLevelSecondDiffStatus == e._diffStatus[DifferenceSequence.SECOND.ordinal()]) continue;
                hasConflicts = true;
                break;
            }
            subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (!hasConflicts) {
                    e.select(ContributorSequence.FIRST_OBJECT);
                }
                e._differenceIdentifier = topLevelDifferenceIdentifier;
            }
            checkChildren = false;
        } else if ((secondDiffStatus == DifferenceType.ADDED || secondDiffStatus == DifferenceType.MOVED_TO) && firstDiffStatus != DifferenceType.CHANGED) {
            boolean hasConflicts = false;
            Iterator subtree = element.preorderIterator();
            XMLResourceElement e = (XMLResourceElement)subtree.next();
            DifferenceType topLevelFirstDiffStatus = e._diffStatus[DifferenceSequence.FIRST.ordinal()];
            int topLevelDifferenceIdentifier = e._differenceIdentifier;
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (topLevelFirstDiffStatus == e._diffStatus[DifferenceSequence.FIRST.ordinal()]) continue;
                hasConflicts = true;
                break;
            }
            subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (!hasConflicts) {
                    e.select(ContributorSequence.SECOND_OBJECT);
                }
                e._differenceIdentifier = topLevelDifferenceIdentifier;
            }
            checkChildren = false;
        } else if (firstDiffStatus == DifferenceType.DELETED && secondDiffStatus == DifferenceType.DELETED) {
            Iterator subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                XMLResourceElement e = (XMLResourceElement)subtree.next();
                e.select(ContributorSequence.SECOND_OBJECT);
            }
            checkChildren = false;
        } else if ((firstDiffStatus == DifferenceType.DELETED || firstDiffStatus == DifferenceType.MOVED_FROM) && secondDiffStatus != DifferenceType.CHANGED) {
            boolean hasConflicts = false;
            Iterator subtree = element.preorderIterator();
            XMLResourceElement e = (XMLResourceElement)subtree.next();
            DifferenceType topLevelSecondDiffStatus = e._diffStatus[DifferenceSequence.SECOND.ordinal()];
            int topLevelDifferenceIdentifier = e._differenceIdentifier;
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (topLevelSecondDiffStatus == e._diffStatus[DifferenceSequence.SECOND.ordinal()]) continue;
                hasConflicts = true;
                break;
            }
            subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (!hasConflicts) {
                    e.select(ContributorSequence.FIRST_OBJECT);
                }
                e._differenceIdentifier = topLevelDifferenceIdentifier;
            }
            checkChildren = false;
        } else if ((secondDiffStatus == DifferenceType.DELETED || secondDiffStatus == DifferenceType.MOVED_FROM) && firstDiffStatus != DifferenceType.CHANGED) {
            boolean hasConflicts = false;
            Iterator subtree = element.preorderIterator();
            XMLResourceElement e = (XMLResourceElement)subtree.next();
            DifferenceType topLevelFirstDiffStatus = e._diffStatus[DifferenceSequence.FIRST.ordinal()];
            int topLevelDifferenceIdentifier = e._differenceIdentifier;
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (topLevelFirstDiffStatus == e._diffStatus[DifferenceSequence.FIRST.ordinal()]) continue;
                hasConflicts = true;
                break;
            }
            subtree = element.preorderIterator();
            while (subtree != null && subtree.hasNext()) {
                e = (XMLResourceElement)subtree.next();
                if (!hasConflicts) {
                    e.select(ContributorSequence.SECOND_OBJECT);
                }
                e._differenceIdentifier = topLevelDifferenceIdentifier;
            }
            checkChildren = false;
        }
        if (checkChildren) {
            Iterator children = element.getDiffChildren();
            while (children != null && children.hasNext()) {
                this.threeWayMergeDefaultSelections((XMLResourceElement)children.next(), ignoreWhitespace);
            }
        }
    }

    private boolean isMoveFromSameElement(XMLResourceElement element, DifferenceSequence diffSequence) {
        XMLResourceElement match = element.getMatchingElement(diffSequence.ordinal());
        if (match == null) {
            return false;
        }
        if (match.getDiffStatus(DifferenceSequence.FIRST.ordinal()) != DifferenceType.MOVED_FROM) {
            return false;
        }
        return match.getDiffStatus(DifferenceSequence.SECOND.ordinal()) == DifferenceType.MOVED_FROM;
    }
}

