/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import oracle.xmlc.engine.ComparableElement;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.engine.DifferenceSequence;
import oracle.xmlc.engine.DifferenceType;
import oracle.xmlc.model.XMLAttribute;

public abstract class XMLResourceElement
extends ComparableElement {
    private String _name;
    private String _value;
    private String _valueWithoutWhitespace;
    private XMLResourceElement _parent;
    private List _diffChildren;
    private long _signature;
    private long _weight;
    public DifferenceType[] _diffStatus;
    public XMLResourceElement[] _match;
    public int _differenceIdentifier;
    private ContributorSequence _selectedContributor;
    public boolean _subtreeMatched;
    private int _mutationDiffIteration;

    private void $init$() {
        this._signature = -1;
        this._weight = -1;
        this._diffStatus = new DifferenceType[]{DifferenceType.UNCHANGED, DifferenceType.UNCHANGED};
        this._match = new XMLResourceElement[2];
        this._differenceIdentifier = 0;
        this._selectedContributor = null;
        this._mutationDiffIteration = -1;
    }

    protected XMLResourceElement(String name) {
        this.$init$();
        this._name = name != null ? name.trim() : name;
    }

    protected XMLResourceElement(String name, String value) {
        this.$init$();
        this._name = name != null ? name.trim() : name;
        this._value = value;
    }

    public void setMutationDiffIteration(int mutationDiffIteration) {
        this._mutationDiffIteration = mutationDiffIteration;
    }

    public int getMutationDiffIteration() {
        return this._mutationDiffIteration;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean ignoreWhitespace) {
        if (this._value == null) {
            return null;
        }
        if (!ignoreWhitespace) {
            return this._value;
        }
        if (this._valueWithoutWhitespace == null) {
            this._valueWithoutWhitespace = "";
            StringTokenizer st = new StringTokenizer(this._value);
            while (st.hasMoreTokens()) {
                this._valueWithoutWhitespace = this._valueWithoutWhitespace + st.nextToken();
            }
        }
        return this._valueWithoutWhitespace;
    }

    public XMLResourceElement getXMLParent() {
        return this._parent;
    }

    protected void setXMLParent(XMLResourceElement parent) {
        this._parent = parent;
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(new XMLAttribute(name, value));
    }

    private void addAttribute(XMLAttribute attribute) {
        this.addDiffChild(attribute);
    }

    protected Iterator getAttributes() {
        return this.getAttributeList() == null ? null : this.getAttributeList().iterator();
    }

    private List getAttributeList() {
        ArrayList<XMLResourceElement> attributeList = new ArrayList<XMLResourceElement>();
        Iterator itr = this._diffChildren != null ? this._diffChildren.iterator() : null;
        while (itr != null && itr.hasNext()) {
            XMLResourceElement child = (XMLResourceElement)itr.next();
            if (!(child instanceof XMLAttribute)) continue;
            attributeList.add(child);
        }
        return attributeList;
    }

    public void addChildElement(XMLResourceElement child) {
        this.addDiffChild(child);
    }

    public int getChildElementCount() {
        return this.getChildElementList() == null ? 0 : this.getChildElementList().size();
    }

    public Iterator getChildElements() {
        return this.getChildElementList() == null ? null : this.getChildElementList().iterator();
    }

    public List getChildElementList() {
        ArrayList<XMLResourceElement> childElementList = new ArrayList<XMLResourceElement>();
        Iterator itr = this._diffChildren != null ? this._diffChildren.iterator() : null;
        while (itr != null && itr.hasNext()) {
            XMLResourceElement child = (XMLResourceElement)itr.next();
            if (child instanceof XMLAttribute) continue;
            childElementList.add(child);
        }
        return childElementList;
    }

    public void addDiffChild(XMLResourceElement diffChild) {
        diffChild.setXMLParent(this);
        if (this._diffChildren == null) {
            this._diffChildren = new ArrayList();
        }
        this._diffChildren.add(diffChild);
    }

    public void removeDiffChild(XMLResourceElement diffChild) {
        if (this._diffChildren != null) {
            this._diffChildren.remove(diffChild);
        }
    }

    public void addDiffChildAfter(XMLResourceElement diffChild, XMLResourceElement predecessor) {
        int index = predecessor != null && this._diffChildren != null ? this._diffChildren.indexOf(predecessor) : -1;
        diffChild.setXMLParent(this);
        if (this._diffChildren == null) {
            this._diffChildren = new ArrayList();
        }
        this._diffChildren.add(index + 1, diffChild);
    }

    public Iterator getDiffChildren() {
        List diffChildren = this.getDiffChildList();
        return diffChildren == null ? null : diffChildren.iterator();
    }

    public List getDiffChildList() {
        return this._diffChildren != null ? Collections.unmodifiableList(this._diffChildren) : null;
    }

    public long getSignature(boolean ignoreWhitespace) {
        return this.computeSignature(ignoreWhitespace);
    }

    private long computeSignature(boolean ignoreWhitespace) {
        if (this._signature == (long)-1) {
            this._signature = this.computeSignatureImpl(ignoreWhitespace);
            Iterator itr = this.getDiffChildren();
            while (itr != null && itr.hasNext()) {
                XMLResourceElement diffChild = (XMLResourceElement)itr.next();
                this._signature += diffChild.computeSignature(ignoreWhitespace);
            }
        }
        return this._signature;
    }

    public long getWeight(boolean ignoreWhitespace) {
        return this.computeWeight(ignoreWhitespace);
    }

    private long computeWeight(boolean ignoreWhitespace) {
        if (this._weight == (long)-1) {
            this._weight = this.computeWeightImpl(ignoreWhitespace);
            Iterator itr = this.getDiffChildren();
            while (itr != null && itr.hasNext()) {
                XMLResourceElement diffChild = (XMLResourceElement)itr.next();
                if (diffChild instanceof XMLAttribute) {
                    this._weight += (long)diffChild.getValue(ignoreWhitespace).length();
                    continue;
                }
                this._weight += diffChild.computeWeight(ignoreWhitespace);
            }
        }
        return this._weight;
    }

    protected long computeSignatureImpl(boolean ignoreWhitespace) {
        return (this.getName() == null ? 0 : this.getName().hashCode()) + (this.getValue(ignoreWhitespace) == null ? 0 : this.getValue(ignoreWhitespace).hashCode());
    }

    protected long computeWeightImpl(boolean ignoreWhitespace) {
        return 1 + (this.getValue(ignoreWhitespace) == null ? 0 : this.getValue(ignoreWhitespace).length());
    }

    public boolean hasUniqueSignatureWithinParent(boolean ignoreWhitespace) {
        if (this.getXMLParent() != null) {
            int i = 0;
            Iterator diffChildren = this.getXMLParent().getDiffChildren();
            while (diffChildren != null && diffChildren.hasNext()) {
                XMLResourceElement diffChild = (XMLResourceElement)diffChildren.next();
                if (diffChild.getSignature(ignoreWhitespace) != this.getSignature(ignoreWhitespace) || ++i <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public XMLResourceElement getMatchingElement(int diffIteration) {
        return this._match[diffIteration];
    }

    public void setMatchingElement(XMLResourceElement newMatch, int diffIteration) {
        if (this._match[diffIteration] != newMatch) {
            if (this._match[diffIteration] != null) {
                XMLResourceElement temp = this._match[diffIteration];
                this._match[diffIteration] = null;
                temp.setMatchingElement(null, diffIteration);
            }
            this._match[diffIteration] = newMatch;
            if (newMatch != null) {
                newMatch.setMatchingElement(this, diffIteration);
            }
        }
    }

    public boolean startsDifference() {
        if (this.getDifferenceType() != DifferenceType.UNCHANGED) {
            if (this.getXMLParent() == null) {
                return true;
            }
            int parentIndex = this.getXMLParent().getDiffChildIndex(this);
            if (parentIndex > 0) {
                return this._differenceIdentifier != this.getXMLParent().getDiffChild((int)(parentIndex - 1))._differenceIdentifier;
            }
            return this._differenceIdentifier != this.getXMLParent()._differenceIdentifier;
        }
        return false;
    }

    private int getDiffChildIndex(XMLResourceElement diffChild) {
        List diffChildren = this.getDiffChildList();
        return diffChildren == null ? -1 : diffChildren.indexOf(diffChild);
    }

    private XMLResourceElement getDiffChild(int index) {
        List diffChildren = this.getDiffChildList();
        if (diffChildren != null && index >= 0 && index < diffChildren.size()) {
            return (XMLResourceElement)diffChildren.get(index);
        }
        return null;
    }

    public String getCompareString(boolean ignoreWhitespace) {
        return this.getValue(ignoreWhitespace);
    }

    public final String getCompareString(int diffIteration, boolean ignoreWhitespace) {
        String str;
        String string = str = this.getName() != null ? this.getName() : this.getValue(ignoreWhitespace);
        str = this.getMatchingElement(diffIteration) != null ? (this.getSignature(ignoreWhitespace) == this.getMatchingElement(diffIteration).getSignature(ignoreWhitespace) ? str + this.getSignature(ignoreWhitespace) : str + "M") : str + "null";
        return str;
    }

    public String getCompareDisplayString() {
        return this.getName();
    }

    public DifferenceType getDiffStatus(int diffIteration) {
        return this._diffStatus[diffIteration];
    }

    public DifferenceType getDifferenceType() {
        DifferenceType firstDiffStatus = this._diffStatus[DifferenceSequence.FIRST.ordinal()];
        DifferenceType secondDiffStatus = this._diffStatus[DifferenceSequence.SECOND.ordinal()];
        if (firstDiffStatus == DifferenceType.CHANGED || secondDiffStatus == DifferenceType.CHANGED) {
            return DifferenceType.CHANGED;
        }
        if (firstDiffStatus == DifferenceType.ADDED || secondDiffStatus == DifferenceType.ADDED) {
            return DifferenceType.ADDED;
        }
        if (firstDiffStatus == DifferenceType.MOVED_TO || secondDiffStatus == DifferenceType.MOVED_TO) {
            return DifferenceType.MOVED_TO;
        }
        if (firstDiffStatus == DifferenceType.DELETED || secondDiffStatus == DifferenceType.DELETED) {
            return DifferenceType.DELETED;
        }
        if (firstDiffStatus == DifferenceType.MOVED_FROM || secondDiffStatus == DifferenceType.MOVED_FROM) {
            return DifferenceType.MOVED_FROM;
        }
        return DifferenceType.UNCHANGED;
    }

    public ComparableElement getComparableElement(ContributorSequence whichContributor) {
        DifferenceType firstDiffStatus = this._diffStatus[DifferenceSequence.FIRST.ordinal()];
        DifferenceType secondDiffStatus = this._diffStatus[DifferenceSequence.SECOND.ordinal()];
        if (whichContributor == ContributorSequence.BASE_OBJECT) {
            if (firstDiffStatus != DifferenceType.ADDED && secondDiffStatus != DifferenceType.ADDED && firstDiffStatus != DifferenceType.MOVED_TO && secondDiffStatus != DifferenceType.MOVED_TO) {
                return this;
            }
        } else {
            if (whichContributor == ContributorSequence.FIRST_OBJECT) {
                if (firstDiffStatus == DifferenceType.ADDED || firstDiffStatus == DifferenceType.MOVED_TO) {
                    return this;
                }
                if (firstDiffStatus == DifferenceType.DELETED || firstDiffStatus == DifferenceType.MOVED_FROM) {
                    return null;
                }
                return this._match[whichContributor.ordinal() - 1];
            }
            if (whichContributor == ContributorSequence.SECOND_OBJECT) {
                if (secondDiffStatus == DifferenceType.ADDED || secondDiffStatus == DifferenceType.MOVED_TO) {
                    if (firstDiffStatus == DifferenceType.ADDED || firstDiffStatus == DifferenceType.MOVED_TO) {
                        return this._match[whichContributor.ordinal() - 1];
                    }
                    return this;
                }
                if (secondDiffStatus == DifferenceType.DELETED || secondDiffStatus == DifferenceType.MOVED_FROM) {
                    return null;
                }
                return this._match[whichContributor.ordinal() - 1];
            }
        }
        return null;
    }

    public String getCompareDisplayString(ContributorSequence whichContributor) {
        if (whichContributor == null) {
            return "*** CONFLICT ***";
        }
        ComparableElement element = this.getComparableElement(whichContributor);
        if (element != null) {
            return element.getCompareDisplayString();
        }
        return null;
    }

    public int getIndex() {
        throw new UnsupportedOperationException("getIndex ()");
    }

    public boolean select(ContributorSequence whichContributor) {
        if (this.getSelectedContributor() == whichContributor) {
            return false;
        }
        if (this.getDifferenceType() == DifferenceType.UNCHANGED) {
            this._selectedContributor = whichContributor;
        } else {
            XMLResourceElement topLevelChangedElement = this;
            while (topLevelChangedElement.getXMLParent() != null && this._differenceIdentifier == topLevelChangedElement.getXMLParent()._differenceIdentifier) {
                topLevelChangedElement = topLevelChangedElement.getXMLParent();
            }
            Iterator elements = topLevelChangedElement.preorderIterator();
            while (elements != null && elements.hasNext()) {
                XMLResourceElement element = (XMLResourceElement)elements.next();
                if (topLevelChangedElement._differenceIdentifier != element._differenceIdentifier) continue;
                element._selectedContributor = whichContributor;
            }
        }
        return true;
    }

    public boolean deselect(ContributorSequence whichContributor) {
        if (this.getSelectedContributor() != whichContributor) {
            return false;
        }
        return this.select(null);
    }

    public ContributorSequence getSelectedContributor() {
        return this._selectedContributor;
    }

    public Iterator preorderIterator() {
        return new PreorderIterator(null);
    }

    public String getSavingStartTag() {
        ComparableElement element = this.getComparableElement(this.getSelectedContributor());
        if (element != null) {
            String startTag = '<' + this.getName();
            Iterator attributes = this.getAttributes();
            while (attributes != null && attributes.hasNext()) {
                String attributeStartTag = ((XMLResourceElement)attributes.next()).getSavingStartTag();
                if (attributeStartTag == null) continue;
                startTag = startTag + ' ' + attributeStartTag;
            }
            startTag = this.getChildElementCount() == 0 ? startTag + "/>" : startTag + '>';
            return startTag;
        }
        return null;
    }

    public boolean isChildElementIndented() {
        return true;
    }

    public String getSavingEndTag() {
        ComparableElement element = this.getComparableElement(this.getSelectedContributor());
        if (element != null) {
            return "</" + this.getName() + '>';
        }
        return null;
    }

    public int getCompareType() {
        return this.getClass().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PreorderIterator
    implements Iterator {
        private Stack<Iterator> _stack = new Stack();

        private PreorderIterator() {
            LinkedList<XMLResourceElement> list = new LinkedList<XMLResourceElement>();
            list.add(XMLResourceElement.this);
            this._stack.push(list.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this._stack.empty() && this._stack.peek().hasNext();
        }

        public Object next() {
            Iterator iterator = this._stack.peek();
            XMLResourceElement element = (XMLResourceElement)iterator.next();
            Iterator diffChildren = element.getDiffChildren();
            if (!iterator.hasNext()) {
                this._stack.pop();
            }
            if (diffChildren != null && diffChildren.hasNext()) {
                this._stack.push(diffChildren);
            }
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        PreorderIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

