/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class ComparableElementReader
extends Reader {
    private InputStream _inputStream;

    protected ComparableElementReader(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    public int read() throws IOException {
        if (this._inputStream == null) {
            throw new IOException();
        }
        return this._inputStream.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        cbuf[off] = (char)c;
        int i = 1;
        while (i < len) {
            c = this.read();
            if (c == -1) break;
            if (cbuf != null) {
                cbuf[off + i] = (char)c;
            }
            ++i;
        }
        return i;
    }

    public void close() throws IOException {
        if (this._inputStream != null) {
            this._inputStream.close();
            this._inputStream = null;
        }
    }
}

