/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.parser;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.xmlc.parser.ResourceException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXXMLParser {
    private static SAXParserFactory saxParserFactory;
    private static SAXParser saxParser;

    private SAXXMLParser() {
    }

    public static synchronized void parse(Reader XMLFile, String systemId, DefaultHandler XMLFileContentHandler, boolean validate) throws ResourceException {
        try {
            SAXParser parser = SAXXMLParser.getSAXXMLParser(validate);
            if (XMLFileContentHandler instanceof DeclHandler) {
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", XMLFileContentHandler);
            }
            if (XMLFileContentHandler instanceof LexicalHandler) {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", XMLFileContentHandler);
            }
            parser.parse(new InputSource(XMLFile), XMLFileContentHandler);
        }
        catch (IllegalArgumentException iae) {
            throw new ResourceException(SAXXMLParser.class, 3116, iae.getMessage(), new String[]{systemId}, iae, 1);
        }
        catch (IOException ioe) {
            throw new ResourceException(SAXXMLParser.class, 3116, ioe.getMessage(), new String[]{systemId}, ioe, 1);
        }
        catch (SAXException saxe) {
            if (saxe instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)saxe;
                String[] params = new String[]{systemId, Integer.toString(spe.getLineNumber()), spe.getMessage()};
                throw new ResourceException(SAXXMLParser.class, 3117, saxe.getMessage(), params, saxe, 0);
            }
            throw new ResourceException(SAXXMLParser.class, 3117, saxe.getMessage(), new String[]{systemId, null, saxe.getMessage()}, saxe, 1);
        }
    }

    private static SAXParser getSAXXMLParser(boolean validate) throws ResourceException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
        }
        if (validate != saxParserFactory.isValidating()) {
            saxParserFactory.setValidating(validate);
            saxParser = null;
        }
        if (saxParser == null) {
            try {
                saxParser = saxParserFactory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                throw new ResourceException(SAXXMLParser.class, 3115, pce, 1);
            }
            catch (SAXException saxe) {
                throw new ResourceException(SAXXMLParser.class, 3115, saxe, 1);
            }
        }
        return saxParser;
    }
}

